/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.Arrays;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.Joiner;
import java.io.IOException;

public class Int2Vectors
extends SimpleProcProvider {
    public Int2Vectors() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new Arrays.BinEncoder(), (Type.Codec.Decoder)new Arrays.BinDecoder(), "int2vector");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Short[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Array;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.append("");
                return;
            }
            Short[] shorts = (Short[])val;
            Object[] items = new String[shorts.length];
            for (int c = 0; c < shorts.length; ++c) {
                items[c] = Short.toString(shorts[c]);
            }
            Joiner.on(' ').appendTo(buffer, items);
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Array;
        }

        @Override
        public Class<?> getOutputType() {
            return Short[].class;
        }

        @Override
        public Object decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            int length = buffer.length();
            Short[] instance = null;
            if (length != 0) {
                String[] items = buffer.toString().split(" ");
                Short[] shorts = new Short[items.length];
                for (int c = 0; c < items.length; ++c) {
                    shorts[c] = Short.parseShort(items[c]);
                }
                instance = shorts;
            }
            return instance;
        }
    }
}

