/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Identifiers;
import com.impossibl.postgres.utils.guava.Strings;
import java.sql.SQLException;
import java.sql.Savepoint;

class PGSavepoint
implements Savepoint {
    private Integer id;
    private String name;
    private boolean released;

    PGSavepoint(int id) {
        this.id = id;
    }

    PGSavepoint(String name) {
        this.name = name;
    }

    void checkValid() throws SQLException {
        if (!this.isValid()) {
            throw new SQLException("Invalid savepoint");
        }
    }

    @Override
    public int getSavepointId() throws SQLException {
        this.checkValid();
        if (this.id == null) {
            throw new SQLException("named savepoints have no id");
        }
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        this.checkValid();
        if (this.name == null) {
            throw new SQLException("auto savepoints have no name");
        }
        return this.name;
    }

    public String getId() {
        if (this.id != null) {
            return "sp_" + this.id.toString();
        }
        if (this.name != null) {
            return Identifiers.escape(this.name);
        }
        throw new IllegalStateException();
    }

    public boolean isValid() {
        return this.id != null || this.name != null;
    }

    public void invalidate() {
        this.id = null;
        this.name = null;
    }

    public boolean getReleased() {
        return this.released;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }

    public String toString() {
        return this.id != null ? this.id.toString() : Strings.nullToEmpty(this.name);
    }
}

