/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.jcache.JCacheListenerAdaptor;
import net.sf.jsr107cache.CacheListener;

public class RegisteredEventListeners {
    private final Set cacheEventListeners = new HashSet();
    private final Ehcache cache;
    private long elementsRemovedCounter;
    private long elementsPutCounter;
    private long elementsUpdatedCounter;
    private long elementsExpiredCounter;
    private long elementsEvictedCounter;
    private long elementsRemoveAllCounter;

    public RegisteredEventListeners(Ehcache cache) {
        this.cache = cache;
    }

    public final void notifyElementRemoved(Element element, boolean remoteEvent) throws CacheException {
        ++this.elementsRemovedCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementRemoved(this.cache, element);
            }
        }
    }

    public final void notifyElementPut(Element element, boolean remoteEvent) throws CacheException {
        ++this.elementsPutCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementPut(this.cache, element);
            }
        }
    }

    public final void notifyElementUpdated(Element element, boolean remoteEvent) {
        ++this.elementsUpdatedCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementUpdated(this.cache, element);
            }
        }
    }

    public final void notifyElementExpiry(Element element, boolean remoteEvent) {
        ++this.elementsExpiredCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementExpired(this.cache, element);
            }
        }
    }

    public final boolean hasCacheEventListeners() {
        return this.cacheEventListeners.size() > 0;
    }

    public void notifyElementEvicted(Element element, boolean remoteEvent) {
        ++this.elementsEvictedCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementEvicted(this.cache, element);
            }
        }
    }

    public void notifyRemoveAll(boolean remoteEvent) {
        ++this.elementsRemoveAllCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyRemoveAll(this.cache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator createThreadSafeIterator() {
        HashSet copy;
        Set set = this.cacheEventListeners;
        synchronized (set) {
            copy = new HashSet(this.cacheEventListeners);
        }
        return copy.iterator();
    }

    private static boolean isCircularNotification(boolean remoteEvent, CacheEventListener cacheEventListener) {
        return remoteEvent && cacheEventListener instanceof CacheReplicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerListener(CacheEventListener cacheEventListener) {
        boolean added;
        if (cacheEventListener == null) {
            return false;
        }
        Set set = this.cacheEventListeners;
        synchronized (set) {
            added = this.cacheEventListeners.add(cacheEventListener);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unregisterListener(CacheEventListener cacheEventListener) {
        boolean removed;
        if (cacheEventListener instanceof JCacheListenerAdaptor) {
            this.removeCacheListenerAdaptor(((JCacheListenerAdaptor)cacheEventListener).getCacheListener());
        }
        Set set = this.cacheEventListeners;
        synchronized (set) {
            removed = this.cacheEventListeners.remove(cacheEventListener);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCacheListenerAdaptor(CacheListener cacheListener) {
        Set set = this.cacheEventListeners;
        synchronized (set) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                if (!(cacheEventListener instanceof JCacheListenerAdaptor) || ((JCacheListenerAdaptor)cacheEventListener).getCacheListener() != cacheListener) continue;
                Set set2 = this.cacheEventListeners;
                synchronized (set2) {
                    this.cacheEventListeners.remove(cacheEventListener);
                    break;
                }
            }
        }
    }

    public final Set getCacheEventListeners() {
        return this.cacheEventListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Iterator iterator = this.createThreadSafeIterator();
        while (iterator.hasNext()) {
            CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
            cacheEventListener.dispose();
        }
        Set set = this.cacheEventListeners;
        synchronized (set) {
            this.cacheEventListeners.clear();
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(" cacheEventListeners: ");
        Iterator iterator = this.createThreadSafeIterator();
        while (iterator.hasNext()) {
            CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
            stringBuffer.append(cacheEventListener.getClass().getName()).append(" ");
        }
        return stringBuffer.toString();
    }

    public void clearCounters() {
        this.elementsRemovedCounter = 0L;
        this.elementsPutCounter = 0L;
        this.elementsUpdatedCounter = 0L;
        this.elementsExpiredCounter = 0L;
        this.elementsEvictedCounter = 0L;
        this.elementsRemoveAllCounter = 0L;
    }

    public long getElementsRemovedCounter() {
        return this.elementsRemovedCounter;
    }

    public long getElementsPutCounter() {
        return this.elementsPutCounter;
    }

    public long getElementsUpdatedCounter() {
        return this.elementsUpdatedCounter;
    }

    public long getElementsExpiredCounter() {
        return this.elementsExpiredCounter;
    }

    public long getElementsEvictedCounter() {
        return this.elementsEvictedCounter;
    }

    public long getElementsRemoveAllCounter() {
        return this.elementsRemoveAllCounter;
    }
}

