/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import org.me4se.impl.rms.AbstractRecordStore;
import org.me4se.impl.rms.RecordEnumerationImpl;

public abstract class RecordStore {
    public static final int AUTHMODE_PRIVATE = 0;
    public static final int AUTHMODE_ANY = 1;

    protected RecordStore() {
    }

    public abstract int addRecord(byte[] var1, int var2, int var3) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException;

    public abstract void addRecordListener(RecordListener var1);

    public abstract void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException;

    public abstract void deleteRecord(int var1) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException;

    public static void deleteRecordStore(String recordStoreName) throws RecordStoreException, RecordStoreNotFoundException {
        ((AbstractRecordStore)RecordStore.openRecordStore(recordStoreName, false)).deleteRecordStoreImpl();
        AbstractRecordStore.recordStores.remove(recordStoreName);
    }

    public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) throws RecordStoreNotOpenException {
        return new RecordEnumerationImpl((AbstractRecordStore)this, filter, comparator, keepUpdated);
    }

    public abstract long getLastModified() throws RecordStoreNotOpenException;

    public abstract String getName() throws RecordStoreNotOpenException;

    public abstract int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException;

    public abstract int getNumRecords() throws RecordStoreNotOpenException;

    public abstract byte[] getRecord(int var1) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException;

    public abstract int getRecord(int var1, byte[] var2, int var3) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, ArrayIndexOutOfBoundsException;

    public abstract int getRecordSize(int var1) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException;

    public abstract int getSize() throws RecordStoreNotOpenException;

    public abstract int getSizeAvailable() throws RecordStoreNotOpenException;

    public abstract int getVersion() throws RecordStoreNotOpenException;

    public static String[] listRecordStores() {
        return AbstractRecordStore.listRecordStoresImpl();
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        AbstractRecordStore store = (AbstractRecordStore)AbstractRecordStore.recordStores.get(recordStoreName);
        if (store == null) {
            store = AbstractRecordStore.newInstance();
            AbstractRecordStore.recordStores.put(recordStoreName, store);
        }
        store.open(recordStoreName, createIfNecessary);
        return store;
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary, int authmode, boolean writable) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        System.out.println("RecordStore.openRecordStore(authmode, wriable) called with no effect!");
        return RecordStore.openRecordStore(recordStoreName, createIfNecessary);
    }

    public static RecordStore openRecordStore(String recordStoreName, String vendorName, String suiteName) throws RecordStoreException, RecordStoreNotFoundException {
        System.out.println("RecordStore.openRecordStore(vendorName, suiteName) called with no effect!");
        return RecordStore.openRecordStore(recordStoreName, false);
    }

    public abstract void removeRecordListener(RecordListener var1);

    public abstract void setRecord(int var1, byte[] var2, int var3, int var4) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, RecordStoreFullException;

    public abstract void setMode(int var1, boolean var2) throws RecordStoreException;
}

