/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.midlet.ApplicationManager;
import org.kobjects.util.Csv;
import org.me4se.scm.ScmComponent;

class ScmIcon
extends ScmComponent {
    Hashtable states = new Hashtable();
    String name;
    BufferedImage currentImage;
    String currentState;

    private ScmIcon(String name, String propStr) {
        this.name = name;
        ApplicationManager manager = ApplicationManager.getInstance();
        String[] props = Csv.decode(propStr);
        this.setX(Integer.parseInt(props[0]));
        this.setY(Integer.parseInt(props[1]));
        String seek = name + ".";
        Enumeration<Object> e = manager.properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.toLowerCase().startsWith(seek)) continue;
            String value = ApplicationManager.getProperty(key).trim();
            String state = key.substring(seek.length());
            if (value.equals("")) continue;
            try {
                BufferedImage image = manager.getImage(ApplicationManager.concatPath(ApplicationManager.getProperty("skin"), value));
                int w = image.getWidth();
                int h = image.getHeight();
                if (w > this.getWidth()) {
                    this.setWidth(w);
                }
                if (h > this.getHeight()) {
                    this.setHeight(h);
                }
                this.states.put(state, image);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.setState(props[2]);
    }

    public void setState(String state) {
        if (state.equals(this.currentState)) {
            return;
        }
        this.currentState = state;
        this.currentImage = (BufferedImage)this.states.get(state);
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.currentImage == null) {
            return;
        }
        g.drawImage(this.currentImage, 0, 0, null);
    }

    public static ScmIcon create(String name) {
        String propStr = ApplicationManager.getProperty(name);
        return propStr == null ? null : new ScmIcon(name, propStr);
    }
}

