/* 
    TowBowlTactics: Adaptation of the tabletop game blood bowl

    Copyright (C) 2001-2003 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Path.h"

Path::Path() {
	 dist_done = 0;
	 ok=false;
	 squares = new std::list<Square*>;
}
  
Path::~Path(){
	if(squares) {
		std::list<Square*>::iterator it;
		for(it=squares->begin();it!=squares->end();it++){	
			delete (*it);
		}
		delete squares;
	}
}
  
void Path::set_ok(bool o){
	ok=o;
}

bool Path::is_ok(){
	return ok;
}
  
std::list<Square*>* Path::get_path_squares(){
    return squares;
}
  
void Path::pop_square(){
	squares->erase(squares->begin());
}

void Path::inc_dist_done(){
	dist_done++;
}

void Path::set_dist_done(int i){
	dist_done = i;
}

unsigned int Path::get_dist_done(){
	return (unsigned int)dist_done;
}

void Path::save_state(FILE *fd,int depth){
	char format[10];
	memset(format,0,10);
	
	for(int i=0;i<depth;i++)
		format[i] = ' ';
		format[depth-1] = '\0';
	fprintf(fd,"%s<ok>%i</ok>\n",format,ok);
	fprintf(fd,"%s<squares>\n",format);
	std::list<Square*>::iterator it;
	for(it=squares->begin();it!=squares->end();it++){	
		(*it)->save_state(fd,depth+1);
	}
	fprintf(fd,"%s</squares>\n",format);
}
 

