/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.misc.StandardUnixBrowser;
import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.wraplog.AbstractLogger;

public class UnixNetscapeBrowserLaunching
implements IBrowserLaunching {
    private static final int BROWSER_COUNT = 5;
    private Map unixBrowsers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    protected final AbstractLogger logger;

    public UnixNetscapeBrowserLaunching(AbstractLogger logger) {
        this.logger = logger;
    }

    public void initialize() throws BrowserLaunchingInitializingException {
        ArrayList<StandardUnixBrowser> potentialBrowsers = new ArrayList<StandardUnixBrowser>(5);
        potentialBrowsers.add(StandardUnixBrowser.FIREFOX);
        potentialBrowsers.add(StandardUnixBrowser.MOZILLA);
        potentialBrowsers.add(StandardUnixBrowser.NETSCAPE);
        potentialBrowsers.add(StandardUnixBrowser.KONQUEROR);
        potentialBrowsers.add(StandardUnixBrowser.MOZILLA_FIREFOX);
        potentialBrowsers.add(StandardUnixBrowser.OPERA);
        Iterator iter = potentialBrowsers.iterator();
        String potentialBrowserNames = "";
        while (iter.hasNext()) {
            UnixBrowser browser = (UnixBrowser)iter.next();
            potentialBrowserNames = potentialBrowserNames + browser.getBrowserName();
            if (iter.hasNext()) {
                potentialBrowserNames = potentialBrowserNames + ", ";
            }
            if (!browser.isBrowserAvailable(this.logger)) continue;
            this.unixBrowsers.put(browser.getBrowserName(), browser);
        }
        if (this.unixBrowsers.size() == 0) {
            throw new BrowserLaunchingInitializingException("one of the supported browsers must be installed: " + potentialBrowserNames);
        }
        this.logger.info(this.unixBrowsers.keySet().toString());
        this.unixBrowsers = Collections.unmodifiableMap(this.unixBrowsers);
    }

    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            this.logger.info(urlString);
            boolean success = false;
            Iterator iter = this.unixBrowsers.values().iterator();
            while (iter.hasNext() && !success) {
                UnixBrowser browser = (UnixBrowser)iter.next();
                this.logger.info(browser.getBrowserName());
                Process process = Runtime.getRuntime().exec(browser.getArgsForOpenBrowser(urlString));
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    process = Runtime.getRuntime().exec(browser.getArgsForStartingBrowser(urlString));
                    exitCode = process.waitFor();
                }
                success = exitCode == 0;
            }
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    public void openUrl(String browser, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        UnixBrowser unixBrowser = (UnixBrowser)this.unixBrowsers.get(browser);
        if (unixBrowser == null) {
            this.logger.debug("falling through to non-targetted openUrl");
            this.openUrl(urlString);
        } else {
            this.logger.info(unixBrowser.getBrowserName());
            this.logger.info(urlString);
            try {
                Process process = Runtime.getRuntime().exec(unixBrowser.getArgsForOpenBrowser(urlString));
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    process = Runtime.getRuntime().exec(unixBrowser.getArgsForStartingBrowser(urlString));
                    exitCode = process.waitFor();
                }
                if (exitCode != 0) {
                    this.logger.debug("open browser failure, trying non-targetted openUrl");
                    this.openUrl(urlString);
                }
            }
            catch (Exception e) {
                throw new BrowserLaunchingExecutionException(e);
            }
        }
    }

    public List getBrowserList() {
        ArrayList<String> browsers = new ArrayList<String>();
        browsers.add("Default");
        browsers.addAll(this.unixBrowsers.keySet());
        return browsers;
    }
}

