/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.validate.Datatype;
import guru.nidi.graphviz.attribute.validate.Datatypes;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;

class ColorListDatatype
extends Datatype {
    ColorListDatatype() {
        super("list of colors");
    }

    @Override
    ValidatorMessage validate(Object value) {
        String[] colors = value.toString().split(":");
        double[] sum = new double[]{0.0};
        for (String color : colors) {
            int pos = color.indexOf(59);
            ValidatorMessage colorMsg = Datatypes.COLOR.validate(pos < 0 ? color : color.substring(0, pos));
            if (colorMsg != null) {
                return colorMsg;
            }
            String factorMsg = this.checkFactor(pos, color, sum);
            if (factorMsg == null) continue;
            return new ValidatorMessage(ValidatorMessage.Severity.ERROR, factorMsg + " in '" + value + "'.");
        }
        if (sum[0] > 1.0) {
            return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "has a sum of factors " + sum[0] + " > 1 in '" + value + "'.");
        }
        return null;
    }

    private String checkFactor(int pos, String color, double[] sum) {
        if (pos >= 0) {
            if (pos == color.length() - 1) {
                return "is missing color factor after ';'";
            }
            String factor = color.substring(pos + 1);
            Double factorValue = ColorListDatatype.doubleValue(factor);
            if (factorValue == null) {
                return "has the invalid color factor '" + factor + "'";
            }
            if (factorValue < 0.0 || factorValue > 1.0) {
                return "has a color factor '" + factor + "' not between 0 and 1";
            }
            sum[0] = sum[0] + factorValue;
        }
        return null;
    }
}

