/*
 * Decompiled with CFR 0.152.
 */
package plugin.qualifier.shieldprof;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.ShieldProf;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.util.Logging;

public class EquipmentToken
implements QualifierToken<ShieldProf>,
Converter<Equipment, CDOMReference<ShieldProf>> {
    private static final Type SHIELD_TYPE = Type.getConstant("Shield");
    private PrimitiveCollection<Equipment> pcs = null;
    private boolean wasRestricted = false;

    @Override
    public String getTokenName() {
        return "EQUIPMENT";
    }

    @Override
    public Class<ShieldProf> getReferenceClass() {
        return ShieldProf.class;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTokenName());
        if (this.wasRestricted) {
            sb.append('[').append(this.pcs.getLSTformat(useAny)).append(']');
        }
        return sb.toString();
    }

    @Override
    public boolean initialize(LoadContext context, SelectionCreator<ShieldProf> sc, String condition, String value, boolean negate) {
        if (negate) {
            Logging.addParseMessage(Level.SEVERE, "Cannot make " + this.getTokenName() + " into a negated Qualifier, remove !");
            return false;
        }
        if (condition != null) {
            Logging.addParseMessage(Level.SEVERE, "Cannot make " + this.getTokenName() + " into a conditional Qualifier, remove =");
            return false;
        }
        ReferenceManufacturer<Equipment> erm = context.getReferenceContext().getManufacturer(Equipment.class);
        if (value == null) {
            this.pcs = erm.getAllReference();
        } else {
            this.pcs = context.getPrimitiveChoiceFilter(erm, value);
            this.wasRestricted = true;
        }
        return this.pcs != null;
    }

    public int hashCode() {
        return this.pcs == null ? 0 : this.pcs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof EquipmentToken) {
            EquipmentToken other = (EquipmentToken)o;
            if (this.pcs == null) {
                return other.pcs == null;
            }
            return this.pcs.equals(other.pcs);
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        return this.pcs == null ? GroupingState.ANY : this.pcs.getGroupingState().reduce();
    }

    @Override
    public <R> Collection<R> getCollection(PlayerCharacter pc, Converter<ShieldProf, R> c) {
        HashSet<R> returnSet = new HashSet<R>();
        Collection<CDOMReference<ShieldProf>> intermediate = this.pcs.getCollection(pc, this);
        for (ObjectContainer objectContainer : intermediate) {
            returnSet.addAll(c.convert((ObjectContainer<ShieldProf>)objectContainer));
        }
        return returnSet;
    }

    @Override
    public Collection<CDOMReference<ShieldProf>> convert(ObjectContainer<Equipment> orig) {
        HashSet<CDOMReference<ShieldProf>> refSet = new HashSet<CDOMReference<ShieldProf>>();
        for (Equipment e : orig.getContainedObjects()) {
            CDOMSingleRef<ShieldProf> prof;
            if (!e.getListFor(ListKey.TYPE).contains(SHIELD_TYPE) || (prof = e.get(ObjectKey.SHIELD_PROF)) == null) continue;
            refSet.add(prof);
        }
        return refSet;
    }

    @Override
    public Collection<CDOMReference<ShieldProf>> convert(ObjectContainer<Equipment> orig, PrimitiveFilter<Equipment> lim) {
        throw new UnsupportedOperationException("Only EquipmentToken should call itself as a Converter");
    }
}

