/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Identified;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.meta.CorePerspective;
import pcgen.cdom.meta.CorePerspectiveDB;
import pcgen.cdom.meta.CoreViewNodeBase;
import pcgen.cdom.meta.FacetView;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.facade.core.CoreViewNodeFacade;
import pcgen.util.Logging;

public class CoreUtils {
    public static <T> List<CoreViewNodeFacade> buildCoreDebugList(PlayerCharacter pc, CorePerspective pers) {
        CoreViewNodeBase node;
        FacetView view;
        CharID id = pc.getCharID();
        ArrayList<CoreViewNodeFacade> coreViewList = new ArrayList<CoreViewNodeFacade>();
        Collection<Object> locations = CorePerspectiveDB.getLocations(pers);
        HashMapToList sources = new HashMapToList();
        HashMap facetToNode = new HashMap();
        for (Object location : locations) {
            view = CorePerspectiveDB.getView(pers, location);
            node = new LocationCoreViewNode(location);
            facetToNode.put(view, node);
            coreViewList.add(node);
            for (FacetView facetView : view.getChildren()) {
                FacetView lView = CorePerspectiveDB.getViewOfFacet(facetView);
                FacetView src = lView == null ? facetView : lView;
                sources.addToListFor(src, view);
            }
            Collection<Object> parents = CorePerspectiveDB.getVirtualParents(view);
            if (parents == null) continue;
            for (Object parent : parents) {
                FacetView facetView = CorePerspectiveDB.getViewOfFacet(parent);
                if (facetView == null) {
                    Logging.errorPrint("Expected " + parent + " to be a registered Facet in Perspective " + pers);
                }
                sources.addToListFor(view, facetView);
            }
        }
        for (Object location : locations) {
            view = CorePerspectiveDB.getView(pers, location);
            node = (CoreViewNodeBase)facetToNode.get(view);
            for (Object obj : view.getSet(id)) {
                ArrayList<String> sourceDesc = new ArrayList<String>();
                for (Object src : view.getSources(id, obj)) {
                    if (src instanceof Identified) {
                        sourceDesc.add(CoreUtils.getLoadID(src));
                        continue;
                    }
                    FacetView srcView = CorePerspectiveDB.getViewOfFacet(src);
                    if (srcView == null) {
                        sourceDesc.add("Orphaned [" + src.getClass().getSimpleName() + "]");
                        continue;
                    }
                    if (facetToNode.get(srcView) != null) continue;
                    sourceDesc.add("Other Perspective [" + CorePerspectiveDB.getPerspectiveOfFacet(src) + ": " + srcView.getDescription() + "]");
                }
                ObjectCoreViewNode objectCoreViewNode = new ObjectCoreViewNode(pc, obj, sourceDesc);
                objectCoreViewNode.addGrantedByNode(node);
                coreViewList.add(objectCoreViewNode);
            }
        }
        for (Object location : locations) {
            view = CorePerspectiveDB.getView(pers, location);
            node = (CoreViewNodeBase)facetToNode.get(view);
            List facetInputs = sources.getListFor(view);
            if (facetInputs == null) continue;
            for (FacetView facet : facetInputs) {
                ((CoreViewNodeBase)facetToNode.get(facet)).addGrantedByNode(node);
            }
        }
        return coreViewList;
    }

    private static <T> String getLoadID(T obj) {
        if (obj instanceof Identified) {
            Identified l = (Identified)obj;
            String name = l.getDisplayName();
            String id = obj.getClass().getSimpleName() + ": " + name;
            if (!l.getKeyName().equals(name)) {
                id = id + " [" + l.getKeyName() + "]";
            }
            return id;
        }
        if (obj instanceof QualifiedObject) {
            QualifiedObject qo = (QualifiedObject)obj;
            return CoreUtils.getLoadID(qo.getRawObject());
        }
        if (obj instanceof CDOMReference) {
            CDOMReference ref = (CDOMReference)obj;
            return ref.getReferenceClass().getSimpleName() + " Primitive: " + ref.getLSTformat(false);
        }
        return obj.getClass().getSimpleName() + ": " + obj.toString();
    }

    private static String getRequirementsInfo(PlayerCharacter pc, Object object) {
        if (object instanceof PrereqObject) {
            CDOMObject source = null;
            if (object instanceof CDOMObject) {
                source = (CDOMObject)object;
            }
            return PrerequisiteUtilities.preReqHTMLStringsForList(pc, source, ((PrereqObject)object).getPrerequisiteList(), true);
        }
        return "";
    }

    private static class ObjectCoreViewNode<T>
    extends CoreViewNodeBase {
        private final T object;
        private final List<String> sourceDesc;
        private final PlayerCharacter pc;

        public ObjectCoreViewNode(PlayerCharacter pc, T object, List<String> sourceDesc) {
            this.pc = pc;
            this.object = object;
            this.sourceDesc = sourceDesc;
        }

        @Override
        public String getNodeType() {
            return "Source";
        }

        @Override
        public String getKey() {
            if (this.object instanceof CDOMObject) {
                return ((CDOMObject)this.object).getKeyName();
            }
            return this.object.toString();
        }

        @Override
        public String getSource() {
            return StringUtil.join(this.sourceDesc, (String)", ");
        }

        @Override
        public String getRequirements() {
            return CoreUtils.getRequirementsInfo(this.pc, this.object);
        }

        public String toString() {
            return CoreUtils.getLoadID(this.object);
        }
    }

    private static class LocationCoreViewNode<T>
    extends CoreViewNodeBase {
        private final Object object;

        public LocationCoreViewNode(Object object) {
            this.object = object;
        }

        @Override
        public String getNodeType() {
            return "Location";
        }

        @Override
        public String getKey() {
            return this.object.toString();
        }

        @Override
        public String getSource() {
            return "";
        }

        @Override
        public String getRequirements() {
            return "";
        }

        public String toString() {
            return CoreUtils.getLoadID(this.object);
        }
    }
}

