/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.Constants;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.BiographyField;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.EquipmentLocation;
import pcgen.cdom.enumeration.Gender;
import pcgen.cdom.enumeration.Handed;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.PCStringKey;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.facet.AutoEquipmentFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.fact.XPFacet;
import pcgen.cdom.facet.model.LanguageFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.cdom.helper.ClassSource;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.meta.CorePerspective;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AgeSet;
import pcgen.core.BonusManager;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.GearBuySellScheme;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.Race;
import pcgen.core.RollingMethods;
import pcgen.core.SettingsHandler;
import pcgen.core.SimpleFacadeImpl;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SubClass;
import pcgen.core.VariableProcessor;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.analysis.SpellCountCalc;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.display.BonusDisplay;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.kit.BaseKit;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.AlignmentFacade;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.CharacterStubFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.CompanionSupportFacade;
import pcgen.facade.core.CoreViewNodeFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.DeityFacade;
import pcgen.facade.core.DescriptionFacade;
import pcgen.facade.core.DomainFacade;
import pcgen.facade.core.EquipModFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentListFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.core.GearBuySellFacade;
import pcgen.facade.core.GenderFacade;
import pcgen.facade.core.HandedFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.KitFacade;
import pcgen.facade.core.LanguageChooserFacade;
import pcgen.facade.core.LanguageFacade;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.core.SimpleFacade;
import pcgen.facade.core.SkillFacade;
import pcgen.facade.core.SpellFacade;
import pcgen.facade.core.SpellSupportFacade;
import pcgen.facade.core.StatFacade;
import pcgen.facade.core.TempBonusFacade;
import pcgen.facade.core.TemplateFacade;
import pcgen.facade.core.TodoFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ListFacades;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ChangeListener;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.facade.CharacterAbilities;
import pcgen.gui2.facade.CharacterLevelFacadeImpl;
import pcgen.gui2.facade.CharacterLevelsFacadeImpl;
import pcgen.gui2.facade.CharacterUtils;
import pcgen.gui2.facade.CompanionNotLoaded;
import pcgen.gui2.facade.CompanionSupportFacadeImpl;
import pcgen.gui2.facade.CoreUtils;
import pcgen.gui2.facade.DelegatingDataSet;
import pcgen.gui2.facade.DescriptionFacadeImpl;
import pcgen.gui2.facade.DomainFacadeImpl;
import pcgen.gui2.facade.EquipmentBuilderFacadeImpl;
import pcgen.gui2.facade.EquipmentListFacadeImpl;
import pcgen.gui2.facade.EquipmentSetFacadeImpl;
import pcgen.gui2.facade.Gui2InfoFactory;
import pcgen.gui2.facade.LanguageChooserFacadeImpl;
import pcgen.gui2.facade.SpellFacadeImplem;
import pcgen.gui2.facade.SpellSupportFacadeImpl;
import pcgen.gui2.facade.TempBonusFacadeImpl;
import pcgen.gui2.facade.TempBonusHelper;
import pcgen.gui2.facade.TodoFacadeImpl;
import pcgen.gui2.facade.TodoManager;
import pcgen.gui2.util.HtmlInfoBuilder;
import pcgen.io.ExportException;
import pcgen.io.ExportHandler;
import pcgen.io.PCGIOHandler;
import pcgen.pluginmgr.PluginManager;
import pcgen.pluginmgr.messages.PlayerCharacterWasClosedMessage;
import pcgen.system.CharacterManager;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.View;

public class CharacterFacadeImpl
implements CharacterFacade,
EquipmentListFacade.EquipmentListListener,
ListListener<EquipmentFacade>,
CharacterLevelsFacade.HitPointListener {
    private static PlayerCharacter DUMMY_PC = new PlayerCharacter();
    private List<ClassFacade> pcClasses;
    private DefaultListFacade<TempBonusFacade> appliedTempBonuses;
    private DefaultListFacade<TempBonusFacade> availTempBonuses;
    private DefaultReferenceFacade<AlignmentFacade> alignment;
    private DefaultListFacade<EquipmentSetFacade> equipmentSets;
    private DefaultReferenceFacade<GenderFacade> gender;
    private DefaultListFacade<CharacterLevelFacade> pcClassLevels;
    private DefaultListFacade<HandedFacade> availHands;
    private DefaultListFacade<GenderFacade> availGenders;
    private Map<StatFacade, DefaultReferenceFacade<Integer>> statScoreMap;
    private UndoManager undoManager;
    private DelegatingDataSet dataSet;
    private DefaultReferenceFacade<RaceFacade> race;
    private DefaultReferenceFacade<DeityFacade> deity;
    private DefaultReferenceFacade<String> tabName;
    private DefaultReferenceFacade<String> name;
    private DefaultReferenceFacade<String> playersName;
    private PlayerCharacter theCharacter;
    private CharacterDisplay charDisplay;
    private DefaultReferenceFacade<EquipmentSetFacade> equipSet;
    private DefaultListFacade<LanguageFacade> languages;
    private EquipmentListFacadeImpl purchasedEquip;
    private DefaultReferenceFacade<File> file;
    private DefaultReferenceFacade<HandedFacade> handedness;
    private UIDelegate delegate;
    private Set<Language> autoLanguagesCache;
    private CharacterLevelsFacadeImpl charLevelsFacade;
    private DefaultReferenceFacade<Integer> currentXP;
    private DefaultReferenceFacade<Integer> xpForNextlevel;
    private DefaultReferenceFacade<String> xpTableName;
    private DefaultReferenceFacade<String> characterType;
    private DefaultReferenceFacade<String> previewSheet;
    private DefaultReferenceFacade<SkillFilter> skillFilter;
    private DefaultReferenceFacade<Integer> age;
    private DefaultReferenceFacade<SimpleFacade> ageCategory;
    private DefaultListFacade<SimpleFacade> ageCategoryList;
    private DefaultReferenceFacade<String> poolPointText;
    private DefaultReferenceFacade<String> statTotalLabelText;
    private DefaultReferenceFacade<String> statTotalText;
    private DefaultReferenceFacade<String> modTotalLabelText;
    private DefaultReferenceFacade<String> modTotalText;
    private DefaultReferenceFacade<Integer> numBonusLang;
    private DefaultReferenceFacade<Integer> numSkillLang;
    private DefaultReferenceFacade<Integer> hpRef;
    private DefaultReferenceFacade<Integer> rollMethodRef;
    private DefaultReferenceFacade<String> carriedWeightRef;
    private DefaultReferenceFacade<String> loadRef;
    private DefaultReferenceFacade<String> weightLimitRef;
    private DefaultListFacade<DomainFacade> domains;
    private DefaultListFacade<DomainFacade> availDomains;
    private DefaultReferenceFacade<Integer> maxDomains;
    private DefaultReferenceFacade<Integer> remainingDomains;
    private DefaultListFacade<TemplateFacade> templates;
    private DefaultListFacade<RaceFacade> raceList;
    private DefaultListFacade<KitFacade> kitList;
    private DefaultReferenceFacade<File> portrait;
    private RectangleReference cropRect;
    private String selectedGender;
    private List<Language> currBonusLangs;
    private DefaultReferenceFacade<String> skinColor;
    private DefaultReferenceFacade<String> hairColor;
    private DefaultReferenceFacade<String> eyeColor;
    private DefaultReferenceFacade<Integer> heightRef;
    private DefaultReferenceFacade<Integer> weightRef;
    private DefaultReferenceFacade<BigDecimal> fundsRef;
    private DefaultReferenceFacade<BigDecimal> wealthRef;
    private DefaultReferenceFacade<GearBuySellFacade> gearBuySellSchemeRef;
    private Gui2InfoFactory infoFactory;
    private CharacterAbilities characterAbilities;
    private DescriptionFacade descriptionFacade;
    private SpellSupportFacadeImpl spellSupportFacade;
    private CompanionSupportFacadeImpl companionSupportFacade;
    private TodoManager todoManager;
    private boolean allowDebt;
    private int lastExportCharSerial = 0;
    private PlayerCharacter lastExportChar = null;
    private LanguageListener langListener;
    private TemplateListener templateListener;
    private XPListener xpListener;
    private AutoEquipListener autoEquipListener;

    public CharacterFacadeImpl(PlayerCharacter pc, UIDelegate delegate, DataSetFacade dataSetFacade) {
        this.delegate = delegate;
        this.theCharacter = pc;
        this.charDisplay = pc.getDisplay();
        this.dataSet = new DelegatingDataSet(dataSetFacade);
        this.buildAgeCategories();
        this.initForCharacter();
        this.undoManager = new UndoManager();
    }

    @Override
    public void closeCharacter() {
        FacetLibrary.getFacet(LanguageFacet.class).removeDataFacetChangeListener(this.langListener);
        FacetLibrary.getFacet(TemplateFacet.class).removeDataFacetChangeListener(this.templateListener);
        FacetLibrary.getFacet(XPFacet.class).removeDataFacetChangeListener(this.xpListener);
        FacetLibrary.getFacet(AutoEquipmentFacet.class).removeDataFacetChangeListener(this.autoEquipListener);
        this.characterAbilities.closeCharacter();
        this.charLevelsFacade.closeCharacter();
        this.companionSupportFacade.closeCharacter();
        PluginManager.getInstance().getPostbox().handleMessage(new PlayerCharacterWasClosedMessage(this, this.theCharacter));
        Globals.getPCList().remove(this.theCharacter);
        this.lastExportChar = null;
        this.theCharacter = DUMMY_PC;
        this.charDisplay = null;
        this.dataSet.detachDelegates();
    }

    private void initForCharacter() {
        this.theCharacter.preparePCForOutput();
        this.todoManager = new TodoManager();
        this.infoFactory = new Gui2InfoFactory(this.theCharacter);
        this.characterAbilities = new CharacterAbilities(this.theCharacter, this.delegate, this.dataSet, this.todoManager);
        this.descriptionFacade = new DescriptionFacadeImpl(this.theCharacter);
        this.spellSupportFacade = new SpellSupportFacadeImpl(this.theCharacter, this.delegate, this.dataSet, this.todoManager, this);
        this.name = new DefaultReferenceFacade<String>(this.charDisplay.getName());
        this.file = new DefaultReferenceFacade<File>(new File(this.charDisplay.getFileName()));
        this.companionSupportFacade = new CompanionSupportFacadeImpl(this.theCharacter, this.todoManager, this.name, this.file, this);
        this.availTempBonuses = new DefaultListFacade();
        this.refreshAvailableTempBonuses();
        this.appliedTempBonuses = new DefaultListFacade();
        this.buildAppliedTempBonusList();
        this.kitList = new DefaultListFacade();
        this.refreshKitList();
        this.statScoreMap = new HashMap<StatFacade, DefaultReferenceFacade<Integer>>();
        File portraitFile = null;
        if (!StringUtils.isEmpty(this.charDisplay.getPortraitPath())) {
            portraitFile = new File(this.charDisplay.getPortraitPath());
        }
        this.portrait = new DefaultReferenceFacade<Object>(portraitFile);
        this.cropRect = new RectangleReference(this.charDisplay.getPortraitThumbnailRect());
        this.characterType = new DefaultReferenceFacade<String>(this.charDisplay.getCharacterType());
        this.previewSheet = new DefaultReferenceFacade<String>(this.charDisplay.getPreviewSheet());
        this.skillFilter = new DefaultReferenceFacade<SkillFilter>(this.charDisplay.getSkillFilter());
        this.tabName = new DefaultReferenceFacade<String>(this.charDisplay.getTabName());
        this.playersName = new DefaultReferenceFacade<String>(this.charDisplay.getPlayersName());
        this.race = new DefaultReferenceFacade<Race>(this.charDisplay.getRace());
        this.raceList = new DefaultListFacade();
        if (this.charDisplay.getRace() != null && this.charDisplay.getRace() != Globals.s_EMPTYRACE) {
            this.raceList.addElement(this.charDisplay.getRace());
        }
        this.handedness = new DefaultReferenceFacade();
        this.gender = new DefaultReferenceFacade();
        this.availHands = new DefaultListFacade();
        this.availGenders = new DefaultListFacade();
        for (Handed handed : Handed.values()) {
            this.availHands.addElement(handed);
        }
        for (Enum enum_ : Gender.values()) {
            this.availGenders.addElement((GenderFacade)((Object)enum_));
        }
        if (this.charDisplay.getRace() != null) {
            for (HandedFacade handsFacade : this.availHands) {
                if (!handsFacade.equals(this.charDisplay.getHandedObject())) continue;
                this.handedness.setReference(handsFacade);
                break;
            }
            for (GenderFacade pcGender : this.availGenders) {
                if (!pcGender.equals(this.charDisplay.getGenderObject())) continue;
                this.gender.setReference(pcGender);
                break;
            }
        }
        this.alignment = new DefaultReferenceFacade<PCAlignment>(this.charDisplay.getPCAlignment());
        this.age = new DefaultReferenceFacade<Integer>(this.charDisplay.getAge());
        this.ageCategory = new DefaultReferenceFacade();
        this.updateAgeCategoryForAge();
        this.currentXP = new DefaultReferenceFacade<Integer>(this.charDisplay.getXP());
        this.xpListener = new XPListener();
        FacetLibrary.getFacet(XPFacet.class).addDataFacetChangeListener(this.xpListener);
        this.xpForNextlevel = new DefaultReferenceFacade<Integer>(this.charDisplay.minXPForNextECL());
        this.xpTableName = new DefaultReferenceFacade<String>(this.charDisplay.getXPTableName());
        this.hpRef = new DefaultReferenceFacade<Integer>(this.theCharacter.hitPoints());
        this.skinColor = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.SKINCOLOR));
        this.hairColor = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.HAIRCOLOR));
        this.eyeColor = new DefaultReferenceFacade<String>(this.charDisplay.getSafeStringFor(PCStringKey.EYECOLOR));
        this.weightRef = new DefaultReferenceFacade();
        this.heightRef = new DefaultReferenceFacade();
        this.refreshHeightWeight();
        this.purchasedEquip = new EquipmentListFacadeImpl(this.theCharacter.getEquipmentMasterList());
        this.autoEquipListener = new AutoEquipListener();
        FacetLibrary.getFacet(AutoEquipmentFacet.class).addDataFacetChangeListener(this.autoEquipListener);
        this.carriedWeightRef = new DefaultReferenceFacade();
        this.loadRef = new DefaultReferenceFacade();
        this.weightLimitRef = new DefaultReferenceFacade();
        this.equipSet = new DefaultReferenceFacade();
        this.equipmentSets = new DefaultListFacade();
        this.initEquipSet();
        GameMode game = (GameMode)this.dataSet.getGameMode();
        this.rollMethodRef = new DefaultReferenceFacade<Integer>(game.getRollMethod());
        this.charLevelsFacade = new CharacterLevelsFacadeImpl(this.theCharacter, this.delegate, this.todoManager, this.dataSet, this);
        this.pcClasses = new ArrayList<ClassFacade>();
        this.pcClassLevels = new DefaultListFacade();
        this.refreshClassLevelModel();
        this.charLevelsFacade.addHitPointListener(this);
        this.deity = new DefaultReferenceFacade<Deity>(this.charDisplay.getDeity());
        this.domains = new DefaultListFacade();
        this.maxDomains = new DefaultReferenceFacade<Integer>(this.theCharacter.getMaxCharacterDomains());
        this.remainingDomains = new DefaultReferenceFacade<Integer>(this.theCharacter.getMaxCharacterDomains() - this.domains.getSize());
        this.availDomains = new DefaultListFacade();
        this.buildAvailableDomainsList();
        this.templates = new DefaultListFacade<PCTemplate>(this.charDisplay.getDisplayVisibleTemplateList());
        this.templateListener = new TemplateListener();
        FacetLibrary.getFacet(TemplateFacet.class).addDataFacetChangeListener(this.templateListener);
        this.initTodoList();
        this.statTotalLabelText = new DefaultReferenceFacade();
        this.statTotalText = new DefaultReferenceFacade();
        this.modTotalLabelText = new DefaultReferenceFacade();
        this.modTotalText = new DefaultReferenceFacade();
        this.updateScorePurchasePool(false);
        this.languages = new DefaultListFacade();
        this.numBonusLang = new DefaultReferenceFacade<Integer>(0);
        this.numSkillLang = new DefaultReferenceFacade<Integer>(0);
        this.refreshLanguageList();
        this.langListener = new LanguageListener();
        FacetLibrary.getFacet(LanguageFacet.class).addDataFacetChangeListener(this.langListener);
        this.purchasedEquip.addListListener(this.spellSupportFacade);
        this.purchasedEquip.addEquipmentListListener(this.spellSupportFacade);
        this.fundsRef = new DefaultReferenceFacade<BigDecimal>(this.theCharacter.getGold());
        this.wealthRef = new DefaultReferenceFacade<BigDecimal>(this.theCharacter.totalValue());
        this.gearBuySellSchemeRef = new DefaultReferenceFacade<GearBuySellFacade>(this.findGearBuySellRate());
        this.allowDebt = false;
    }

    private void refreshKitList() {
        ArrayList<Kit> kits = new ArrayList<Kit>();
        for (Kit kit : this.charDisplay.getKitInfo()) {
            kits.add(kit);
        }
        this.kitList.updateContents(kits);
    }

    private GearBuySellFacade findGearBuySellRate() {
        int buyRate = SettingsHandler.getGearTab_BuyRate();
        int sellRate = SettingsHandler.getGearTab_SellRate();
        for (GearBuySellFacade buySell : this.dataSet.getGearBuySellSchemes()) {
            GearBuySellScheme scheme = (GearBuySellScheme)buySell;
            if (scheme.getBuyRate().intValue() != buyRate || scheme.getSellRate().intValue() != sellRate) continue;
            return scheme;
        }
        GearBuySellScheme scheme = new GearBuySellScheme(LanguageBundle.getString("in_custom"), new BigDecimal(buyRate), new BigDecimal(sellRate), new BigDecimal(100));
        return scheme;
    }

    private void initEquipSet() {
        if (!this.charDisplay.hasEquipSet()) {
            String id = EquipmentSetFacadeImpl.getNewIdPath(this.charDisplay, null);
            EquipSet eSet = new EquipSet(id, LanguageBundle.getString("in_ieDefault"));
            this.theCharacter.addEquipSet(eSet);
            this.theCharacter.setCalcEquipSetId(id);
        }
        if (this.equipSet.getReference() != null) {
            EquipmentListFacade equippedItems = this.equipSet.getReference().getEquippedItems();
            equippedItems.removeListListener(this);
            equippedItems.removeEquipmentListListener(this);
        }
        ArrayList<EquipmentSetFacadeImpl> eqSetList = new ArrayList<EquipmentSetFacadeImpl>();
        EquipmentSetFacadeImpl currSet = null;
        String currIdPath = this.theCharacter.getCalcEquipSetId();
        for (EquipSet es : this.charDisplay.getEquipSet()) {
            if (!es.getParentIdPath().equals("0")) continue;
            EquipmentSetFacadeImpl facade = new EquipmentSetFacadeImpl(this.delegate, this.theCharacter, es, this.dataSet, this.purchasedEquip, this.todoManager, this);
            eqSetList.add(facade);
            if (!es.getIdPath().equals(currIdPath)) continue;
            currSet = facade;
        }
        this.equipmentSets.updateContents(eqSetList);
        if (currSet != null) {
            this.equipSet.setReference(currSet);
        }
        EquipmentSetFacade set = this.equipSet.getReference();
        set.getEquippedItems().addListListener(this);
        set.getEquippedItems().addEquipmentListListener(this);
        this.refreshTotalWeight();
    }

    private void buildAgeCategories() {
        ArrayList<String> cats = new ArrayList<String>();
        for (String aString : Globals.getBioSet().getAgeCategories()) {
            int idx = aString.indexOf(9);
            if (idx >= 0) {
                aString = aString.substring(0, idx);
            }
            if (cats.contains(aString)) continue;
            cats.add(aString);
        }
        Collections.sort(cats);
        this.ageCategoryList = new DefaultListFacade();
        for (String ageCat : cats) {
            this.ageCategoryList.addElement(new SimpleFacadeImpl(ageCat));
        }
    }

    private void initTodoList() {
        if (this.isNewCharName(this.charDisplay.getName())) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Name", "in_sumTodoName", 1));
        }
        if (this.charDisplay.getRace() == null || "<none selected>".equals(this.charDisplay.getRace().getKeyName())) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Race", "in_irTodoRace", 100));
        }
        this.updateLevelTodo();
    }

    private boolean isNewCharName(String charName) {
        if (charName == null) {
            return true;
        }
        return charName.startsWith("Unnamed");
    }

    @Override
    public ListFacade<HandedFacade> getAvailableHands() {
        return this.availHands;
    }

    @Override
    public ListFacade<GenderFacade> getAvailableGenders() {
        return this.availGenders;
    }

    @Override
    public void addAbility(AbilityCategoryFacade category, AbilityFacade ability) {
        this.characterAbilities.addAbility(category, ability);
        this.refreshKitList();
        this.refreshAvailableTempBonuses();
        this.buildAvailableDomainsList();
        this.companionSupportFacade.refreshCompanionData();
        this.refreshEquipment();
        this.hpRef.setReference(this.theCharacter.hitPoints());
    }

    @Override
    public void removeAbility(AbilityCategoryFacade category, AbilityFacade ability) {
        this.characterAbilities.removeAbility(category, ability);
        this.refreshKitList();
        this.companionSupportFacade.refreshCompanionData();
        this.hpRef.setReference(this.theCharacter.hitPoints());
    }

    @Override
    public ListFacade<AbilityFacade> getAbilities(AbilityCategoryFacade category) {
        return this.characterAbilities.getAbilities(category);
    }

    @Override
    public ListFacade<AbilityCategoryFacade> getActiveAbilityCategories() {
        return this.characterAbilities.getActiveAbilityCategories();
    }

    @Override
    public int getTotalSelections(AbilityCategoryFacade category) {
        return this.characterAbilities.getTotalSelections(category);
    }

    @Override
    public int getRemainingSelections(AbilityCategoryFacade category) {
        return this.characterAbilities.getRemainingSelections(category);
    }

    @Override
    public void addAbilityCatSelectionListener(ChangeListener listener) {
        this.characterAbilities.addAbilityCatSelectionListener(listener);
    }

    @Override
    public void removeAbilityCatSelectionListener(ChangeListener listener) {
        this.characterAbilities.removeAbilityCatSelectionListener(listener);
    }

    @Override
    public void setRemainingSelection(AbilityCategoryFacade category, int remaining) {
        this.characterAbilities.setRemainingSelection(category, remaining);
    }

    @Override
    public boolean hasAbility(AbilityCategoryFacade category, AbilityFacade ability) {
        return this.characterAbilities.hasAbility(category, ability);
    }

    @Override
    public Nature getAbilityNature(AbilityFacade ability) {
        if (ability == null || !(ability instanceof Ability)) {
            return null;
        }
        List<CNAbility> cnas = this.theCharacter.getMatchingCNAbilities((Ability)ability);
        Nature nature = null;
        for (CNAbility cna : cnas) {
            nature = Nature.getBestNature(nature, cna.getNature());
        }
        return nature;
    }

    @Override
    public void addCharacterLevels(ClassFacade[] classes) {
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        int oldLevel = this.charLevelsFacade.getSize();
        boolean needFullRefresh = false;
        for (ClassFacade classFacade : classes) {
            if (classFacade instanceof PCClass) {
                int totalLevels = this.charDisplay.getTotalLevels();
                if (!this.validateAddLevel((PCClass)classFacade)) {
                    return;
                }
                Logging.log(Logging.INFO, this.charDisplay.getName() + ": Adding level " + (totalLevels + 1) + " in class " + classFacade);
                this.theCharacter.incrementClassLevel(1, (PCClass)classFacade);
                if (totalLevels == this.charDisplay.getTotalLevels()) {
                    return;
                }
                if (((PCClass)classFacade).containsKey(ObjectKey.EXCHANGE_LEVEL)) {
                    needFullRefresh = true;
                }
            }
            if (!this.pcClasses.contains(classFacade)) {
                this.pcClasses.add(classFacade);
            }
            CharacterLevelFacadeImpl cl = new CharacterLevelFacadeImpl(classFacade, this.charLevelsFacade.getSize() + 1);
            this.pcClassLevels.addElement(cl);
            this.charLevelsFacade.addLevelOfClass(cl);
        }
        CharacterUtils.selectClothes(this.getTheCharacter());
        this.theCharacter.calcActiveBonuses();
        if (needFullRefresh) {
            this.refreshClassLevelModel();
        }
        this.postLevellingUpdates();
        this.delegate.showLevelUpInfo(this, oldLevel);
    }

    void postLevellingUpdates() {
        this.characterAbilities.rebuildAbilityLists();
        this.companionSupportFacade.refreshCompanionData();
        this.refreshKitList();
        this.refreshAvailableTempBonuses();
        this.refreshEquipment();
        this.currentXP.setReference(this.charDisplay.getXP());
        this.xpForNextlevel.setReference(this.charDisplay.minXPForNextECL());
        this.xpTableName.setReference(this.charDisplay.getXPTableName());
        this.hpRef.setReference(this.theCharacter.hitPoints());
        this.age.setReference(this.charDisplay.getAge());
        this.refreshHeightWeight();
        this.refreshStatScores();
        this.updateLevelTodo();
        this.buildAvailableDomainsList();
        this.spellSupportFacade.refreshAvailableKnownSpells();
        this.updateScorePurchasePool(false);
        this.refreshLanguageList();
    }

    void postEquippingUpdates() {
        this.characterAbilities.rebuildAbilityLists();
        this.refreshAvailableTempBonuses();
        this.hpRef.setReference(this.theCharacter.hitPoints());
    }

    private void refreshHeightWeight() {
        this.weightRef.setReference(Globals.getGameModeUnitSet().convertWeightToUnitSet(this.charDisplay.getWeight()));
        this.heightRef.setReference((int)Math.round(Globals.getGameModeUnitSet().convertHeightToUnitSet(this.charDisplay.getHeight())));
    }

    @Override
    public void removeCharacterLevels(int levels) {
        ClassFacade classFacade;
        for (int i = levels; i > 0 && !this.pcClassLevels.isEmpty(); --i) {
            classFacade = this.charLevelsFacade.getClassTaken(this.pcClassLevels.getElementAt(this.pcClassLevels.getSize() - 1));
            this.pcClassLevels.removeElement(this.pcClassLevels.getSize() - 1);
            if (classFacade instanceof PCClass) {
                Logging.log(Logging.INFO, this.charDisplay.getName() + ": Removing level " + (this.pcClassLevels.getSize() + 1) + " in class " + classFacade);
                this.theCharacter.incrementClassLevel(-1, (PCClass)classFacade);
            }
            this.charLevelsFacade.removeLastLevel();
        }
        Iterator<ClassFacade> iterator = this.pcClasses.iterator();
        while (iterator.hasNext()) {
            classFacade = iterator.next();
            boolean stillPresent = false;
            for (CharacterLevelFacade charLevel : this.pcClassLevels) {
                if (this.charLevelsFacade.getClassTaken(charLevel) != classFacade) continue;
                stillPresent = true;
                break;
            }
            if (stillPresent) continue;
            iterator.remove();
        }
        this.postLevellingUpdates();
    }

    private void updateLevelTodo() {
        if (this.charDisplay.getXP() >= this.charDisplay.minXPForNextECL()) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Class", "in_clTodoLevelUp", 120));
        } else {
            this.todoManager.removeTodo("in_clTodoLevelUp");
        }
    }

    @Override
    public int getClassLevel(ClassFacade c) {
        int clsLevel = 0;
        String classKey = c.getKeyName();
        for (CharacterLevelFacade charLevel : this.pcClassLevels) {
            if (!this.charLevelsFacade.getClassTaken(charLevel).getKeyName().equals(classKey)) continue;
            ++clsLevel;
        }
        return clsLevel;
    }

    private boolean validateAddLevel(PCClass theClass) {
        Boolean proceed;
        SubClass subClass;
        String subClassKey;
        int levels = 1;
        if (theClass == null) {
            return false;
        }
        if (!this.theCharacter.isQualified(theClass)) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_clYouAreNotQualifiedToTakeTheClass"));
            return false;
        }
        if (!this.theCharacter.canLevelUp()) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_Enforce_rejectLevelUp"));
            return false;
        }
        PCClass aClass = this.theCharacter.getClassKeyed(theClass.getKeyName());
        if (aClass != null && (subClassKey = this.charDisplay.getSubClassName(aClass)) != null && (subClass = aClass.getSubClassKeyed(subClassKey)) != null && !this.theCharacter.isQualified(subClass)) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("in_sumYouAreNotQualifiedToTakeTheClass", aClass.getDisplayName() + "/" + subClass.getDisplayName()));
            return false;
        }
        if (!Globals.checkRule("LEVELCAP") && theClass.hasMaxLevel() && (levels > theClass.getSafe(IntegerKey.LEVEL_LIMIT) || aClass != null && this.charDisplay.getLevel(aClass) + levels > aClass.getSafe(IntegerKey.LEVEL_LIMIT))) {
            this.delegate.showInfoMessage("PCGen", LanguageBundle.getFormattedString("in_sumMaximumLevelIs", String.valueOf(theClass.getSafe(IntegerKey.LEVEL_LIMIT))));
            return false;
        }
        return this.charDisplay.getTotalLevels() != 0 || !(SettingsHandler.getGame().isPurchaseStatMode() && this.theCharacter.getPointBuyPoints() > this.getUsedStatPool() ? !this.delegate.showWarningConfirm(LanguageBundle.getString("in_sumLevelWarnTitle"), LanguageBundle.getString("in_sumPoolWarning")) : (this.allAbilitiesAreZero() ? !this.delegate.showWarningConfirm(LanguageBundle.getString("in_sumLevelWarnTitle"), LanguageBundle.getString("in_sumAbilitiesZeroWarning")) : Boolean.FALSE.equals(proceed = this.delegate.maybeShowWarningConfirm(LanguageBundle.getString("in_sumLevelWarnTitle"), LanguageBundle.getString("in_sumAbilitiesWarning"), LanguageBundle.getString("in_sumAbilitiesWarningCheckBox"), PCGenSettings.OPTIONS_CONTEXT, "showWarningAtFirstLevelUp"))));
    }

    private boolean allAbilitiesAreZero() {
        for (StatFacade stat : this.dataSet.getStats()) {
            ReferenceFacade<Integer> facade = this.getScoreBaseRef(stat);
            if (facade.getReference() == 0) continue;
            return false;
        }
        return true;
    }

    private int getUsedStatPool() {
        int i = 0;
        for (PCStat aStat : this.charDisplay.getStatSet()) {
            if (!aStat.getSafe(ObjectKey.ROLLED).booleanValue()) continue;
            int statValue = this.theCharacter.getBaseStatFor(aStat);
            i += CharacterFacadeImpl.getPurchaseCostForStat(this.theCharacter, statValue);
        }
        return i += (int)this.theCharacter.getTotalBonusTo("POINTBUY", "SPENT");
    }

    private static int getPurchaseCostForStat(PlayerCharacter aPC, int statValue) {
        int iMax = SettingsHandler.getGame().getPurchaseScoreMax(aPC);
        int iMin = SettingsHandler.getGame().getPurchaseScoreMin(aPC);
        if (statValue > iMax) {
            statValue = iMax;
        }
        if (statValue >= iMin) {
            return SettingsHandler.getGame().getAbilityScoreCost(statValue - iMin);
        }
        return 0;
    }

    void refreshAvailableTempBonuses() {
        ArrayList<TempBonusFacadeImpl> tempBonuses = new ArrayList<TempBonusFacadeImpl>();
        for (CDOMObject cDOMObject : this.theCharacter.getCDOMObjectList()) {
            this.scanForTempBonuses(tempBonuses, cDOMObject);
        }
        GameMode game = (GameMode)this.dataSet.getGameMode();
        for (AbilityCategory cat : game.getAllAbilityCategories()) {
            if (cat.getParentCategory() != cat) continue;
            for (Ability aFeat : Globals.getContext().getReferenceContext().getManufacturer(Ability.class, cat).getAllObjects()) {
                this.scanForAnyPcTempBonuses(tempBonuses, aFeat);
            }
        }
        for (Spell aSpell : this.theCharacter.aggregateSpellList("", "", "", 0, 9)) {
            this.scanForTempBonuses(tempBonuses, aSpell);
        }
        Collection<CharacterSpell> collection = this.theCharacter.getCharacterSpells((PObject)this.charDisplay.getRace(), "Innate");
        for (CharacterSpell aCharacterSpell : collection) {
            if (aCharacterSpell == null) continue;
            this.scanForTempBonuses(tempBonuses, aCharacterSpell.getSpell());
        }
        for (Spell spell : Globals.getSpellMap().values()) {
            this.scanForNonPcTempBonuses(tempBonuses, spell);
        }
        for (PCTemplate aTemp : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCTemplate.class)) {
            this.scanForNonPcTempBonuses(tempBonuses, aTemp);
        }
        Collections.sort(tempBonuses);
        this.availTempBonuses.updateContents(tempBonuses);
    }

    private void scanForNonPcTempBonuses(List<TempBonusFacadeImpl> tempBonuses, PObject obj) {
        if (obj == null) {
            return;
        }
        if (TempBonusHelper.hasNonPCTempBonus(obj, this.theCharacter)) {
            tempBonuses.add(new TempBonusFacadeImpl(obj));
        }
    }

    private void scanForAnyPcTempBonuses(List<TempBonusFacadeImpl> tempBonuses, PObject obj) {
        if (obj == null) {
            return;
        }
        if (TempBonusHelper.hasAnyPCTempBonus(obj, this.theCharacter)) {
            tempBonuses.add(new TempBonusFacadeImpl(obj));
        }
    }

    private void scanForTempBonuses(List<TempBonusFacadeImpl> tempBonuses, CDOMObject obj) {
        if (obj == null) {
            return;
        }
        if (TempBonusHelper.hasTempBonus(obj, this.theCharacter)) {
            tempBonuses.add(new TempBonusFacadeImpl(obj));
        }
    }

    @Override
    public ListFacade<TempBonusFacade> getAvailableTempBonuses() {
        return this.availTempBonuses;
    }

    private void buildAppliedTempBonusList() {
        HashSet<String> found = new HashSet<String>();
        for (BonusManager.TempBonusInfo tbi : this.theCharacter.getTempBonusMap().values()) {
            Object aC = tbi.source;
            Object aT = tbi.target;
            String name = BonusDisplay.getBonusDisplayName(tbi);
            if (found.contains(name)) continue;
            found.add(name);
            TempBonusFacadeImpl facade = new TempBonusFacadeImpl((CDOMObject)aC, aT, name);
            facade.setActive(!this.theCharacter.getTempBonusFilters().contains(name));
            this.appliedTempBonuses.addElement(facade);
        }
    }

    @Override
    public void addTempBonus(TempBonusFacade bonusFacade) {
        TempBonusFacadeImpl appliedTempBonus;
        if (bonusFacade == null || !(bonusFacade instanceof TempBonusFacadeImpl)) {
            return;
        }
        TempBonusFacadeImpl tempBonus = (TempBonusFacadeImpl)bonusFacade;
        CDOMObject originObj = tempBonus.getOriginObj();
        Equipment aEq = null;
        Object target = TempBonusHelper.getTempBonusTarget(originObj, this.theCharacter, this.delegate, this.infoFactory);
        if (target == null) {
            return;
        }
        if (target instanceof Equipment) {
            aEq = (Equipment)target;
            appliedTempBonus = TempBonusHelper.applyBonusToCharacterEquipment(aEq, originObj, this.theCharacter);
        } else {
            appliedTempBonus = TempBonusHelper.applyBonusToCharacter(originObj, this.theCharacter);
        }
        if (appliedTempBonus == null) {
            return;
        }
        this.appliedTempBonuses.addElement(appliedTempBonus);
        this.refreshStatScores();
        this.postLevellingUpdates();
    }

    @Override
    public void removeTempBonus(TempBonusFacade bonusFacade) {
        if (bonusFacade == null || !(bonusFacade instanceof TempBonusFacadeImpl)) {
            return;
        }
        TempBonusFacadeImpl tempBonus = (TempBonusFacadeImpl)bonusFacade;
        Equipment aEq = null;
        if (tempBonus.getTarget() instanceof Equipment) {
            aEq = (Equipment)tempBonus.getTarget();
        }
        CDOMObject originObj = tempBonus.getOriginObj();
        TempBonusHelper.removeBonusFromCharacter(this.theCharacter, aEq, originObj);
        this.appliedTempBonuses.removeElement(tempBonus);
        this.refreshStatScores();
        this.postLevellingUpdates();
    }

    @Override
    public void setTempBonusActive(TempBonusFacade bonusFacade, boolean active) {
        if (bonusFacade == null || !(bonusFacade instanceof TempBonusFacadeImpl)) {
            return;
        }
        TempBonusFacadeImpl tempBonus = (TempBonusFacadeImpl)bonusFacade;
        if (active) {
            this.theCharacter.unsetTempBonusFilter(tempBonus.toString());
        } else {
            this.theCharacter.setTempBonusFilter(tempBonus.toString());
        }
        tempBonus.setActive(active);
        this.appliedTempBonuses.modifyElement(tempBonus);
        this.refreshStatScores();
    }

    @Override
    public ListFacade<TempBonusFacade> getTempBonuses() {
        return this.appliedTempBonuses;
    }

    @Override
    public ReferenceFacade<AlignmentFacade> getAlignmentRef() {
        return this.alignment;
    }

    @Override
    public void setAlignment(AlignmentFacade alignment) {
        if (!this.validateAlignmentChange(alignment)) {
            return;
        }
        this.alignment.setReference(alignment);
        if (alignment instanceof PCAlignment) {
            this.theCharacter.setAlignment((PCAlignment)alignment);
        }
        this.refreshLanguageList();
    }

    private boolean validateAlignmentChange(AlignmentFacade newAlign) {
        AlignmentFacade oldAlign = this.alignment.getReference();
        if (oldAlign == null || newAlign.equals(oldAlign)) {
            return true;
        }
        if (!(newAlign instanceof PCAlignment)) {
            return true;
        }
        StringBuilder unqualified = new StringBuilder(100);
        ArrayList<PCClass> classList = this.charDisplay.getClassList();
        ArrayList<PCClass> exclassList = new ArrayList<PCClass>();
        PCAlignment savedAlignmnet = this.charDisplay.getPCAlignment();
        for (PCClass aClass : classList) {
            this.theCharacter.setAlignment((PCAlignment)newAlign);
            if (this.theCharacter.isQualified(aClass) || !aClass.containsKey(ObjectKey.EX_CLASS)) continue;
            if (unqualified.length() > 0) {
                unqualified.append(", ");
            }
            unqualified.append(aClass.getKeyName());
            exclassList.add(aClass);
        }
        if (unqualified.length() > 0 && !this.delegate.showWarningConfirm("PCGen", LanguageBundle.getString("in_sumExClassesWarning") + Constants.LINE_SEPARATOR + unqualified)) {
            this.theCharacter.setAlignment(savedAlignmnet);
            return false;
        }
        for (PCClass aClass : exclassList) {
            this.theCharacter.makeIntoExClass(aClass);
        }
        this.refreshClassLevelModel();
        return true;
    }

    void refreshClassLevelModel() {
        ArrayList<CharacterLevelFacadeImpl> newlevels = new ArrayList<CharacterLevelFacadeImpl>();
        ArrayList<PCClass> newClasses = this.charDisplay.getClassList();
        Collection<PCLevelInfo> levelInfo = this.charDisplay.getLevelInfo();
        HashMap<String, PCClass> classMap = new HashMap<String, PCClass>();
        for (PCClass pcClass : newClasses) {
            classMap.put(pcClass.getKeyName(), pcClass);
        }
        for (PCLevelInfo lvlInfo : levelInfo) {
            String classKeyName = lvlInfo.getClassKeyName();
            PCClass currClass = (PCClass)classMap.get(classKeyName);
            if (currClass == null) {
                Logging.errorPrint("No PCClass found for '" + classKeyName + "' in character's class list: " + newClasses);
                return;
            }
            CharacterLevelFacadeImpl cl = new CharacterLevelFacadeImpl(currClass, newlevels.size() + 1);
            newlevels.add(cl);
        }
        this.pcClasses.clear();
        this.pcClasses.addAll(newClasses);
        this.pcClassLevels.updateContents(newlevels);
        this.charLevelsFacade.classListRefreshRequired();
    }

    @Override
    public DataSetFacade getDataSet() {
        return this.dataSet;
    }

    @Override
    public ListFacade<EquipmentSetFacade> getEquipmentSets() {
        return this.equipmentSets;
    }

    @Override
    public ReferenceFacade<GenderFacade> getGenderRef() {
        return this.gender;
    }

    @Override
    public void setGender(GenderFacade gender) {
        this.theCharacter.setGender((Gender)gender);
        Gender newGender = this.charDisplay.getGenderObject();
        this.selectedGender = newGender.toString();
        this.gender.setReference(newGender);
        this.refreshLanguageList();
    }

    @Override
    public void setGender(String gender) {
        this.selectedGender = gender;
        if (this.charDisplay.getRace() != null) {
            for (GenderFacade raceGender : this.availGenders) {
                if (!raceGender.toString().equals(gender)) continue;
                this.setGender(raceGender);
            }
        }
    }

    @Override
    public int getModTotal(StatFacade stat) {
        if (stat instanceof PCStat && !this.charDisplay.isNonAbility((PCStat)stat)) {
            return this.theCharacter.getStatModFor((PCStat)stat);
        }
        return 0;
    }

    @Override
    public ReferenceFacade<Integer> getScoreBaseRef(StatFacade stat) {
        DefaultReferenceFacade<Integer> score = this.statScoreMap.get(stat);
        if (score == null) {
            score = new DefaultReferenceFacade<Integer>(this.theCharacter.getTotalStatFor((PCStat)stat));
            this.statScoreMap.put(stat, score);
        }
        return score;
    }

    @Override
    public int getScoreBase(StatFacade stat) {
        if (!(stat instanceof PCStat)) {
            return 0;
        }
        return this.theCharacter.getBaseStatFor((PCStat)stat);
    }

    @Override
    public String getScoreTotalString(StatFacade stat) {
        if (!(stat instanceof PCStat)) {
            return "";
        }
        if (this.charDisplay.isNonAbility((PCStat)stat)) {
            return "*";
        }
        return SettingsHandler.getGame().getStatDisplayText(this.theCharacter.getTotalStatFor((PCStat)stat));
    }

    @Override
    public int getScoreRaceBonus(StatFacade stat) {
        if (!(stat instanceof PCStat)) {
            return 0;
        }
        PCStat activeStat = (PCStat)stat;
        if (this.charDisplay.isNonAbility(activeStat)) {
            return 0;
        }
        int rBonus = (int)this.theCharacter.getRaceBonusTo("STAT", activeStat.getKeyName());
        return rBonus += (int)this.theCharacter.getBonusDueToType("STAT", activeStat.getKeyName(), "RACIAL");
    }

    @Override
    public int getScoreOtherBonus(StatFacade stat) {
        if (!(stat instanceof PCStat)) {
            return 0;
        }
        PCStat activeStat = (PCStat)stat;
        if (this.charDisplay.isNonAbility(activeStat)) {
            return 0;
        }
        int iRace = (int)this.theCharacter.getRaceBonusTo("STAT", activeStat.getKeyName());
        return this.theCharacter.getTotalStatFor(activeStat) - this.theCharacter.getBaseStatFor(activeStat) - (iRace += (int)this.theCharacter.getBonusDueToType("STAT", activeStat.getKeyName(), "RACIAL"));
    }

    @Override
    public void setScoreBase(StatFacade stat, int score) {
        DefaultReferenceFacade<Integer> facade = this.statScoreMap.get(stat);
        if (facade == null) {
            facade = new DefaultReferenceFacade<Integer>(score);
            this.statScoreMap.put(stat, facade);
        }
        PCStat pcStat = null;
        int pcPlayerLevels = this.charDisplay.totalNonMonsterLevels();
        Collection<PCStat> pcStatList = this.charDisplay.getStatSet();
        for (PCStat aStat : pcStatList) {
            if (!stat.getKeyName().equals(aStat.getKeyName())) continue;
            pcStat = aStat;
            break;
        }
        if (pcStat == null) {
            Logging.errorPrint("Unexpected stat '" + stat + "' found - ignoring.");
            return;
        }
        String errorMsg = this.validateNewStatBaseScore(score, pcStat, pcPlayerLevels);
        if (StringUtils.isNotBlank(errorMsg)) {
            this.delegate.showErrorMessage("PCGen", errorMsg);
            return;
        }
        int baseScore = this.charDisplay.getStat(pcStat);
        if (Globals.getGameModeHasPointPool() && pcPlayerLevels > 0) {
            int poolMod = CharacterFacadeImpl.getPurchaseCostForStat(this.theCharacter, score) - CharacterFacadeImpl.getPurchaseCostForStat(this.theCharacter, baseScore);
            if (poolMod > 0) {
                if (poolMod > this.theCharacter.getSkillPoints()) {
                    this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("in_sumStatPoolEmpty", Globals.getGameModePointPoolName()));
                    return;
                }
            } else if (poolMod < 0 && this.theCharacter.getStatIncrease(pcStat, true) < Math.abs(score - baseScore)) {
                this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_sumStatStartedHigher"));
                return;
            }
            this.theCharacter.adjustAbilities(AbilityCategory.FEAT, new BigDecimal(-poolMod));
            this.showPointPool();
        }
        this.theCharacter.setStat(pcStat, score);
        facade.setReference(score);
        this.theCharacter.saveStatIncrease(pcStat, score - baseScore, false);
        this.theCharacter.calcActiveBonuses();
        this.hpRef.setReference(this.theCharacter.hitPoints());
        this.refreshLanguageList();
        this.updateScorePurchasePool(true);
        if (this.charLevelsFacade != null) {
            this.charLevelsFacade.fireSkillBonusEvent(this, 0, true);
        }
    }

    private String validateNewStatBaseScore(int score, PCStat pcStat, int pcPlayerLevels) {
        if (this.charDisplay.isNonAbility(pcStat)) {
            return LanguageBundle.getString("in_sumCannotModifyANonAbility");
        }
        if (score < pcStat.getSafe(IntegerKey.MIN_VALUE)) {
            return LanguageBundle.getFormattedString("in_sumCannotLowerStatBelow", SettingsHandler.getGame().getStatDisplayText(pcStat.getSafe(IntegerKey.MIN_VALUE)));
        }
        if (score > pcStat.getSafe(IntegerKey.MAX_VALUE)) {
            return LanguageBundle.getFormattedString("in_sumCannotRaiseStatAbove", SettingsHandler.getGame().getStatDisplayText(pcStat.getSafe(IntegerKey.MAX_VALUE)));
        }
        if (pcPlayerLevels < 2 && SettingsHandler.getGame().isPurchaseStatMode()) {
            int maxPurchaseScore = SettingsHandler.getGame().getPurchaseScoreMax(this.theCharacter);
            if (score > maxPurchaseScore) {
                return LanguageBundle.getFormattedString("in_sumCannotRaiseStatAbovePurchase", SettingsHandler.getGame().getStatDisplayText(maxPurchaseScore));
            }
            int minPurchaseScore = SettingsHandler.getGame().getPurchaseScoreMin(this.theCharacter);
            if (score < minPurchaseScore) {
                return LanguageBundle.getFormattedString("in_sumCannotLowerStatBelowPurchase", SettingsHandler.getGame().getStatDisplayText(minPurchaseScore));
            }
        }
        return null;
    }

    @Override
    public void rollStats() {
        GameMode game = (GameMode)this.dataSet.getGameMode();
        int rollMethod = game.getRollMethod();
        if (rollMethod == 3 && game.getCurrentRollingMethod() == null) {
            return;
        }
        if (rollMethod == 0) {
            rollMethod = 1;
        }
        this.theCharacter.rollStats(rollMethod);
        this.theCharacter.calcActiveBonuses();
        this.refreshStatScores();
        this.updateScorePurchasePool(true);
    }

    private void refreshStatScores() {
        for (StatFacade stat : this.statScoreMap.keySet()) {
            DefaultReferenceFacade<Integer> score = this.statScoreMap.get(stat);
            if (!(stat instanceof PCStat)) continue;
            score.setReference(this.theCharacter.getTotalStatFor((PCStat)stat));
        }
        if (this.charLevelsFacade != null) {
            this.charLevelsFacade.fireSkillBonusEvent(this, 0, true);
            this.charLevelsFacade.updateSkillsTodo();
        }
    }

    @Override
    public boolean isStatRollEnabled() {
        return this.charLevelsFacade.getSize() == 0;
    }

    private void showPointPool() {
        if (this.poolPointText == null) {
            return;
        }
        int poolPointsTotal = 0;
        for (PCLevelInfo pcl : this.charDisplay.getLevelInfo()) {
            poolPointsTotal += pcl.getSkillPointsGained(this.theCharacter);
        }
        int poolPointsUsed = poolPointsTotal - this.theCharacter.getSkillPoints();
        this.poolPointText.setReference(Integer.toString(poolPointsUsed) + " / " + Integer.toString(poolPointsTotal));
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public ReferenceFacade<RaceFacade> getRaceRef() {
        return this.race;
    }

    @Override
    public ListFacade<RaceFacade> getRaceAsList() {
        return this.raceList;
    }

    @Override
    public void setRace(RaceFacade race) {
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        int oldLevel = this.charLevelsFacade.getSize();
        if (race == null) {
            race = Globals.s_EMPTYRACE;
        }
        this.race.setReference(race);
        if (race instanceof Race && race != this.charDisplay.getRace()) {
            Logging.log(Logging.INFO, this.charDisplay.getName() + ": Setting race to " + race);
            this.theCharacter.setRace((Race)race);
            this.raceList.clearContents();
            if (race != Globals.s_EMPTYRACE) {
                this.raceList.addElement(race);
            }
        }
        this.refreshLanguageList();
        if (this.selectedGender != null) {
            this.setGender(this.selectedGender);
        }
        this.refreshRaceRelatedFields();
        if (oldLevel != this.charLevelsFacade.getSize()) {
            this.delegate.showLevelUpInfo(this, oldLevel);
        }
    }

    private void refreshRaceRelatedFields() {
        this.race.setReference(this.charDisplay.getRace());
        if (this.charDisplay.getRace() != null) {
            for (HandedFacade handsFacade : this.availHands) {
                if (!handsFacade.toString().equals(this.charDisplay.getHanded())) continue;
                this.handedness.setReference(handsFacade);
                break;
            }
            for (GenderFacade pcGender : this.availGenders) {
                if (!pcGender.equals(this.charDisplay.getGenderObject())) continue;
                this.gender.setReference(pcGender);
                break;
            }
        }
        this.refreshClassLevelModel();
        this.refreshStatScores();
        this.age.setReference(this.charDisplay.getAge());
        this.updateAgeCategoryForAge();
        this.refreshHeightWeight();
        this.characterAbilities.rebuildAbilityLists();
        this.currentXP.setReference(this.charDisplay.getXP());
        this.xpForNextlevel.setReference(this.charDisplay.minXPForNextECL());
        this.xpTableName.setReference(this.charDisplay.getXPTableName());
        this.hpRef.setReference(this.theCharacter.hitPoints());
        this.alignment.setReference(this.charDisplay.getPCAlignment());
        this.refreshAvailableTempBonuses();
        this.companionSupportFacade.refreshCompanionData();
        this.updateLevelTodo();
        this.buildAvailableDomainsList();
        this.spellSupportFacade.refreshAvailableKnownSpells();
        this.updateScorePurchasePool(false);
        this.refreshEquipment();
        if (this.charDisplay.getRace() == null || "<none selected>".equals(this.charDisplay.getRace().getKeyName())) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Race", "in_irTodoRace", 100));
        } else {
            this.todoManager.removeTodo("in_irTodoRace");
        }
    }

    @Override
    public ReferenceFacade<String> getTabNameRef() {
        return this.tabName;
    }

    @Override
    public void setTabName(String name) {
        this.tabName.setReference(name);
        this.theCharacter.setTabName(name);
    }

    @Override
    public ReferenceFacade<String> getNameRef() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name.setReference(name);
        this.theCharacter.setName(name);
        if (this.isNewCharName(this.charDisplay.getName())) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Name", "in_sumTodoName", 1));
        } else {
            this.todoManager.removeTodo("in_sumTodoName");
        }
    }

    @Override
    public boolean getExportBioField(BiographyField field) {
        return !this.charDisplay.getSuppressBioField(field);
    }

    @Override
    public void setExportBioField(BiographyField field, boolean export) {
        this.theCharacter.setSuppressBioField(field, !export);
    }

    @Override
    public ReferenceFacade<String> getSkinColorRef() {
        return this.skinColor;
    }

    @Override
    public void setSkinColor(String color) {
        this.skinColor.setReference(color);
        this.theCharacter.setSkinColor(color);
    }

    @Override
    public ReferenceFacade<String> getHairColorRef() {
        return this.hairColor;
    }

    @Override
    public void setHairColor(String color) {
        this.hairColor.setReference(color);
        this.theCharacter.setHairColor(color);
    }

    @Override
    public ReferenceFacade<String> getEyeColorRef() {
        return this.eyeColor;
    }

    @Override
    public void setEyeColor(String color) {
        this.eyeColor.setReference(color);
        this.theCharacter.setEyeColor(color);
    }

    @Override
    public ReferenceFacade<Integer> getHeightRef() {
        return this.heightRef;
    }

    @Override
    public void setHeight(int height) {
        int heightInInches = Globals.getGameModeUnitSet().convertHeightFromUnitSet(height);
        this.heightRef.setReference(height);
        this.theCharacter.setHeight(heightInInches);
    }

    @Override
    public ReferenceFacade<Integer> getWeightRef() {
        return this.weightRef;
    }

    @Override
    public void setWeight(int weight) {
        int weightInPounds = (int)Globals.getGameModeUnitSet().convertWeightFromUnitSet(weight);
        this.weightRef.setReference(weight);
        this.theCharacter.setWeight(weightInPounds);
    }

    @Override
    public ReferenceFacade<DeityFacade> getDeityRef() {
        return this.deity;
    }

    @Override
    public void setDeity(DeityFacade deity) {
        this.deity.setReference(deity);
        if (deity instanceof Deity) {
            this.theCharacter.setDeity((Deity)deity);
        }
        this.refreshLanguageList();
        this.buildAvailableDomainsList();
    }

    @Override
    public void addDomain(DomainFacade domainFacade) {
        if (!(domainFacade instanceof DomainFacadeImpl)) {
            return;
        }
        DomainFacadeImpl domainFI = (DomainFacadeImpl)domainFacade;
        Domain domain = (Domain)domainFI.getRawObject();
        if (this.charDisplay.hasDomain(domain)) {
            return;
        }
        if (!this.isQualifiedFor(domainFacade)) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("in_qualifyMess", domain.getDisplayName()));
            return;
        }
        if (this.charDisplay.getDomainCount() >= this.theCharacter.getMaxCharacterDomains()) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("in_errorNoMoreDomains", new Object[0]));
            return;
        }
        if (!this.theCharacter.hasDefaultDomainSource()) {
            int level = this.charDisplay.getLevelInfoSize();
            PCLevelInfo highestLevelInfo = this.charDisplay.getLevelInfo(level - 1);
            PCClass cls = this.theCharacter.getClassKeyed(highestLevelInfo.getClassKeyName());
            this.theCharacter.setDefaultDomainSource(new ClassSource(cls, highestLevelInfo.getClassLevel()));
        }
        if (this.theCharacter.addDomain(domain)) {
            this.domains.addElement(domainFI);
            DomainApplication.applyDomain(this.theCharacter, domain);
            this.theCharacter.calcActiveBonuses();
            this.remainingDomains.setReference(this.theCharacter.getMaxCharacterDomains() - this.charDisplay.getDomainCount());
            this.updateDomainTodo();
            this.spellSupportFacade.refreshAvailableKnownSpells();
            this.companionSupportFacade.refreshCompanionData();
        }
    }

    @Override
    public ListFacade<DomainFacade> getDomains() {
        return this.domains;
    }

    @Override
    public void removeDomain(DomainFacade domain) {
        if (this.domains.removeElement(domain)) {
            Domain dom = (Domain)((DomainFacadeImpl)domain).getRawObject();
            DomainApplication.removeDomain(this.theCharacter, dom);
            this.theCharacter.removeDomain((Domain)((DomainFacadeImpl)domain).getRawObject());
            this.remainingDomains.setReference(this.theCharacter.getMaxCharacterDomains() - this.charDisplay.getDomainCount());
            this.updateDomainTodo();
            this.spellSupportFacade.refreshAvailableKnownSpells();
        }
    }

    private void updateDomainTodo() {
        if (this.remainingDomains.getReference() > 0) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.DOMAINS, "Domains", "in_domTodoDomainsLeft", 120));
            this.todoManager.removeTodo("in_domTodoTooManyDomains");
        } else if (this.remainingDomains.getReference() < 0) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.DOMAINS, "Domains", "in_domTodoTooManyDomains", 120));
            this.todoManager.removeTodo("in_domTodoDomainsLeft");
        } else {
            this.todoManager.removeTodo("in_domTodoDomainsLeft");
            this.todoManager.removeTodo("in_domTodoTooManyDomains");
        }
    }

    @Override
    public ReferenceFacade<Integer> getMaxDomains() {
        return this.maxDomains;
    }

    @Override
    public ReferenceFacade<Integer> getRemainingDomainSelectionsRef() {
        return this.remainingDomains;
    }

    @Override
    public ListFacade<DomainFacade> getAvailableDomains() {
        return this.availDomains;
    }

    private void buildAvailableDomainsList() {
        ArrayList<DomainFacadeImpl> availDomainList = new ArrayList<DomainFacadeImpl>();
        ArrayList<DomainFacadeImpl> selDomainList = new ArrayList<DomainFacadeImpl>();
        Deity pcDeity = this.charDisplay.getDeity();
        if (pcDeity != null) {
            for (CDOMReference cDOMReference : pcDeity.getSafeListMods(Deity.DOMAINLIST)) {
                Collection<AssociatedPrereqObject> assoc = pcDeity.getListAssociations(Deity.DOMAINLIST, cDOMReference);
                for (AssociatedPrereqObject apo : assoc) {
                    for (Domain d : cDOMReference.getContainedObjects()) {
                        if (this.isDomainInList(availDomainList, d)) continue;
                        availDomainList.add(new DomainFacadeImpl(d, apo.getPrerequisiteList()));
                    }
                }
            }
        }
        for (PCClass pCClass : this.charDisplay.getClassList()) {
            this.processDomainList(pCClass, availDomainList);
            this.processAddDomains(pCClass, availDomainList);
            for (int lvl = 0; lvl <= this.charDisplay.getLevel(pCClass); ++lvl) {
                PCClassLevel cl = this.charDisplay.getActiveClassLevel(pCClass, lvl);
                this.processAddDomains(cl, availDomainList);
                this.processDomainList(cl, availDomainList);
            }
        }
        for (Domain domain : this.charDisplay.getDomainSet()) {
            DomainFacadeImpl domainFI = new DomainFacadeImpl(domain);
            boolean found = false;
            for (DomainFacadeImpl row : availDomainList) {
                if (!domain.equals(row.getRawObject())) continue;
                domainFI = row;
                found = true;
                break;
            }
            if (!found) {
                availDomainList.add(domainFI);
            }
            if (this.isDomainInList(selDomainList, domain)) continue;
            selDomainList.add(domainFI);
        }
        this.availDomains.updateContents(availDomainList);
        this.domains.updateContents(selDomainList);
        this.maxDomains.setReference(this.theCharacter.getMaxCharacterDomains());
        this.remainingDomains.setReference(this.theCharacter.getMaxCharacterDomains() - this.charDisplay.getDomainCount());
        this.updateDomainTodo();
    }

    private boolean isDomainInList(List<DomainFacadeImpl> qualDomainList, Domain domain) {
        for (DomainFacadeImpl row : qualDomainList) {
            if (!domain.equals(row.getRawObject())) continue;
            return true;
        }
        return false;
    }

    private void processAddDomains(CDOMObject cdo, List<DomainFacadeImpl> availDomainList) {
        Collection domainRefs = cdo.getListMods(PCClass.ALLOWED_DOMAINS);
        if (domainRefs != null) {
            for (CDOMReference ref : domainRefs) {
                Collection<AssociatedPrereqObject> assoc = cdo.getListAssociations(PCClass.ALLOWED_DOMAINS, ref);
                for (AssociatedPrereqObject apo : assoc) {
                    for (Domain d : ref.getContainedObjects()) {
                        if (this.isDomainInList(availDomainList, d)) continue;
                        availDomainList.add(new DomainFacadeImpl(d, apo.getPrerequisiteList()));
                    }
                }
            }
        }
    }

    private void processDomainList(CDOMObject obj, List<DomainFacadeImpl> availDomainList) {
        for (QualifiedObject<CDOMSingleRef<Domain>> qo : obj.getSafeListFor(ListKey.DOMAIN)) {
            CDOMSingleRef<Domain> ref = qo.getRawObject();
            Domain domain = ref.resolvesTo();
            if (this.isDomainInList(availDomainList, domain)) continue;
            availDomainList.add(new DomainFacadeImpl(domain, qo.getPrerequisiteList()));
        }
    }

    @Override
    public ReferenceFacade<EquipmentSetFacade> getEquipmentSetRef() {
        return this.equipSet;
    }

    @Override
    public void setEquipmentSet(EquipmentSetFacade set) {
        EquipmentSetFacade oldSet = this.equipSet.getReference();
        if (oldSet != null) {
            oldSet.getEquippedItems().removeListListener(this);
            oldSet.getEquippedItems().removeEquipmentListListener(this);
        }
        if (set instanceof EquipmentSetFacadeImpl) {
            ((EquipmentSetFacadeImpl)set).activateEquipSet();
        }
        this.equipSet.setReference(set);
        set.getEquippedItems().addListListener(this);
        set.getEquippedItems().addEquipmentListListener(this);
        this.refreshTotalWeight();
    }

    void refreshLanguageList() {
        long startTime = new Date().getTime();
        ArrayList<Language> sortedLanguages = new ArrayList<Language>(this.charDisplay.getLanguageSet());
        Collections.sort(sortedLanguages);
        this.languages.updateContents(sortedLanguages);
        this.autoLanguagesCache = null;
        boolean allowBonusLangAfterFirst = Globals.checkRule("INTBONUSLANG");
        boolean atFirstLvl = this.theCharacter.getTotalLevels() <= 1;
        int bonusLangMax = this.theCharacter.getBonusLanguageCount();
        this.currBonusLangs = new ArrayList<Language>();
        CNAbility a = this.theCharacter.getBonusLanguageAbility();
        List<String> currBonusLangNameList = this.theCharacter.getAssociationList(a);
        for (LanguageFacade langFacade : this.languages) {
            Language lang = (Language)langFacade;
            if (!currBonusLangNameList.contains(lang.getKeyName())) continue;
            this.currBonusLangs.add(lang);
        }
        int bonusLangRemain = bonusLangMax - this.currBonusLangs.size();
        if (!allowBonusLangAfterFirst && !atFirstLvl) {
            bonusLangRemain = 0;
        }
        this.numBonusLang.setReference(bonusLangRemain);
        if (bonusLangRemain > 0) {
            if (allowBonusLangAfterFirst) {
                this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Languages", "in_sumTodoBonusLanguage", 110));
                this.todoManager.removeTodo("in_sumTodoBonusLanguageFirstOnly");
            } else {
                this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Languages", "in_sumTodoBonusLanguageFirstOnly", 110));
                this.todoManager.removeTodo("in_sumTodoBonusLanguage");
            }
        } else {
            this.todoManager.removeTodo("in_sumTodoBonusLanguage");
            this.todoManager.removeTodo("in_sumTodoBonusLanguageFirstOnly");
        }
        int numSkillLangSelected = 0;
        int skillLangMax = 0;
        SkillFacade speakLangSkill = this.dataSet.getSpeakLanguageSkill();
        if (speakLangSkill != null) {
            Skill skill = (Skill)speakLangSkill;
            List<String> langList = this.theCharacter.getAssociationList(skill);
            numSkillLangSelected = langList.size();
            skillLangMax = SkillRankControl.getTotalRank(this.theCharacter, skill).intValue();
        }
        int skillLangRemain = skillLangMax - numSkillLangSelected;
        this.numSkillLang.setReference(skillLangRemain);
        if (skillLangRemain > 0) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Languages", "in_sumTodoSkillLanguage", 112));
        } else {
            this.todoManager.removeTodo("in_sumTodoSkillLanguage");
        }
        if (skillLangRemain < 0) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Languages", "in_sumTodoSkillLanguageTooMany", 112));
        } else {
            this.todoManager.removeTodo("in_sumTodoSkillLanguageTooMany");
        }
        long endTime = new Date().getTime();
        Logging.log(Logging.DEBUG, "refreshLanguageList took " + (endTime - startTime) + " ms.");
    }

    @Override
    public ListFacade<LanguageFacade> getLanguages() {
        return this.languages;
    }

    @Override
    public ListFacade<LanguageChooserFacade> getLanguageChoosers() {
        CNAbility cna = this.theCharacter.getBonusLanguageAbility();
        DefaultListFacade<LanguageChooserFacade> chooserList = new DefaultListFacade<LanguageChooserFacade>();
        chooserList.addElement(new LanguageChooserFacadeImpl(this, LanguageBundle.getString("in_sumLangBonus"), cna));
        SkillFacade speakLangSkill = this.dataSet.getSpeakLanguageSkill();
        if (speakLangSkill != null) {
            chooserList.addElement(new LanguageChooserFacadeImpl(this, LanguageBundle.getString("in_sumLangSkill"), (Skill)speakLangSkill));
        }
        return chooserList;
    }

    @Override
    public void removeLanguage(LanguageFacade lang) {
        ChooseDriver owner = this.getLaguageOwner(lang);
        if (owner == null) {
            return;
        }
        ArrayList availLangs = new ArrayList();
        ArrayList selLangs = new ArrayList();
        ChoiceManagerList choiceManager = ChooserUtilities.getChoiceManager(owner, this.theCharacter);
        choiceManager.getChoices(this.theCharacter, availLangs, selLangs);
        selLangs.remove(lang);
        choiceManager.applyChoices(this.theCharacter, selLangs);
    }

    private ChooseDriver getLaguageOwner(LanguageFacade lang) {
        if (this.currBonusLangs.contains(lang)) {
            return this.theCharacter.getBonusLanguageAbility();
        }
        if (this.languages.containsElement(lang) && !this.isAutomatic(lang)) {
            return (Skill)this.dataSet.getSpeakLanguageSkill();
        }
        return null;
    }

    @Override
    public ReferenceFacade<File> getFileRef() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file.setReference(file);
        try {
            this.theCharacter.setFileName(file.getCanonicalPath());
        }
        catch (IOException e) {
            Logging.errorPrint("CharacterFacadeImpl.setFile failed for " + file, e);
            this.theCharacter.setFileName(file.getPath());
        }
    }

    private synchronized PlayerCharacter getExportCharacter() {
        PlayerCharacter exportPc = this.lastExportChar;
        if (exportPc == null || this.theCharacter.getSerial() != this.lastExportCharSerial) {
            this.lastExportCharSerial = this.theCharacter.getSerial();
            exportPc = this.theCharacter.clone();
            exportPc.preparePCForOutput();
            this.lastExportChar = exportPc;
            int countSerialChanges = this.theCharacter.getSerial() - this.lastExportCharSerial;
            if (countSerialChanges > 0) {
                Logging.log(Logging.DEBUG, "Player character " + exportPc.getName() + " changed " + countSerialChanges + " times during export.");
            }
        }
        return exportPc;
    }

    @Override
    public void export(ExportHandler theHandler, BufferedWriter buf) throws ExportException {
        int maxRetries = 3;
        for (int i = 0; i < 3; ++i) {
            try {
                Logging.log(Logging.DEBUG, "Starting export at serial " + this.theCharacter.getSerial() + " to " + theHandler.getTemplateFile());
                PlayerCharacter exportPc = this.getExportCharacter();
                theHandler.write(exportPc, buf);
                Logging.log(Logging.DEBUG, "Finished export at serial " + this.theCharacter.getSerial() + " to " + theHandler.getTemplateFile());
                return;
            }
            catch (ConcurrentModificationException e) {
                Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
                for (Map.Entry<Thread, StackTraceElement[]> threadEntry : allStackTraces.entrySet()) {
                    if (threadEntry.getValue().length <= 1) continue;
                    StringBuilder sb = new StringBuilder("Thread: " + threadEntry.getKey() + "\n");
                    for (StackTraceElement elem : threadEntry.getValue()) {
                        sb.append("  ");
                        sb.append(elem.toString());
                        sb.append("\n");
                    }
                    Logging.log(Logging.INFO, sb.toString());
                }
                Logging.log(Logging.WARNING, "Retrying export after ConcurrentModificationException", e);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    Logging.errorPrint("Interrupted sleep - probably closing.");
                    return;
                }
            }
        }
        Logging.errorPrint("Unable to export using " + theHandler.getTemplateFile() + " due to concurrent modifications.");
    }

    @Override
    public void setDefaultOutputSheet(boolean pdf, File outputSheet) {
        UIPropertyContext context = UIPropertyContext.getInstance();
        String outputSheetPath = outputSheet.getAbsolutePath();
        if (pdf) {
            context.setProperty("defaultPdfOutputSheet", outputSheetPath);
        } else {
            context.setProperty("defaultHtmlOutputSheet", outputSheetPath);
        }
        if (context.getBoolean("saveOutputSheetWithPC")) {
            if (pdf) {
                this.theCharacter.setSelectedCharacterPDFOutputSheet(outputSheetPath);
            } else {
                this.theCharacter.setSelectedCharacterHTMLOutputSheet(outputSheetPath);
            }
        }
    }

    @Override
    public String getDefaultOutputSheet(boolean pdf) {
        String sheet;
        UIPropertyContext context = UIPropertyContext.getInstance();
        if (context.getBoolean("saveOutputSheetWithPC") && StringUtils.isNotEmpty(sheet = pdf ? this.theCharacter.getSelectedCharacterPDFOutputSheet() : this.theCharacter.getSelectedCharacterHTMLOutputSheet())) {
            return sheet;
        }
        if (pdf) {
            return context.getProperty("defaultPdfOutputSheet");
        }
        return context.getProperty("defaultHtmlOutputSheet");
    }

    @Override
    public ReferenceFacade<HandedFacade> getHandedRef() {
        return this.handedness;
    }

    @Override
    public void setHanded(HandedFacade handedness) {
        this.handedness.setReference(handedness);
        this.theCharacter.setHanded((Handed)handedness);
    }

    @Override
    public ReferenceFacade<String> getPlayersNameRef() {
        return this.playersName;
    }

    @Override
    public void setPlayersName(String name) {
        this.playersName.setReference(name);
        this.theCharacter.setPlayersName(name);
    }

    @Override
    public boolean isQualifiedFor(ClassFacade c) {
        if (c instanceof PCClass) {
            return this.theCharacter.isQualified((PCClass)c);
        }
        return false;
    }

    @Override
    public UIDelegate getUIDelegate() {
        return this.delegate;
    }

    public void save() throws NullPointerException, IOException {
        GameMode mode = (GameMode)this.dataSet.getGameMode();
        List<CampaignFacade> campaigns = ListFacades.wrap(this.dataSet.getCampaigns());
        new PCGIOHandler().write(this.theCharacter, mode, campaigns, this.file.getReference());
        this.theCharacter.setDirty(false);
    }

    @Override
    public boolean isAutomatic(LanguageFacade language) {
        if (this.autoLanguagesCache == null) {
            this.autoLanguagesCache = this.charDisplay.getAutoLanguages();
        }
        return this.autoLanguagesCache.contains(language);
    }

    @Override
    public boolean isRemovable(LanguageFacade language) {
        if (this.isAutomatic(language)) {
            return false;
        }
        if (this.currBonusLangs.contains(language)) {
            boolean allowBonusLangAfterFirst = Globals.checkRule("INTBONUSLANG");
            boolean atFirstLvl = this.theCharacter.getTotalLevels() <= 1;
            return allowBonusLangAfterFirst || atFirstLvl;
        }
        return true;
    }

    @Override
    public CharacterLevelsFacade getCharacterLevelsFacade() {
        return this.charLevelsFacade;
    }

    @Override
    public DescriptionFacade getDescriptionFacade() {
        return this.descriptionFacade;
    }

    @Override
    public void setXP(int xp) {
        if (xp == this.currentXP.getReference()) {
            return;
        }
        this.theCharacter.setXP(xp);
    }

    @Override
    public ReferenceFacade<Integer> getXPRef() {
        return this.currentXP;
    }

    @Override
    public void adjustXP(int xp) {
        int currVal = this.currentXP.getReference();
        int newVal = currVal + xp;
        this.theCharacter.setXP(newVal);
        this.checkForNewLevel();
    }

    @Override
    public ReferenceFacade<Integer> getXPForNextLevelRef() {
        return this.xpForNextlevel;
    }

    @Override
    public ReferenceFacade<String> getXPTableNameRef() {
        return this.xpTableName;
    }

    @Override
    public void setXPTable(String newTable) {
        this.xpTableName.setReference(newTable);
        this.theCharacter.setXPTable(newTable);
        this.checkForNewLevel();
    }

    private void checkForNewLevel() {
        this.currentXP.setReference(this.charDisplay.getXP());
        this.xpForNextlevel.setReference(this.charDisplay.minXPForNextECL());
        if (this.charDisplay.getXP() >= this.charDisplay.minXPForNextECL()) {
            this.delegate.showInfoMessage("PCGen", SettingsHandler.getGame().getLevelUpMessage());
        }
        this.updateLevelTodo();
    }

    @Override
    public ReferenceFacade<String> getCharacterTypeRef() {
        return this.characterType;
    }

    @Override
    public void setCharacterType(String newType) {
        this.characterType.setReference(newType);
        this.theCharacter.setCharacterType(newType);
        this.theCharacter.calcActiveBonuses();
        this.characterAbilities.rebuildAbilityLists();
    }

    @Override
    public ReferenceFacade<String> getPreviewSheetRef() {
        return this.previewSheet;
    }

    @Override
    public void setPreviewSheet(String newSheet) {
        this.previewSheet.setReference(newSheet);
        this.theCharacter.setPreviewSheet(newSheet);
    }

    @Override
    public ReferenceFacade<SkillFilter> getSkillFilterRef() {
        return this.skillFilter;
    }

    @Override
    public void setSkillFilter(SkillFilter newFilter) {
        this.skillFilter.setReference(newFilter);
        this.theCharacter.setSkillFilter(newFilter);
    }

    @Override
    public void setAge(int age) {
        if (age == this.age.getReference()) {
            return;
        }
        this.theCharacter.setAge(age);
        this.age.setReference(age);
        this.updateAgeCategoryForAge();
        this.refreshStatScores();
        this.refreshLanguageList();
    }

    private void updateAgeCategoryForAge() {
        AgeSet ageSet = this.charDisplay.getAgeSet();
        if (ageSet != null) {
            String ageCatName = ageSet.getName();
            for (SimpleFacade ageCatFacade : this.ageCategoryList) {
                if (!ageCatFacade.toString().equals(ageCatName)) continue;
                this.ageCategory.setReference(ageCatFacade);
            }
        }
    }

    @Override
    public ReferenceFacade<Integer> getAgeRef() {
        return this.age;
    }

    @Override
    public ListFacade<SimpleFacade> getAgeCategories() {
        return this.ageCategoryList;
    }

    @Override
    public void setAgeCategory(SimpleFacade ageCat) {
        int idx;
        if (ageCat == this.ageCategory.getReference()) {
            return;
        }
        Race pcRace = this.charDisplay.getRace();
        String selAgeCat = ageCat.toString();
        if (pcRace != null && !pcRace.equals(Globals.s_EMPTYRACE) && selAgeCat != null && (idx = Globals.getBioSet().getAgeSetNamed(selAgeCat)) >= 0) {
            this.ageCategory.setReference(ageCat);
            Globals.getBioSet().randomize("AGECAT" + Integer.toString(idx), this.theCharacter);
            this.age.setReference(this.charDisplay.getAge());
            this.ageCategory.setReference(ageCat);
            this.refreshStatScores();
            this.refreshLanguageList();
        }
    }

    @Override
    public ReferenceFacade<SimpleFacade> getAgeCategoryRef() {
        return this.ageCategory;
    }

    private void updateScorePurchasePool(boolean checkPurchasePoints) {
        int usedStatPool = this.getUsedStatPool();
        if (SettingsHandler.getGame().isPurchaseStatMode()) {
            if (this.canChangePurchasePool()) {
                this.theCharacter.setCostPool(usedStatPool);
                this.theCharacter.setPoolAmount(usedStatPool);
            }
            String bString = Integer.toString(this.theCharacter.getCostPool());
            int availablePool = this.theCharacter.getPointBuyPoints();
            if (availablePool < 0) {
                availablePool = RollingMethods.roll(SettingsHandler.getGame().getPurchaseModeMethodPoolFormula());
                this.theCharacter.setPointBuyPoints(availablePool);
            }
            if (availablePool != 0) {
                this.statTotalLabelText.setReference(LanguageBundle.getFormattedString("in_sumStatCost", SettingsHandler.getGame().getPurchaseModeMethodName()));
                this.statTotalText.setReference(LanguageBundle.getFormattedString("in_sumStatPurchaseDisplay", bString, availablePool));
                this.modTotalLabelText.setReference("");
                this.modTotalText.setReference("");
            }
            if (checkPurchasePoints && availablePool != 0 && this.canChangePurchasePool() && availablePool > 0 && usedStatPool > availablePool) {
                this.delegate.showInfoMessage("PCGen", LanguageBundle.getFormattedString("in_sumYouHaveExcededTheMaximumPointsOf", String.valueOf(availablePool), SettingsHandler.getGame().getPurchaseModeMethodName()));
            }
        }
        if (!SettingsHandler.getGame().isPurchaseStatMode() || this.theCharacter.getPointBuyPoints() == 0) {
            int statTotal = 0;
            int modTotal = 0;
            for (PCStat aStat : this.charDisplay.getStatSet()) {
                if (this.charDisplay.isNonAbility(aStat) || !aStat.getSafe(ObjectKey.ROLLED).booleanValue()) continue;
                int currentStat = this.theCharacter.getBaseStatFor(aStat);
                int currentMod = this.theCharacter.getStatModFor(aStat);
                statTotal += currentStat;
                modTotal += currentMod;
            }
            this.statTotalLabelText.setReference(LanguageBundle.getString("in_sumStatTotalLabel"));
            this.statTotalText.setReference(LanguageBundle.getFormattedString("in_sumStatTotal", Integer.toString(statTotal)));
            this.modTotalLabelText.setReference(LanguageBundle.getString("in_sumModTotalLabel"));
            this.modTotalText.setReference(LanguageBundle.getFormattedString("in_sumModTotal", Integer.toString(modTotal)));
        }
        if (this.charLevelsFacade.getSize() == 0 && (this.allAbilitiesAreZero() || SettingsHandler.getGame().isPurchaseStatMode() && this.theCharacter.getPointBuyPoints() != this.getUsedStatPool())) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SUMMARY, "Ability Scores", "in_sumTodoStats", 50));
        } else {
            this.todoManager.removeTodo("in_sumTodoStats");
        }
    }

    public boolean canChangePurchasePool() {
        int pcPlayerLevels = this.charDisplay.totalNonMonsterLevels();
        int maxDiddleLevel = this.poolPointText != null ? 0 : 1;
        return pcPlayerLevels <= maxDiddleLevel;
    }

    @Override
    public ReferenceFacade<String> getStatTotalLabelTextRef() {
        return this.statTotalLabelText;
    }

    @Override
    public ReferenceFacade<String> getStatTotalTextRef() {
        return this.statTotalText;
    }

    @Override
    public ReferenceFacade<String> getModTotalLabelTextRef() {
        return this.modTotalLabelText;
    }

    @Override
    public ReferenceFacade<String> getModTotalTextRef() {
        return this.modTotalText;
    }

    @Override
    public ListFacade<TodoFacade> getTodoList() {
        return this.todoManager.getTodoList();
    }

    PlayerCharacter getTheCharacter() {
        return this.theCharacter;
    }

    @Override
    public ReferenceFacade<Integer> getTotalHPRef() {
        return this.hpRef;
    }

    @Override
    public ReferenceFacade<Integer> getRollMethodRef() {
        return this.rollMethodRef;
    }

    @Override
    public void refreshRollMethod() {
        if (!this.canChangePurchasePool()) {
            return;
        }
        GameMode game = (GameMode)this.dataSet.getGameMode();
        this.rollMethodRef.setReference(game.getRollMethod());
        if (SettingsHandler.getGame().isPurchaseStatMode()) {
            int availablePool = RollingMethods.roll(SettingsHandler.getGame().getPurchaseModeMethodPoolFormula());
            this.theCharacter.setPointBuyPoints(availablePool);
            for (StatFacade stat : this.statScoreMap.keySet()) {
                DefaultReferenceFacade<Integer> score = this.statScoreMap.get(stat);
                if (score.getReference() >= SettingsHandler.getGame().getPurchaseScoreMin(this.theCharacter) || !(stat instanceof PCStat)) continue;
                this.setStatToPurchaseNeutral((PCStat)stat, score);
            }
        }
        this.hpRef.setReference(this.theCharacter.hitPoints());
        this.updateScorePurchasePool(false);
    }

    private void setStatToPurchaseNeutral(PCStat pcStat, DefaultReferenceFacade<Integer> scoreRef) {
        int newScore = SettingsHandler.getGame().getPurchaseModeBaseStatScore(this.theCharacter);
        if (StringUtils.isNotEmpty(this.validateNewStatBaseScore(newScore, pcStat, this.charDisplay.totalNonMonsterLevels())) && StringUtils.isNotEmpty(this.validateNewStatBaseScore(newScore = SettingsHandler.getGame().getPurchaseScoreMin(this.theCharacter), pcStat, this.charDisplay.totalNonMonsterLevels()))) {
            return;
        }
        this.theCharacter.setStat(pcStat, newScore);
        scoreRef.setReference(newScore);
    }

    @Override
    public void adjustFunds(BigDecimal modVal) {
        BigDecimal currFunds = this.theCharacter.getGold();
        this.theCharacter.setGold(currFunds.add(modVal));
        this.updateWealthFields();
    }

    @Override
    public void setFunds(BigDecimal newVal) {
        this.theCharacter.setGold(newVal);
        this.updateWealthFields();
    }

    @Override
    public ReferenceFacade<BigDecimal> getFundsRef() {
        return this.fundsRef;
    }

    @Override
    public ReferenceFacade<BigDecimal> getWealthRef() {
        return this.wealthRef;
    }

    @Override
    public ReferenceFacade<GearBuySellFacade> getGearBuySellRef() {
        return this.gearBuySellSchemeRef;
    }

    @Override
    public void setGearBuySellRef(GearBuySellFacade gearBuySell) {
        this.gearBuySellSchemeRef.setReference(gearBuySell);
        GearBuySellScheme scheme = (GearBuySellScheme)gearBuySell;
        int rate = scheme.getBuyRate().intValue();
        SettingsHandler.setGearTab_BuyRate(rate);
        rate = scheme.getSellRate().intValue();
        SettingsHandler.setGearTab_SellRate(rate);
    }

    private void updateWealthFields() {
        this.fundsRef.setReference(this.theCharacter.getGold());
        this.wealthRef.setReference(this.theCharacter.totalValue());
    }

    @Override
    public void setAllowDebt(boolean allowDebt) {
        this.allowDebt = allowDebt;
    }

    @Override
    public boolean isAllowDebt() {
        return this.allowDebt;
    }

    @Override
    public EquipmentListFacade getPurchasedEquipment() {
        return this.purchasedEquip;
    }

    @Override
    public void addPurchasedEquipment(EquipmentFacade equipment, int quantity, boolean customize, boolean free) {
        if (equipment == null || quantity <= 0) {
            return;
        }
        Equipment equipItemToAdjust = (Equipment)equipment;
        if (customize) {
            if ((equipItemToAdjust = this.openCustomizer(equipItemToAdjust)) == null) {
                return;
            }
        } else if (equipItemToAdjust.getSafe(ObjectKey.MOD_CONTROL).getModifiersRequired() && !this.hasBeenAdjusted(equipItemToAdjust)) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_igBuyMustCustomizeItemFirst"));
            return;
        }
        Equipment updatedItem = this.theCharacter.getEquipmentNamed(equipItemToAdjust.getName());
        if (!free && !this.canAfford(equipItemToAdjust, quantity, (GearBuySellScheme)this.gearBuySellSchemeRef.getReference())) {
            this.delegate.showInfoMessage("PCGen", LanguageBundle.getFormattedString("in_igBuyInsufficientFunds", quantity, equipItemToAdjust.getName()));
            return;
        }
        if (updatedItem != null) {
            double prevQty = updatedItem.qty() < 0.0 ? 0.0 : updatedItem.qty();
            double newQty = prevQty + (double)quantity;
            this.theCharacter.updateEquipmentQty(updatedItem, prevQty, newQty);
            Float qty = new Float(newQty);
            updatedItem.setQty(qty);
            this.purchasedEquip.setQuantity(equipment, qty.intValue());
        } else {
            updatedItem = equipItemToAdjust.clone();
            if (updatedItem != null) {
                Float qty = new Float(quantity);
                updatedItem.setQty(qty);
                this.theCharacter.addEquipment(updatedItem);
            }
            this.purchasedEquip.addElement(updatedItem, quantity);
        }
        if (!free) {
            double itemCost = this.calcItemCost(updatedItem, quantity, (GearBuySellScheme)this.gearBuySellSchemeRef.getReference());
            this.theCharacter.adjustGold(itemCost * -1.0);
        }
        this.theCharacter.setCalcEquipmentList();
        this.theCharacter.setDirty(true);
        this.updateWealthFields();
    }

    private boolean hasBeenAdjusted(Equipment equipItemToAdjust) {
        HashSet<EquipmentModifier> allEqMods = new HashSet<EquipmentModifier>(equipItemToAdjust.getEqModifierList(true));
        allEqMods.addAll(equipItemToAdjust.getEqModifierList(false));
        for (EquipmentModifier eqMod : allEqMods) {
            if (eqMod.isType("BaseMaterial")) continue;
            return true;
        }
        return false;
    }

    private boolean canAfford(Equipment selected, double purchaseQty, GearBuySellScheme gearBuySellScheme) {
        float currentFunds = this.theCharacter.getGold().floatValue();
        double itemCost = this.calcItemCost(selected, purchaseQty, gearBuySellScheme);
        return this.allowDebt || itemCost <= (double)currentFunds;
    }

    private double calcItemCost(Equipment selected, double purchaseQty, GearBuySellScheme gearBuySellScheme) {
        BigDecimal rate;
        if (selected == null) {
            return 0.0;
        }
        BigDecimal bigDecimal = rate = purchaseQty >= 0.0 ? gearBuySellScheme.getBuyRate() : gearBuySellScheme.getSellRate();
        if (purchaseQty < 0.0 && selected.isSellAsCash()) {
            rate = gearBuySellScheme.getCashSellRate();
        }
        return purchaseQty * (double)rate.intValue() * (double)0.01f * (double)selected.getCost(this.theCharacter).floatValue();
    }

    private Equipment openCustomizer(Equipment aEq) {
        if (aEq == null) {
            return null;
        }
        Equipment newEquip = aEq.clone();
        if (!newEquip.containsKey(ObjectKey.BASE_ITEM)) {
            newEquip.put(ObjectKey.BASE_ITEM, CDOMDirectSingleRef.getRef(aEq));
        }
        EquipmentBuilderFacadeImpl builder = new EquipmentBuilderFacadeImpl(newEquip, this.theCharacter, this.delegate);
        UIDelegate.CustomEquipResult result = this.delegate.showCustomEquipDialog(this, builder);
        if (newEquip != null && result != UIDelegate.CustomEquipResult.CANCELLED) {
            this.dataSet.addEquipment(newEquip);
        }
        return result == UIDelegate.CustomEquipResult.PURCHASE ? newEquip : null;
    }

    @Override
    public void removePurchasedEquipment(EquipmentFacade equipment, int quantity, boolean free) {
        if (equipment == null || quantity <= 0) {
            return;
        }
        Equipment equipItemToAdjust = (Equipment)equipment;
        Equipment updatedItem = this.theCharacter.getEquipmentNamed(equipItemToAdjust.getName());
        double numRemoved = 0.0;
        if (updatedItem != null) {
            Float qty;
            double prevQty = updatedItem.qty() < 0.0 ? 0.0 : updatedItem.qty();
            double newQty = Math.max(prevQty - (numRemoved = Math.min((double)quantity, prevQty)), 0.0);
            if (newQty <= 0.0) {
                updatedItem.setNumberCarried(new Float(0.0f));
                updatedItem.setLocation(EquipmentLocation.NOT_CARRIED);
                Equipment eqParent = updatedItem.getParent();
                if (eqParent != null) {
                    eqParent.removeChild(this.theCharacter, updatedItem);
                }
                this.theCharacter.removeEquipment(updatedItem);
                this.purchasedEquip.removeElement(updatedItem);
            } else {
                this.theCharacter.updateEquipmentQty(updatedItem, prevQty, newQty);
                qty = new Float(newQty);
                updatedItem.setQty(qty);
                updatedItem.setNumberCarried(qty);
                this.purchasedEquip.setQuantity(equipment, qty.intValue());
            }
            this.theCharacter.updateEquipmentQty(updatedItem, prevQty, newQty);
            qty = new Float(newQty);
            updatedItem.setQty(qty);
            updatedItem.setNumberCarried(qty);
        }
        if (!free) {
            double itemCost = this.calcItemCost(updatedItem, numRemoved * -1.0, (GearBuySellScheme)this.gearBuySellSchemeRef.getReference());
            this.theCharacter.adjustGold(itemCost * -1.0);
        }
        this.theCharacter.setCalcEquipmentList();
        this.theCharacter.setDirty(true);
        this.updateWealthFields();
    }

    @Override
    public void deleteCustomEquipment(EquipmentFacade eqFacade) {
        if (eqFacade == null || !(eqFacade instanceof Equipment)) {
            return;
        }
        Equipment itemToBeDeleted = (Equipment)eqFacade;
        if (!itemToBeDeleted.isType("Custom")) {
            return;
        }
        if (!this.delegate.showWarningConfirm(LanguageBundle.getString("in_igDeleteCustomWarnTitle"), LanguageBundle.getFormattedString("in_igDeleteCustomWarning", itemToBeDeleted))) {
            return;
        }
        this.removePurchasedEquipment(itemToBeDeleted, Integer.MAX_VALUE, false);
        Globals.getContext().getReferenceContext().forget(itemToBeDeleted);
        if (this.dataSet.getEquipment() instanceof DefaultListFacade) {
            ((DefaultListFacade)this.dataSet.getEquipment()).removeElement(itemToBeDeleted);
        }
    }

    @Override
    public boolean isQualifiedFor(EquipmentFacade equipment) {
        Equipment equip = (Equipment)equipment;
        boolean accept = PrereqHandler.passesAll(equip.getPrerequisiteList(), this.theCharacter, equip);
        if (accept && (equip.isShield() || equip.isWeapon() || equip.isArmor())) {
            return this.theCharacter.isProficientWith(equip);
        }
        return accept;
    }

    @Override
    public EquipmentFacade getEquipmentSizedForCharacter(EquipmentFacade equipment) {
        Equipment equip = (Equipment)equipment;
        SizeAdjustment newSize = this.charDisplay.getSizeAdjustment();
        if (equip.getSizeAdjustment() == newSize || !Globals.canResizeHaveEffect(this.theCharacter, equip, null)) {
            return equipment;
        }
        String existingKey = equip.getKeyName();
        String newKey = equip.createKeyForAutoResize(newSize);
        Equipment potential = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, newKey);
        if (newKey.equals(existingKey)) {
            return equipment;
        }
        if (potential != null) {
            return potential;
        }
        String newName = equip.createNameForAutoResize(newSize);
        potential = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, newName);
        if (potential != null) {
            return potential;
        }
        Equipment newEq = equip.clone();
        if (!newEq.containsKey(ObjectKey.BASE_ITEM)) {
            newEq.put(ObjectKey.BASE_ITEM, CDOMDirectSingleRef.getRef(equip));
        }
        newEq.setName(newName);
        newEq.put(StringKey.OUTPUT_NAME, newName);
        newEq.put(StringKey.KEY_NAME, newKey);
        newEq.resizeItem(this.theCharacter, newSize);
        newEq.removeType(Type.AUTO_GEN);
        newEq.removeType(Type.STANDARD);
        if (!newEq.isType("Custom")) {
            newEq.addType(Type.CUSTOM);
        }
        Globals.getContext().getReferenceContext().importObject(newEq);
        return newEq;
    }

    @Override
    public boolean isAutoResize() {
        return this.theCharacter.isAutoResize();
    }

    @Override
    public void setAutoResize(boolean autoResize) {
        this.theCharacter.setAutoResize(autoResize);
    }

    @Override
    public EquipmentSetFacade createEquipmentSet(String setName) {
        String id = EquipmentSetFacadeImpl.getNewIdPath(this.charDisplay, null);
        EquipSet eSet = new EquipSet(id, setName);
        this.theCharacter.addEquipSet(eSet);
        EquipmentSetFacadeImpl facade = new EquipmentSetFacadeImpl(this.delegate, this.theCharacter, eSet, this.dataSet, this.purchasedEquip, this.todoManager, this);
        this.equipmentSets.addElement(facade);
        return facade;
    }

    @Override
    public void deleteEquipmentSet(EquipmentSetFacade set) {
        if (set == null || !(set instanceof EquipmentSetFacadeImpl)) {
            return;
        }
        EquipmentSetFacadeImpl setImpl = (EquipmentSetFacadeImpl)set;
        EquipSet eSet = setImpl.getEquipSet();
        this.theCharacter.delEquipSet(eSet);
        this.equipmentSets.removeElement(set);
    }

    @Override
    public ReferenceFacade<String> getCarriedWeightRef() {
        return this.carriedWeightRef;
    }

    @Override
    public ReferenceFacade<String> getLoadRef() {
        return this.loadRef;
    }

    @Override
    public ReferenceFacade<String> getWeightLimitRef() {
        return this.weightLimitRef;
    }

    @Override
    public void quantityChanged(EquipmentListFacade.EquipmentListEvent e) {
        this.refreshTotalWeight();
    }

    @Override
    public void elementAdded(ListEvent<EquipmentFacade> e) {
        this.refreshTotalWeight();
    }

    @Override
    public void elementRemoved(ListEvent<EquipmentFacade> e) {
        this.refreshTotalWeight();
    }

    @Override
    public void elementsChanged(ListEvent<EquipmentFacade> e) {
        this.refreshTotalWeight();
    }

    @Override
    public void elementModified(ListEvent<EquipmentFacade> e) {
        this.refreshTotalWeight();
    }

    private void refreshTotalWeight() {
        String weight = Globals.getGameModeUnitSet().displayWeightInUnitSet(this.charDisplay.totalWeight().doubleValue());
        this.carriedWeightRef.setReference(weight);
        Load load = this.charDisplay.getLoadType();
        this.loadRef.setReference(CoreUtility.capitalizeFirstLetter(load.toString()));
        Float mult = SettingsHandler.getGame().getLoadInfo().getLoadMultiplier(load.toString());
        double limit = 0.0;
        if (mult != null) {
            limit = this.charDisplay.getLoadToken(load.toString());
        }
        double lowerLimit = 0.0;
        for (Load testLoad : Load.values()) {
            double testLimit = this.charDisplay.getLoadToken(testLoad.toString());
            if (testLoad.compareTo(load) >= 0 || !(testLimit > lowerLimit)) continue;
            lowerLimit = testLimit;
        }
        StringBuilder loadLimit = new StringBuilder(Globals.getGameModeUnitSet().displayWeightInUnitSet(lowerLimit));
        if (limit > 0.0) {
            loadLimit.append(" - ");
            loadLimit.append(Globals.getGameModeUnitSet().displayWeightInUnitSet(limit));
        } else {
            loadLimit.append("+ ");
        }
        loadLimit.append(Globals.getGameModeUnitSet().getWeightUnit());
        this.weightLimitRef.setReference(loadLimit.toString());
    }

    @Override
    public void hitPointsChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
        this.hpRef.setReference(this.theCharacter.hitPoints());
    }

    @Override
    public InfoFactory getInfoFactory() {
        return this.infoFactory;
    }

    @Override
    public boolean isQualifiedFor(InfoFacade infoFacade) {
        Kit kit;
        BigDecimal totalCost;
        if (!(infoFacade instanceof PObject)) {
            return false;
        }
        PObject pObj = (PObject)((Object)infoFacade);
        if (!this.theCharacter.isQualified(pObj)) {
            return false;
        }
        return !(infoFacade instanceof Kit) || (totalCost = (kit = (Kit)infoFacade).getTotalCostToBeCharged(this.theCharacter)) == null || this.theCharacter.getGold().compareTo(totalCost) >= 0;
    }

    @Override
    public boolean isQualifiedFor(DeityFacade deityFacade) {
        if (!(deityFacade instanceof Deity)) {
            return false;
        }
        Deity aDeity = (Deity)deityFacade;
        return PrereqHandler.passesAll(aDeity.getPrerequisiteList(), this.theCharacter, aDeity) && this.theCharacter.isQualified(aDeity);
    }

    @Override
    public boolean isQualifiedFor(DomainFacade domainFacade) {
        if (!(domainFacade instanceof DomainFacadeImpl)) {
            return false;
        }
        DomainFacadeImpl domainFI = (DomainFacadeImpl)domainFacade;
        Domain domain = (Domain)domainFI.getRawObject();
        return PrereqHandler.passesAll(domainFI.getPrerequisiteList(), this.theCharacter, domain) && this.theCharacter.isQualified(domain);
    }

    @Override
    public boolean isQualifiedFor(TempBonusFacade tempBonusFacade) {
        if (!(tempBonusFacade instanceof TempBonusFacadeImpl)) {
            return false;
        }
        TempBonusFacadeImpl tempBonus = (TempBonusFacadeImpl)tempBonusFacade;
        CDOMObject originObj = tempBonus.getOriginObj();
        return this.theCharacter.isQualified(originObj);
    }

    @Override
    public boolean isQualifiedFor(SpellFacade spellFacade, ClassFacade classFacade) {
        if (!(spellFacade instanceof SpellFacadeImplem) || classFacade != null && !(classFacade instanceof PCClass)) {
            return false;
        }
        SpellFacadeImplem spellFI = (SpellFacadeImplem)spellFacade;
        PCClass pcClass = (PCClass)classFacade;
        if (!this.theCharacter.isQualified(spellFI.getSpell())) {
            return false;
        }
        return spellFI.getCharSpell().isSpecialtySpell(this.theCharacter) || !SpellCountCalc.isProhibited(spellFI.getSpell(), pcClass, this.theCharacter);
    }

    @Override
    public boolean isQualifiedFor(EquipmentFacade equipFacade, EquipModFacade eqModFacade) {
        if (!(equipFacade instanceof Equipment) || !(eqModFacade instanceof EquipmentModifier)) {
            return false;
        }
        Equipment equip = (Equipment)equipFacade;
        EquipmentModifier eqMod = (EquipmentModifier)eqModFacade;
        return equip.canAddModifier(eqMod, true);
    }

    @Override
    public void addTemplate(TemplateFacade templateFacade) {
        if (templateFacade == null || !(templateFacade instanceof PCTemplate)) {
            return;
        }
        PCTemplate template = (PCTemplate)templateFacade;
        if (!PrereqHandler.passesAll(template.getPrerequisiteList(), this.theCharacter, template)) {
            return;
        }
        if (!this.charDisplay.hasTemplate(template)) {
            Logging.log(Logging.INFO, this.charDisplay.getName() + ": Adding template " + template);
            int oldLevel = this.charLevelsFacade.getSize();
            if (this.theCharacter.addTemplate(template)) {
                Logging.log(Logging.INFO, this.charDisplay.getName() + ": Successful add of template " + template);
                this.templates.addElement(template);
                this.refreshRaceRelatedFields();
                if (oldLevel != this.charLevelsFacade.getSize()) {
                    this.delegate.showLevelUpInfo(this, oldLevel);
                }
            } else {
                Logging.log(Logging.INFO, this.charDisplay.getName() + ": Nope: Add template " + template + " failed because no selection was made");
            }
        } else {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_irHaveTemplate"));
        }
    }

    @Override
    public void removeTemplate(TemplateFacade templateFacade) {
        if (templateFacade == null || !(templateFacade instanceof PCTemplate)) {
            return;
        }
        PCTemplate template = (PCTemplate)templateFacade;
        if (this.charDisplay.hasTemplate(template) && template.isRemovable()) {
            this.theCharacter.removeTemplate(template);
            this.theCharacter.calcActiveBonuses();
            this.templates.removeElement(template);
        } else {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_irNotRemovable"));
        }
    }

    private void refreshTemplates() {
        List<PCTemplate> pcTemplates = this.charDisplay.getDisplayVisibleTemplateList();
        for (PCTemplate template : pcTemplates) {
            if (this.templates.containsElement(template)) continue;
            this.templates.addElement(template);
        }
        Iterator<TemplateFacade> iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            PCTemplate pcTemplate = (PCTemplate)iterator.next();
            if (pcTemplates.contains(pcTemplate)) continue;
            iterator.remove();
        }
    }

    @Override
    public ListFacade<TemplateFacade> getTemplates() {
        return this.templates;
    }

    @Override
    public void addCharacterChangeListener(CharacterFacade.CharacterChangeListener listener) {
    }

    @Override
    public void removeCharacterChangeListener(CharacterFacade.CharacterChangeListener listener) {
    }

    @Override
    public SpellSupportFacade getSpellSupport() {
        return this.spellSupportFacade;
    }

    @Override
    public ReferenceFacade<File> getPortraitRef() {
        return this.portrait;
    }

    @Override
    public void setPortrait(File file) {
        this.portrait.setReference(file);
        this.theCharacter.setPortraitPath(file == null ? null : file.getAbsolutePath());
    }

    @Override
    public ReferenceFacade<Rectangle> getThumbnailCropRef() {
        return this.cropRect;
    }

    @Override
    public void setThumbnailCrop(Rectangle rect) {
        this.cropRect.setReference(rect);
        this.theCharacter.setPortraitThumbnailRect(rect);
    }

    @Override
    public boolean isDirty() {
        return this.theCharacter.isDirty();
    }

    @Override
    public CompanionSupportFacade getCompanionSupport() {
        return this.companionSupportFacade;
    }

    @Override
    public String getCompanionType() {
        Follower master = this.charDisplay.getMaster();
        if (master != null) {
            return master.getType().getKeyName();
        }
        return null;
    }

    @Override
    public CharacterStubFacade getMaster() {
        Follower master = this.charDisplay.getMaster();
        if (master == null) {
            return null;
        }
        CompanionNotLoaded stub = new CompanionNotLoaded(master.getName(), new File(master.getFileName()), master.getRace(), master.getType().getKeyName());
        CharacterFacade masterFacade = CharacterManager.getCharacterMatching(stub);
        if (masterFacade != null) {
            return masterFacade;
        }
        return stub;
    }

    @Override
    public DefaultListFacade<KitFacade> getKits() {
        return this.kitList;
    }

    @Override
    public void addKit(KitFacade obj) {
        if (obj == null || !(obj instanceof Kit)) {
            return;
        }
        Kit kit = (Kit)obj;
        if (!this.theCharacter.isQualified(kit)) {
            return;
        }
        Logging.log(Logging.INFO, this.charDisplay.getName() + ": Testing kit " + kit);
        ArrayList<BaseKit> thingsToAdd = new ArrayList<BaseKit>();
        ArrayList<String> warnings = new ArrayList<String>();
        kit.testApplyKit(this.theCharacter, thingsToAdd, warnings);
        if (!this.showKitWarnings(kit, warnings)) {
            return;
        }
        Logging.log(Logging.INFO, this.charDisplay.getName() + ": Adding kit " + kit);
        kit.processKit(this.theCharacter, thingsToAdd);
        this.kitList.addElement(obj);
        this.race.setReference(this.charDisplay.getRace());
        this.refreshRaceRelatedFields();
        this.name.setReference(this.charDisplay.getName());
        this.characterType.setReference(this.charDisplay.getCharacterType());
        this.deity.setReference(this.charDisplay.getDeity());
        this.buildAvailableDomainsList();
        this.refreshStatScores();
    }

    private void refreshEquipment() {
        this.fundsRef.setReference(this.theCharacter.getGold());
        this.wealthRef.setReference(this.theCharacter.totalValue());
        this.purchasedEquip.refresh(this.theCharacter.getEquipmentMasterList());
        this.initEquipSet();
    }

    private boolean showKitWarnings(Kit kit, List<String> warnings) {
        if (warnings.isEmpty()) {
            return true;
        }
        HtmlInfoBuilder warningMsg = new HtmlInfoBuilder();
        warningMsg.append(LanguageBundle.getString("in_kitWarnStart"));
        warningMsg.appendLineBreak();
        warningMsg.append("<UL>");
        for (String string : warnings) {
            warningMsg.appendLineBreak();
            warningMsg.append("<li>");
            warningMsg.append(string);
            warningMsg.append("</li>");
        }
        warningMsg.append("</UL>");
        warningMsg.appendLineBreak();
        warningMsg.append(LanguageBundle.getString("in_kitWarnEnd"));
        return this.delegate.showWarningConfirm(kit.getDisplayName(), warningMsg.toString());
    }

    @Override
    public List<KitFacade> getAvailableKits() {
        ArrayList<KitFacade> kits = new ArrayList<KitFacade>();
        for (KitFacade obj : this.dataSet.getKits()) {
            if (obj == null || !(obj instanceof Kit) || !((Kit)obj).isVisible(this.theCharacter, View.VISIBLE_DISPLAY)) continue;
            kits.add(obj);
        }
        return kits;
    }

    @Override
    public VariableProcessor getVariableProcessor() {
        return this.theCharacter.getVariableProcessor();
    }

    @Override
    public Float getVariable(String variableString, boolean isMax) {
        return this.theCharacter.getVariable(variableString, isMax);
    }

    @Override
    public boolean matchesCharacter(PlayerCharacter pc) {
        return this.theCharacter != null && this.theCharacter.equals(pc);
    }

    @Override
    public void modifyCharges(List<EquipmentFacade> targets) {
        ArrayList<Equipment> chargedEquip = new ArrayList<Equipment>();
        for (EquipmentFacade equipmentFacade : targets) {
            if (!(equipmentFacade instanceof Equipment) || ((Equipment)equipmentFacade).getMaxCharges() <= 0) continue;
            chargedEquip.add((Equipment)equipmentFacade);
        }
        if (chargedEquip.isEmpty()) {
            return;
        }
        for (Equipment equip : chargedEquip) {
            int selectedCharges = this.getSelectedCharges(equip);
            if (selectedCharges < 0) {
                return;
            }
            equip.setRemainingCharges(selectedCharges);
            this.purchasedEquip.modifyElement(equip);
        }
    }

    private int getSelectedCharges(Equipment equip) {
        int charges;
        int minCharges = equip.getMinCharges();
        int maxCharges = equip.getMaxCharges();
        String selectedValue = this.delegate.showInputDialog(equip.toString(), LanguageBundle.getFormattedString("in_igNumCharges", Integer.toString(minCharges), Integer.toString(maxCharges)), Integer.toString(equip.getRemainingCharges()));
        if (selectedValue == null) {
            return -1;
        }
        try {
            charges = Integer.parseInt(selectedValue.trim());
        }
        catch (NumberFormatException e) {
            charges = minCharges - 1;
        }
        if (charges < minCharges || charges > maxCharges) {
            ShowMessageDelegate.showMessageDialog(LanguageBundle.getString("in_igValueOutOfRange"), "PCGen", MessageType.ERROR);
            return this.getSelectedCharges(equip);
        }
        return charges;
    }

    @Override
    public void addNote(List<EquipmentFacade> targets) {
        ArrayList<Equipment> notedEquip = new ArrayList<Equipment>();
        for (EquipmentFacade equipmentFacade : targets) {
            if (!(equipmentFacade instanceof Equipment)) continue;
            notedEquip.add((Equipment)equipmentFacade);
        }
        if (notedEquip.isEmpty()) {
            return;
        }
        for (Equipment equip : notedEquip) {
            String note = this.getNote(equip);
            if (note == null) {
                return;
            }
            equip.setNote(note);
            this.purchasedEquip.modifyElement(equip);
        }
    }

    private String getNote(Equipment equip) {
        return this.delegate.showInputDialog(equip.toString(), LanguageBundle.getFormattedString("in_igEnterNote", new Object[0]), equip.getNote());
    }

    @Override
    public List<CoreViewNodeFacade> getCoreViewTree(CorePerspective pers) {
        List<CoreViewNodeFacade> coreDebugList = CoreUtils.buildCoreDebugList(this.theCharacter, pers);
        return coreDebugList;
    }

    public class AutoEquipListener
    implements DataFacetChangeListener<CharID, QualifiedObject<CDOMReference<Equipment>>> {
        @Override
        public void dataAdded(DataFacetChangeEvent<CharID, QualifiedObject<CDOMReference<Equipment>>> dfce) {
            if (dfce.getCharID() != CharacterFacadeImpl.this.theCharacter.getCharID()) {
                return;
            }
            CharacterFacadeImpl.this.refreshEquipment();
        }

        @Override
        public void dataRemoved(DataFacetChangeEvent<CharID, QualifiedObject<CDOMReference<Equipment>>> dfce) {
            if (dfce.getCharID() != CharacterFacadeImpl.this.theCharacter.getCharID()) {
                return;
            }
            CharacterFacadeImpl.this.refreshEquipment();
        }
    }

    public class XPListener
    implements DataFacetChangeListener<CharID, Integer> {
        @Override
        public void dataAdded(DataFacetChangeEvent<CharID, Integer> dfce) {
            if (dfce.getCharID() != CharacterFacadeImpl.this.theCharacter.getCharID()) {
                return;
            }
            CharacterFacadeImpl.this.checkForNewLevel();
        }

        @Override
        public void dataRemoved(DataFacetChangeEvent<CharID, Integer> dfce) {
        }
    }

    public class TemplateListener
    implements DataFacetChangeListener<CharID, PCTemplate> {
        @Override
        public void dataAdded(DataFacetChangeEvent<CharID, PCTemplate> dfce) {
            if (dfce.getCharID() != CharacterFacadeImpl.this.theCharacter.getCharID()) {
                return;
            }
            CharacterFacadeImpl.this.refreshTemplates();
        }

        @Override
        public void dataRemoved(DataFacetChangeEvent<CharID, PCTemplate> dfce) {
            if (dfce.getCharID() != CharacterFacadeImpl.this.theCharacter.getCharID()) {
                return;
            }
            CharacterFacadeImpl.this.refreshTemplates();
        }
    }

    public class LanguageListener
    implements DataFacetChangeListener<CharID, Language> {
        @Override
        public void dataAdded(DataFacetChangeEvent<CharID, Language> dfce) {
            if (dfce.getCharID() != CharacterFacadeImpl.this.theCharacter.getCharID()) {
                return;
            }
            CharacterFacadeImpl.this.refreshLanguageList();
        }

        @Override
        public void dataRemoved(DataFacetChangeEvent<CharID, Language> dfce) {
            if (dfce.getCharID() != CharacterFacadeImpl.this.theCharacter.getCharID()) {
                return;
            }
            CharacterFacadeImpl.this.refreshLanguageList();
        }
    }

    private static class RectangleReference
    extends DefaultReferenceFacade<Rectangle> {
        public RectangleReference(Rectangle rect) {
            super(rect == null ? null : (Rectangle)rect.clone());
        }

        @Override
        public Rectangle getReference() {
            Rectangle rect = (Rectangle)super.getReference();
            if (rect != null) {
                rect = (Rectangle)rect.clone();
            }
            return rect;
        }

        @Override
        public void setReference(Rectangle rect) {
            Rectangle old = this.getReference();
            if (ObjectUtils.equals(old, rect)) {
                return;
            }
            if (rect != null) {
                rect = (Rectangle)rect.clone();
            }
            this.object = rect;
            if (rect != null) {
                rect = (Rectangle)rect.clone();
            }
            this.fireReferenceChangedEvent(this, old, rect);
        }
    }
}

