/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.core.FollowerOption;

public class FollowerOptionFacet
extends AbstractStorageFacet<CharID>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<FollowerOption> lists = cdo.getListFor(ListKey.COMPANIONLIST);
        if (lists != null) {
            this.addAll(dfce.getCharID(), lists, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    private void addAll(CharID id, List<FollowerOption> list, CDOMObject cdo) {
        for (FollowerOption fo : list) {
            this.add(id, fo, cdo);
        }
    }

    private void add(CharID id, FollowerOption fo, CDOMObject cdo) {
        if (fo == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        String name = fo.getListRef().getName();
        Map<FollowerOption, Set<CDOMObject>> foMap = this.getConstructingCachedMap(id, name);
        WrappedMapSet set = foMap.get(fo);
        if (set == null) {
            set = new WrappedMapSet(IdentityHashMap.class);
            foMap.put(fo, (Set<CDOMObject>)set);
        }
        set.add((CDOMObject)cdo);
    }

    private void removeAll(CharID id, CDOMObject source) {
        CaseInsensitiveMap<Map<FollowerOption, Set<CDOMObject>>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            Iterator it = componentMap.values().iterator();
            while (it.hasNext()) {
                Map foMap = (Map)it.next();
                Iterator it2 = foMap.values().iterator();
                while (it2.hasNext()) {
                    Set set = (Set)it2.next();
                    if (!set.remove(source) || !set.isEmpty()) continue;
                    it2.remove();
                }
                if (!foMap.isEmpty()) continue;
                it.remove();
            }
        }
    }

    private CaseInsensitiveMap<Map<FollowerOption, Set<CDOMObject>>> getCachedMap(CharID id) {
        return (CaseInsensitiveMap)this.getCache(id);
    }

    private Map<FollowerOption, Set<CDOMObject>> getConstructingCachedMap(CharID id, String name) {
        IdentityHashMap foMap;
        CaseInsensitiveMap componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = new CaseInsensitiveMap();
            this.setCache(id, componentMap);
        }
        if ((foMap = (IdentityHashMap)componentMap.get((Object)name)) == null) {
            foMap = new IdentityHashMap();
            componentMap.put((Object)name, foMap);
        }
        return foMap;
    }

    public Map<FollowerOption, CDOMObject> getAvailableFollowers(CharID id, String type, Comparator<FollowerOption> comp) {
        CaseInsensitiveMap<Map<FollowerOption, Set<CDOMObject>>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        Map foMap = (Map)componentMap.get((Object)type);
        if (foMap == null) {
            return Collections.emptyMap();
        }
        TreeMap<FollowerOption, CDOMObject> ret = new TreeMap<FollowerOption, CDOMObject>(comp);
        for (Map.Entry me : foMap.entrySet()) {
            FollowerOption fo = (FollowerOption)me.getKey();
            Set target = (Set)me.getValue();
            Collection<FollowerOption> expanded = fo.getExpandedOptions();
            for (CDOMObject source : target) {
                for (FollowerOption efo : expanded) {
                    ret.put(efo, source);
                }
            }
        }
        return ret;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        CaseInsensitiveMap<Map<FollowerOption, Set<CDOMObject>>> map = this.getCachedMap(source);
        if (map != null) {
            for (Map fm : map.values()) {
                for (Map.Entry fme : fm.entrySet()) {
                    FollowerOption fl = (FollowerOption)fme.getKey();
                    for (CDOMObject cdo : (Set)fme.getValue()) {
                        this.add(copy, fl, cdo);
                    }
                }
            }
        }
    }

    public int getCount(CharID id) {
        CaseInsensitiveMap<Map<FollowerOption, Set<CDOMObject>>> map = this.getCachedMap(id);
        int count = 0;
        if (map != null) {
            for (Map fm : map.values()) {
                count += fm.size();
            }
        }
        return count;
    }
}

