/*
 * Decompiled with CFR 0.152.
 */
package plugin.converter;

import java.util.Collection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.inst.ObjectCache;
import pcgen.gui2.converter.ConversionDecider;
import pcgen.gui2.converter.TokenConverter;
import pcgen.gui2.converter.event.TokenProcessEvent;
import pcgen.gui2.converter.event.TokenProcessorPlugin;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.EditorLoadContext;
import pcgen.util.Logging;

public class BonusConvertPlugin
implements TokenProcessorPlugin {
    private static int bonusCount = 1;

    public String process(TokenProcessEvent tpe) {
        String value = tpe.getValue();
        StringBuilder result = new StringBuilder(value.length() + 10);
        String objectName = tpe.getObjectName();
        while (true) {
            int pipeLoc = value.lastIndexOf(124);
            String preString = value.substring(pipeLoc + 1);
            if (pipeLoc == -1 || !preString.startsWith("PRE") && !preString.startsWith("!PRE") || preString.startsWith("PREAPPLY")) break;
            String pre = this.process(tpe.getContext(), tpe.getDecider(), objectName, preString);
            result.insert(0, pre);
            result.insert(0, '|');
            value = value.substring(0, pipeLoc);
        }
        return this.processBonus(tpe, tpe.getKey(), value + result);
    }

    private String process(EditorLoadContext context, ConversionDecider decider, String objectName, String token) {
        int colonLoc = token.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint((String)("Invalid Token - does not contain a colon: " + token));
            return null;
        }
        if (colonLoc == 0) {
            Logging.errorPrint((String)("Invalid Token - starts with a colon: " + token));
            return null;
        }
        String key = token.substring(0, colonLoc);
        String value = colonLoc == token.length() - 1 ? null : token.substring(colonLoc + 1);
        ObjectCache cdo = new ObjectCache();
        cdo.setName("BONUS" + bonusCount++);
        TokenProcessEvent tpe = new TokenProcessEvent(context, decider, key, value, objectName, (CDOMObject)cdo);
        String error = TokenConverter.process((TokenProcessEvent)tpe);
        context.purge((CDOMObject)cdo);
        TokenConverter.clearConstants();
        if (tpe.isConsumed()) {
            return tpe.getResult();
        }
        Logging.errorPrint((String)error);
        return null;
    }

    private String processBonus(TokenProcessEvent tpe, String key, String value) {
        try {
            EditorLoadContext context = tpe.getContext();
            CDOMObject obj = tpe.getPrimary();
            if (context.processToken((Loadable)obj, key, value)) {
                context.commit();
            } else {
                context.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
            Collection output = context.unparse((Object)obj);
            if (output == null || output.isEmpty()) {
                return "Unable to unparse: " + key + ":" + value;
            }
            boolean needTab = false;
            for (String s : output) {
                if (needTab) {
                    tpe.append('\t');
                }
                needTab = true;
                tpe.append((CharSequence)s);
            }
            tpe.consume();
        }
        catch (PersistenceLayerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Class<? extends CDOMObject> getProcessedClass() {
        return CDOMObject.class;
    }

    public String getProcessedToken() {
        return "BONUS";
    }
}

