/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pcgen.base.util.IdentityList;
import pcgen.base.util.ListSet;

public class KeyMap<V> {
    private final Map<String, V> forwardMap = new TreeMap<String, V>(String.CASE_INSENSITIVE_ORDER);
    private final Map<V, String> reverseMap = new IdentityHashMap<V, String>();
    private final List<V> inputOrder = new IdentityList<V>();

    public void clear() {
        this.forwardMap.clear();
        this.reverseMap.clear();
        this.inputOrder.clear();
    }

    public boolean containsKey(Object key) {
        return this.forwardMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.reverseMap.containsKey(value);
    }

    public V get(Object key) {
        return this.forwardMap.get(key);
    }

    public String getKeyFor(Object key) {
        return this.reverseMap.get(key);
    }

    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.forwardMap.keySet());
    }

    public V put(String key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Key may not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        String oldKey = this.reverseMap.get(value);
        V oldValue = this.forwardMap.get(key);
        if (oldKey != null) {
            this.forwardMap.remove(oldKey);
        }
        this.reverseMap.remove(oldValue);
        this.inputOrder.remove(oldValue);
        this.inputOrder.add(value);
        this.forwardMap.put(key, value);
        this.reverseMap.put((String)value, key);
        return oldValue;
    }

    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        V value = this.forwardMap.remove(key);
        this.inputOrder.remove(value);
        this.reverseMap.remove(value);
        return value;
    }

    public int size() {
        return this.forwardMap.size();
    }

    public Collection<V> keySortedValues() {
        return new ListSet<V>(this.forwardMap.values());
    }

    public List<V> insertOrderValues() {
        return new IdentityList<V>(this.inputOrder);
    }

    public String toString() {
        return "KeyMap: " + this.forwardMap.toString();
    }

    public V getItemInOrder(int index) {
        return this.inputOrder.get(index);
    }
}

