/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import org.junit.runner.Description;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

public class JUnitDescriptionGenerator {
    private final SpecInfo spec;

    public JUnitDescriptionGenerator(SpecInfo spec) {
        this.spec = spec;
    }

    public void describeSpecMethods() {
        Description desc = Description.createSuiteDescription((Class)((Class)this.spec.getReflection()));
        this.spec.setDescription(desc);
        for (FeatureInfo feature : this.spec.getAllFeatures()) {
            this.describeFeature(feature);
        }
        for (MethodInfo fixtureMethod : this.spec.getAllFixtureMethods()) {
            this.describeMethod(fixtureMethod);
        }
    }

    public void describeSpec() {
        Description desc = Description.createSuiteDescription((Class)((Class)this.spec.getReflection()));
        this.spec.setDescription(desc);
        if (this.spec.isExcluded() || this.spec.isSkipped()) {
            return;
        }
        for (FeatureInfo feature : this.spec.getAllFeaturesInExecutionOrder()) {
            if (feature.isExcluded() || feature.isReportIterations()) continue;
            desc.addChild(feature.getFeatureMethod().getDescription());
        }
    }

    private void describeFeature(FeatureInfo feature) {
        Description desc = this.describeMethod(feature.getFeatureMethod());
        feature.setDescription(desc);
        if (feature.getDataProcessorMethod() != null) {
            feature.getDataProcessorMethod().setDescription(desc);
        }
        for (DataProviderInfo prov : feature.getDataProviders()) {
            prov.getDataProviderMethod().setDescription(desc);
        }
    }

    private Description describeMethod(MethodInfo method) {
        Annotation[] anns = method.getReflection() == null ? new Annotation[]{} : method.getAnnotations();
        Description desc = Description.createTestDescription((Class)((Class)this.spec.getReflection()), (String)method.getName(), (Annotation[])anns);
        method.setDescription(desc);
        return desc;
    }
}

