/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.report;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jrm.misc.HTMLRenderer;
import jrm.profile.report.ContainerTZip;
import jrm.profile.report.ContainerUnknown;
import jrm.profile.report.ContainerUnneeded;
import jrm.profile.report.EntryAdd;
import jrm.profile.report.EntryMissing;
import jrm.profile.report.EntryMissingDuplicate;
import jrm.profile.report.EntryOK;
import jrm.profile.report.EntryUnneeded;
import jrm.profile.report.EntryWrongHash;
import jrm.profile.report.EntryWrongName;
import jrm.profile.report.RomSuspiciousCRC;
import jrm.profile.report.SubjectSet;
import jrm.ui.profile.report.ReportFrame;

public class ReportTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, ((HTMLRenderer)value).getHTML(), sel, expanded, leaf, row, hasFocus);
        if (value instanceof RomSuspiciousCRC) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/information.png")));
        } else if (value instanceof ContainerUnknown) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/error.png")));
        } else if (value instanceof ContainerUnneeded) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/error.png")));
        } else if (value instanceof ContainerTZip) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/compress.png")));
        } else if (value instanceof EntryOK) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/bullet_green.png")));
        } else if (value instanceof EntryAdd) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/bullet_blue.png")));
        } else if (value instanceof EntryMissingDuplicate) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/bullet_purple.png")));
        } else if (value instanceof EntryMissing) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/bullet_red.png")));
        } else if (value instanceof EntryUnneeded) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/bullet_black.png")));
        } else if (value instanceof EntryWrongHash) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/bullet_orange.png")));
        } else if (value instanceof EntryWrongName) {
            this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/bullet_pink.png")));
        } else if (!leaf) {
            String icon = "/jrm/resources/folder";
            icon = expanded ? icon + "_open" : icon + "_closed";
            if (value instanceof SubjectSet) {
                switch (((SubjectSet)value).getStatus()) {
                    case FOUND: {
                        if (((SubjectSet)value).hasNotes()) {
                            if (((SubjectSet)value).isFixable()) {
                                icon = icon + "_purple";
                                break;
                            }
                            icon = icon + "_orange";
                            break;
                        }
                        icon = icon + "_green";
                        break;
                    }
                    case CREATE: 
                    case CREATEFULL: {
                        if (((SubjectSet)value).isFixable()) {
                            icon = icon + "_blue";
                            break;
                        }
                        icon = icon + "_orange";
                        break;
                    }
                    case MISSING: {
                        icon = icon + "_red";
                        break;
                    }
                    case UNNEEDED: {
                        icon = icon + "_gray";
                        break;
                    }
                }
            }
            icon = icon + ".png";
            this.setIcon(new ImageIcon(ReportFrame.class.getResource(icon)));
        } else if (value instanceof SubjectSet) {
            switch (((SubjectSet)value).getStatus()) {
                case FOUND: {
                    this.setIcon(new ImageIcon(ReportFrame.class.getResource("/jrm/resources/icons/bullet_green.png")));
                    break;
                }
            }
        }
        return this;
    }
}

