/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.rundeck.client.RundeckClient;
import org.rundeck.client.api.RequestFailed;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.DateInfo;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.JobItem;
import org.rundeck.client.api.model.scheduler.ScheduledJobItem;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.RdApp;
import org.rundeck.client.tool.RdBuilder;
import org.rundeck.client.tool.commands.Adhoc;
import org.rundeck.client.tool.commands.Executions;
import org.rundeck.client.tool.commands.Jobs;
import org.rundeck.client.tool.commands.Keys;
import org.rundeck.client.tool.commands.Metrics;
import org.rundeck.client.tool.commands.Nodes;
import org.rundeck.client.tool.commands.Projects;
import org.rundeck.client.tool.commands.RDSystem;
import org.rundeck.client.tool.commands.RdToolImpl;
import org.rundeck.client.tool.commands.Retry;
import org.rundeck.client.tool.commands.Run;
import org.rundeck.client.tool.commands.Scheduler;
import org.rundeck.client.tool.commands.Tokens;
import org.rundeck.client.tool.commands.Users;
import org.rundeck.client.tool.commands.Version;
import org.rundeck.client.tool.extension.RdCommandExtension;
import org.rundeck.client.tool.extension.RdTool;
import org.rundeck.client.tool.format.Formatable;
import org.rundeck.client.tool.format.FormattedOutput;
import org.rundeck.client.tool.format.JsonFormatter;
import org.rundeck.client.tool.format.NiceFormatter;
import org.rundeck.client.tool.format.PrefixFormatter;
import org.rundeck.client.tool.format.YamlFormatter;
import org.rundeck.client.tool.output.SystemOutput;
import org.rundeck.client.tool.util.ExtensionLoaderUtil;
import org.rundeck.client.tool.util.Resources;
import org.rundeck.client.util.Client;
import org.rundeck.client.util.ConfigBase;
import org.rundeck.client.util.ConfigSource;
import org.rundeck.client.util.ConfigValues;
import org.rundeck.client.util.DataOutput;
import org.rundeck.client.util.Env;
import org.rundeck.client.util.MultiConfigValues;
import org.rundeck.client.util.RdClientConfig;
import org.rundeck.client.util.ServiceClient;
import org.rundeck.client.util.SysProps;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import picocli.CommandLine;

@CommandLine.Command(name="rd", version={"2.0.8"}, mixinStandardHelpOptions=true, subcommands={Adhoc.class, Jobs.class, Projects.class, Executions.class, Run.class, Keys.class, RDSystem.class, Scheduler.class, Tokens.class, Nodes.class, Users.class, Something.class, Retry.class, Metrics.class, Version.class})
public class Main {
    public static final String RD_USER = "RD_USER";
    public static final String RD_PASSWORD = "RD_PASSWORD";
    public static final String RD_TOKEN = "RD_TOKEN";
    public static final String RD_URL = "RD_URL";
    public static final String RD_API_VERSION = "RD_API_VERSION";
    public static final String RD_AUTH_PROMPT = "RD_AUTH_PROMPT";
    public static final String RD_DEBUG = "RD_DEBUG";
    public static final String RD_FORMAT = "RD_FORMAT";
    public static final String RD_EXT_DISABLED = "RD_EXT_DISABLED";
    public static final String RD_EXT_DIR = "RD_EXT_DIR";
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    public static final String USER_AGENT = RundeckClient.Builder.getUserAgent("rd-cli-tool/2.0.8");
    private static final Function<Object, Optional<Formatable>> DataOutputAsFormatable = o -> {
        if (o instanceof DataOutput) {
            return Optional.of(new Formatable(){

                @Override
                public List<?> asList() {
                    return ((DataOutput)o).asList();
                }

                @Override
                public Map<?, ?> asMap() {
                    return ((DataOutput)o).asMap();
                }
            });
        }
        return Optional.empty();
    };

    public static void main(String[] args2) {
        int result = -1;
        try (Rd rd = Main.createRd();){
            RdToolImpl rd1 = new RdToolImpl(rd);
            CommandLine commandLine = new CommandLine(new Main(), new CmdFactory(rd1));
            CommandLine.Help.ColorScheme colorScheme = new CommandLine.Help.ColorScheme.Builder(CommandLine.Help.defaultColorScheme(CommandLine.Help.Ansi.AUTO)).commands(CommandLine.Help.Ansi.Style.fg_white).applySystemProperties().build();
            commandLine.setColorScheme(colorScheme);
            commandLine.setExpandAtFiles(false);
            commandLine.setUsageHelpAutoWidth(true);
            commandLine.setHelpFactory(new CommandLine.IHelpFactory(){

                @Override
                public CommandLine.Help create(CommandLine.Model.CommandSpec commandSpec, CommandLine.Help.ColorScheme colorScheme) {
                    return new CommandLine.Help(commandSpec, colorScheme){

                        @Override
                        public Map<String, CommandLine.Help> subcommands() {
                            return new TreeMap<String, CommandLine.Help>(super.subcommands());
                        }

                        @Override
                        public String commandListHeading(Object ... params) {
                            return "\nAvailable commands:\n\n";
                        }
                    };
                }
            });
            commandLine.getHelpSectionMap().put("headerHeading", help -> Main.loadBanner("rd-banner.txt", Collections.singletonMap("$version$", "2.0.8")));
            commandLine.setExecutionExceptionHandler((ex, cl, parseResult) -> {
                if (ex instanceof InputError) {
                    return cl.getParameterExceptionHandler().handleParseException(new CommandLine.ParameterException(cl, ex.getMessage(), ex), args2);
                }
                if (ex instanceof RequestFailed) {
                    rd.getOutput().error(ex.getMessage());
                    if (rd.getDebugLevel() > 0) {
                        StringWriter sb = new StringWriter();
                        ex.printStackTrace(new PrintWriter(sb));
                        rd.getOutput().error(sb.toString());
                    }
                    return 2;
                }
                throw ex;
            });
            Main.loadCommands(rd, rd1).forEach(commandLine::addSubcommand);
            result = commandLine.execute(args2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(result);
    }

    @NotNull
    private static Rd createRd() {
        ConfigSource config = Main.buildConfig();
        Main.loadExtensionJars(config);
        RdBuilder builder = new RdBuilder();
        Rd rd = new Rd(config);
        Main.setup(rd, builder);
        return rd;
    }

    static String loadBanner(String resource, Map<String, String> replacements) {
        InputStream resourceAsStream = Main.class.getClassLoader().getResourceAsStream(resource);
        if (null != resourceAsStream) {
            try {
                String result;
                try (BufferedReader is = new BufferedReader(new InputStreamReader(resourceAsStream));){
                    result = is.lines().collect(Collectors.joining("\n"));
                }
                if (replacements != null && !replacements.isEmpty()) {
                    for (String s : replacements.keySet()) {
                        String val = replacements.get(s);
                        result = result.replaceAll(Pattern.quote(s), Matcher.quoteReplacement(val));
                    }
                }
                return CommandLine.Help.Ansi.AUTO.string(result);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static ConfigSource buildConfig() {
        return new ConfigBase(new MultiConfigValues(new Env(), new SysProps()));
    }

    private static void loadExtensionJars(ConfigSource config) {
        if (config.getBool(RD_EXT_DISABLED, false)) {
            return;
        }
        String rd_ext_dir = config.get(RD_EXT_DIR);
        if (null == rd_ext_dir) {
            return;
        }
        File extDir = new File(rd_ext_dir);
        if (!extDir.isDirectory()) {
            return;
        }
        File[] jars = extDir.listFiles(f -> f.getName().endsWith(".jar"));
        if (jars == null) {
            return;
        }
        URLClassLoader urlClassLoader = Main.buildClassLoader(jars);
        Thread.currentThread().setContextClassLoader(urlClassLoader);
    }

    private static URLClassLoader buildClassLoader(File[] jars) {
        ClassLoader parent = Main.class.getClassLoader();
        ArrayList<URL> urls2 = new ArrayList<URL>();
        try {
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                urls2.add(url);
            }
            return URLClassLoader.newInstance(urls2.toArray(new URL[0]), parent);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error creating classloader for urls: " + urls2, e);
        }
    }

    private static void setupFormat(RdBuilder belt, RdClientConfig config) {
        String format = config.get(RD_FORMAT);
        if ("yaml".equalsIgnoreCase(format)) {
            Main.configYamlFormat(belt, config);
        } else if ("json".equalsIgnoreCase(format)) {
            Main.configJsonFormat(belt);
        } else {
            if (null != format) {
                belt.finalOutput().warning(String.format("# WARNING: Unknown value for %s: %s", RD_FORMAT, format));
            }
            Main.configNiceFormat(belt);
        }
    }

    private static void configNiceFormat(RdBuilder belt) {
        NiceFormatter formatter = new NiceFormatter(null){

            @Override
            public String format(Object o) {
                if (o instanceof DataOutput) {
                    DataOutput o1 = (DataOutput)o;
                    Map<?, ?> map = o1.asMap();
                    if (null != map) {
                        return super.format(map);
                    }
                    List<?> objects = o1.asList();
                    if (null != objects) {
                        return super.format(objects);
                    }
                }
                return super.format(o);
            }
        };
        formatter.setCollectionIndicator("");
        belt.formatter(formatter);
        belt.channels().info(new FormattedOutput(belt.defaultOutput(), new PrefixFormatter("# ", belt.defaultBaseFormatter())));
    }

    private static void configJsonFormat(RdBuilder belt) {
        belt.formatter(new JsonFormatter(DataOutputAsFormatable));
        belt.channels().infoEnabled(false);
        belt.channels().warningEnabled(false);
        belt.channels().errorEnabled(false);
    }

    private static void configYamlFormat(RdBuilder belt, RdClientConfig config) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle("BLOCK".equalsIgnoreCase(config.getString("RD_YAML_FLOW", "BLOCK")) ? DumperOptions.FlowStyle.BLOCK : DumperOptions.FlowStyle.FLOW);
        dumperOptions.setPrettyFlow(config.getBool("RD_YAML_PRETTY", true));
        Representer representer = new Representer(dumperOptions);
        representer.addClassTag(JobItem.class, Tag.MAP);
        representer.addClassTag(ScheduledJobItem.class, Tag.MAP);
        representer.addClassTag(DateInfo.class, Tag.MAP);
        representer.addClassTag(Execution.class, Tag.MAP);
        belt.formatter(new YamlFormatter(DataOutputAsFormatable, new Yaml(representer, dumperOptions)));
        belt.channels().infoEnabled(false);
        belt.channels().warningEnabled(false);
        belt.channels().errorEnabled(false);
    }

    static List<RdCommandExtension> loadCommands(Rd rd, RdToolImpl commandTool) {
        List<RdCommandExtension> extensions = ExtensionLoaderUtil.list();
        extensions.forEach(commandTool::initExtension);
        if (rd.getDebugLevel() > 0) {
            extensions.forEach(ext -> rd.getOutput().warning("# Including extension: " + ext.getClass().getName()));
        }
        return extensions;
    }

    public static void setup(Rd rd, RdBuilder builder) {
        builder.printStackTrace(rd.getDebugLevel() > 0);
        Main.setupFormat(builder, rd);
        boolean insecureSsl = rd.getBool("RD_INSECURE_SSL", false);
        boolean insecureSslNoWarn = rd.getBool("RD_INSECURE_SSL_NO_WARN", false);
        rd.setOutput(builder.finalOutput());
        if (insecureSsl && !insecureSslNoWarn) {
            rd.getOutput().warning("# WARNING: RD_INSECURE_SSL=true, no hostname or certificate trust verification will be performed");
        }
    }

    public static Client<RundeckApi> createClient(Rd config) throws ConfigSource.ConfigSourceError {
        return Main.createClient(config, RundeckApi.class, null);
    }

    public static <T> Client<T> createClient(Rd config, Class<T> api) throws ConfigSource.ConfigSourceError {
        return Main.createClient(config, api, null);
    }

    public static Client<RundeckApi> createClient(Rd config, Integer requestedVersion) throws ConfigSource.ConfigSourceError {
        return Main.createClient(config, RundeckApi.class, requestedVersion);
    }

    public static <T> Client<T> createClient(Rd config, Class<T> api, Integer requestedVersion) throws ConfigSource.ConfigSourceError {
        Auth auth = new Auth(){};
        auth = auth.chain(new ConfigAuth(config));
        String baseUrl = config.require(RD_URL, "Please specify the Rundeck base URL, e.g. http://host:port or http://host:port/api/14");
        if (!auth.isConfigured() && config.getBool(RD_AUTH_PROMPT, true) && null != System.console()) {
            auth = auth.chain(new ConsoleAuth(String.format("Credentials for URL: %s", baseUrl)).memoize());
        }
        RundeckClient.Builder<T> builder = RundeckClient.builder(api).baseUrl(baseUrl).config(config);
        if (null != requestedVersion) {
            builder.apiVersion(requestedVersion);
        } else {
            int anInt = config.getInt(RD_API_VERSION, -1);
            if (anInt > 0) {
                builder.apiVersion(anInt);
            }
        }
        if (auth.isTokenAuth()) {
            builder.tokenAuth(auth.getToken());
        } else {
            if (null == auth.getUsername() || "".equals(auth.getUsername().trim())) {
                throw new IllegalArgumentException("Username or token must be entered, or use environment variable RD_USER or RD_TOKEN");
            }
            if (null == auth.getPassword() || "".equals(auth.getPassword().trim())) {
                throw new IllegalArgumentException("Password must be entered, or use environment variable RD_PASSWORD");
            }
            builder.passwordAuth(auth.getUsername(), auth.getPassword());
        }
        builder.logger(new OutputLogger(config.getOutput()));
        builder.userAgent("rd-cli-tool/2.0.8");
        return builder.build();
    }

    private static class OutputLogger
    implements Client.Logger {
        final CommandOutput output;

        public OutputLogger(CommandOutput output) {
            this.output = output;
        }

        @Override
        public void output(String out) {
            this.output.output(out);
        }

        @Override
        public void warning(String warn) {
            this.output.warning(warn);
        }

        @Override
        public void error(String err) {
            this.output.error(err);
        }
    }

    @CommandLine.Command(name="pond", hidden=true)
    public static class Something
    implements Runnable {
        @Override
        public void run() {
            String kind;
            int i = new Random().nextInt(4);
            switch (i) {
                case 1: {
                    kind = CommandLine.Help.Ansi.AUTO.string("@|blue A little luck.|@");
                    break;
                }
                case 2: {
                    kind = CommandLine.Help.Ansi.AUTO.string("@|green Good luck.|@");
                    break;
                }
                case 3: {
                    kind = CommandLine.Help.Ansi.AUTO.string("@|fg(215) Great luck.|@");
                    break;
                }
                default: {
                    kind = "Big trouble.";
                }
            }
            System.out.println("For your reference, today you will have:");
            System.out.println(kind);
        }
    }

    static class MemoAuth
    implements Auth {
        final Auth auth;
        String username;
        boolean usermemo = false;
        String pass;
        boolean passmemo = false;
        String token;
        boolean tokenmemo = false;

        public MemoAuth(Auth auth) {
            this.auth = auth;
        }

        @Override
        public String getUsername() {
            if (this.usermemo) {
                return this.username;
            }
            this.username = this.auth.getUsername();
            this.usermemo = true;
            return this.username;
        }

        @Override
        public String getPassword() {
            if (this.passmemo) {
                return this.pass;
            }
            this.pass = this.auth.getPassword();
            this.passmemo = true;
            return this.pass;
        }

        @Override
        public String getToken() {
            if (this.tokenmemo) {
                return this.token;
            }
            this.token = this.auth.getToken();
            this.tokenmemo = true;
            return this.token;
        }
    }

    static class ChainAuth
    implements Auth {
        final Collection<Auth> chain;

        public ChainAuth(Collection<Auth> chain) {
            this.chain = chain;
        }

        @Override
        public String getUsername() {
            return this.findFirst(Auth::getUsername);
        }

        private String findFirst(Function<Auth, String> func) {
            for (Auth auth : this.chain) {
                String user = func.apply(auth);
                if (null == user) continue;
                return user;
            }
            return null;
        }

        @Override
        public String getPassword() {
            return this.findFirst(Auth::getPassword);
        }

        @Override
        public String getToken() {
            return this.findFirst(Auth::getToken);
        }
    }

    static class ConsoleAuth
    implements Auth {
        String username;
        String pass;
        String token;
        final String header;
        boolean echoHeader;

        public ConsoleAuth(String header) {
            this.header = header;
            this.echoHeader = false;
        }

        @Override
        public String getUsername() {
            this.echo();
            return System.console().readLine("Enter username (blank for token auth): ", new Object[0]);
        }

        private void echo() {
            if (!this.echoHeader) {
                if (null != this.header) {
                    System.out.println(this.header);
                }
                this.echoHeader = true;
            }
        }

        @Override
        public String getPassword() {
            this.echo();
            char[] chars = System.console().readPassword("Enter password: ", new Object[0]);
            return new String(chars);
        }

        @Override
        public String getToken() {
            this.echo();
            char[] chars = System.console().readPassword("Enter auth token: ", new Object[0]);
            return new String(chars);
        }
    }

    static class ConfigAuth
    implements Auth {
        final ConfigSource config;

        public ConfigAuth(ConfigSource config) {
            this.config = config;
        }

        @Override
        public String getUsername() {
            return this.config.get(Main.RD_USER);
        }

        @Override
        public String getPassword() {
            return this.config.get(Main.RD_PASSWORD);
        }

        @Override
        public String getToken() {
            return this.config.get(Main.RD_TOKEN);
        }
    }

    static interface Auth {
        default public boolean isConfigured() {
            return null != this.getToken() || null != this.getUsername() && null != this.getPassword();
        }

        default public String getUsername() {
            return null;
        }

        default public String getPassword() {
            return null;
        }

        default public String getToken() {
            return null;
        }

        default public boolean isTokenAuth() {
            String username = this.getUsername();
            if (null != username && !"".equals(username.trim())) {
                return false;
            }
            String token = this.getToken();
            return null != token && !"".equals(token);
        }

        default public Auth chain(Auth auth) {
            return new ChainAuth(Arrays.asList(this, auth));
        }

        default public Auth memoize() {
            return new MemoAuth(this);
        }
    }

    static class Rd
    extends ConfigBase
    implements RdApp,
    RdClientConfig,
    Closeable {
        private final Resources resources = new Resources();
        Client<RundeckApi> client;
        private CommandOutput output = new SystemOutput();

        public Rd(ConfigValues src) {
            super(src);
        }

        @Override
        public boolean isAnsiEnabled() {
            String term = this.getString("TERM", null);
            String rdColor = this.getString("RD_COLOR", null);
            String noColor = this.getString("NO_COLOR", null);
            boolean noColorFlag = noColor != null && !noColor.isEmpty();
            boolean autoEnabled = term != null && term.contains("color");
            boolean enabled = "1".equals(rdColor);
            boolean disabled = "0".equals(rdColor) || noColorFlag;
            return enabled || autoEnabled && !disabled;
        }

        @Override
        public int getDebugLevel() {
            return this.getInt(Main.RD_DEBUG, 0);
        }

        @Override
        public String getDateFormat() {
            return this.getString("RD_DATE_FORMAT", "yyyy-MM-dd'T'HH:mm:ssXX");
        }

        public Client<RundeckApi> getClient() throws InputError {
            if (null == this.client) {
                try {
                    this.client = this.resources.add(Main.createClient(this));
                }
                catch (ConfigSource.ConfigSourceError configSourceError) {
                    throw new InputError(configSourceError.getMessage());
                }
            }
            return this.client;
        }

        public Client<RundeckApi> getClient(int version) throws InputError {
            try {
                this.client = this.resources.add(Main.createClient(this, version));
            }
            catch (ConfigSource.ConfigSourceError configSourceError) {
                throw new InputError(configSourceError.getMessage());
            }
            return this.client;
        }

        @Override
        public <T> ServiceClient<T> getClient(Class<T> api, int version) throws InputError {
            try {
                return this.resources.add(Main.createClient(this, api, version));
            }
            catch (ConfigSource.ConfigSourceError configSourceError) {
                throw new InputError(configSourceError.getMessage());
            }
        }

        @Override
        public <T> ServiceClient<T> getClient(Class<T> api) throws InputError {
            try {
                return this.resources.add(Main.createClient(this, api, null));
            }
            catch (ConfigSource.ConfigSourceError configSourceError) {
                throw new InputError(configSourceError.getMessage());
            }
        }

        @Override
        public RdClientConfig getAppConfig() {
            return this;
        }

        @Override
        public void versionDowngradeWarning(int requested, int supported) {
            this.getOutput().warning(String.format("# WARNING: API Version Downgraded: %d -> %d", requested, supported));
            this.getOutput().warning(String.format("# WARNING: To avoid this warning, specify the API version via RD_URL: export RD_URL=%sapi/%s", this.client.getAppBaseUrl(), supported));
            this.getOutput().warning("# WARNING: To disable downgrading: export RD_API_DOWNGRADE=false");
        }

        @Override
        public CommandOutput getOutput() {
            return this.output;
        }

        public void setOutput(CommandOutput output) {
            this.output = output;
        }

        @Override
        public void close() throws IOException {
            this.resources.close();
        }
    }

    static class CmdFactory
    implements CommandLine.IFactory {
        private final RdTool rd;
        private final CommandLine.IFactory defaultFactory;

        public CmdFactory(RdTool rd) {
            this.rd = rd;
            this.defaultFactory = CommandLine.defaultFactory();
        }

        @Override
        public <K> K create(Class<K> cls) throws Exception {
            K k = this.defaultFactory.create(cls);
            if (k instanceof RdCommandExtension) {
                this.rd.initExtension((RdCommandExtension)k);
            }
            return k;
        }
    }
}

