/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeapon;
import megamek.common.weapons.ArtilleryWeaponDirectFireHandler;
import megamek.common.weapons.ArtilleryWeaponDirectHomingHandler;
import megamek.common.weapons.ArtilleryWeaponIndirectFireHandler;
import megamek.common.weapons.ArtilleryWeaponIndirectHomingHandler;
import megamek.common.weapons.AttackHandler;
import megamek.server.Server;

public abstract class ArtilleryWeapon
extends AmmoWeapon {
    private static final long serialVersionUID = -732023379991213890L;

    public ArtilleryWeapon() {
        this.flags |= 0xB000000000008100L;
        this.damage = -5;
        this.atClass = 5;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.getMunitionType() == 0x2000000000L) {
            if (iGame.getPhase() == IGame.Phase.PHASE_FIRING) {
                return new ArtilleryWeaponDirectHomingHandler(toHitData, weaponAttackAction, iGame, server);
            }
            return new ArtilleryWeaponIndirectHomingHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (iGame.getPhase() == IGame.Phase.PHASE_FIRING) {
            return new ArtilleryWeaponDirectFireHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new ArtilleryWeaponIndirectFireHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

