/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColorInterpolator;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.boardview3d.BoardHexModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.TileTextureManager;
import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Player;

class BoardModel
extends BranchGroup {
    static final double HEX_DIAMETER = 30.0;
    static final double HEX_HEIGHT = 6.0;
    static final double HEX_SIDE_LENGTH = Math.tan(0.5235987755982988) * 30.0;
    static final double UNIT_SIZE = 12.0;
    static final double WRECK_HEIGHT = 1.0;
    static final double INFANTRY_HEIGHT = 2.0;
    static final double BATTLEARMOR_HEIGHT = 3.0;
    static final BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY);
    static final Color3f SKY = new Color3f(0.33f, 0.5f, 1.0f);
    static final Color3f LAND = new Color3f(0.66f, 0.66f, 0.5f);
    TileTextureManager tileManager;
    SimpleUniverse universe;
    IGame game;
    boolean isDeploying;
    int w;
    int h;
    Material highlight = new Material(C.white, C.black, C.white, C.black, 1.0f);
    ColorInterpolator highlightEffect = new ColorInterpolator(C.dblAlpha, this.highlight, C.grey75, C.white);
    SharedGroup[] shared;
    static final int KEEP = 2;

    public BoardModel(TileTextureManager tileTextureManager, SimpleUniverse simpleUniverse, IGame iGame) {
        this.tileManager = tileTextureManager;
        this.universe = simpleUniverse;
        this.game = iGame;
        this.shared = BoardHexModel.mkShared();
        this.setCapability(17);
        this.highlight.setCapability(0);
        this.highlight.setCapability(1);
        this.highlightEffect.setSchedulingBounds((Bounds)bounds);
        this.addChild((Node)this.highlightEffect);
        BranchGroup branchGroup = new BranchGroup();
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(SKY, 2));
        appearance.setPolygonAttributes(C.noCull);
        appearance.setTexture((Texture)this.tileManager.getTexture("data/images/misc/clouds.jpg"));
        TransformGroup transformGroup = new TransformGroup(new Transform3D(C.mkquat(1.0, 0.0, 0.0, 1.5707963267948966), new Vector3d(), 1.0));
        transformGroup.addChild((Node)new Sphere(1.0f, 2, 100, appearance));
        branchGroup.addChild((Node)transformGroup);
        Background background = new Background(branchGroup);
        background.setApplicationBounds((Bounds)bounds);
        this.addChild((Node)background);
    }

    static final Point3d getHexLocation(Coords coords, int n) {
        return new Point3d((double)coords.x * HEX_SIDE_LENGTH * 1.5, -((double)coords.y * 30.0 + ((coords.x & 1) != 0 ? 15.0 : 0.0)), (double)n * 6.0);
    }

    private final BoardHexModel hexAt(int n, int n2) {
        return (BoardHexModel)this.getChild(n2 * this.w + n + 2);
    }

    void update(Player player) {
        IBoard iBoard = this.game.getBoard();
        this.detach();
        if (iBoard.getWidth() != this.w || iBoard.getHeight() != this.h) {
            int n;
            System.out.println("BoardModel: full rebuild");
            for (n = this.numChildren() - 1; n >= 2; --n) {
                this.removeChild(n);
            }
            this.w = iBoard.getWidth();
            this.h = iBoard.getHeight();
            for (n = 0; n < this.h; ++n) {
                for (int i = 0; i < this.w; ++i) {
                    Coords coords = new Coords(i, n);
                    BoardHexModel boardHexModel = new BoardHexModel(this.game, coords, iBoard.getHex(coords), this.tileManager, this.shared);
                    this.addChild((Node)boardHexModel);
                }
            }
            DirectionalLight directionalLight = new DirectionalLight(true, new Color3f(0.5f, 0.45f, 0.4f), new Vector3f(-1.0f, 1.0f, -1.0f));
            directionalLight.setInfluencingBounds((Bounds)bounds);
            this.addChild((Node)directionalLight);
            directionalLight = new DirectionalLight(true, new Color3f(0.5f, 0.45f, 0.4f), new Vector3f(-1.0f, -0.5f, -2.0f));
            directionalLight.setInfluencingBounds((Bounds)bounds);
            this.addChild((Node)directionalLight);
            AmbientLight ambientLight = new AmbientLight(new Color3f(0.4f, 0.4f, 0.4f));
            ambientLight.setInfluencingBounds((Bounds)bounds);
            this.addChild((Node)ambientLight);
        } else {
            System.out.println("BoardModel: full update");
        }
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                this.hexAt(j, i).update(iBoard.getHex(j, i), this.tileManager, player);
            }
        }
        if (!this.isDeploying) {
            this.resetBoard();
        }
        this.universe.addBranchGraph((BranchGroup)this);
    }

    void update(Coords coords, IHex iHex, Player player) {
        this.detach();
        this.hexAt(coords.x, coords.y).update(iHex, this.tileManager, player);
        this.universe.addBranchGraph((BranchGroup)this);
    }

    public void showDeployment(Player player) {
        if (player == null) {
            this.isDeploying = false;
            this.resetBoard();
            return;
        }
        this.isDeploying = true;
        IBoard iBoard = this.game.getBoard();
        this.detach();
        Coords coords = new Coords(0, 0);
        coords.y = 0;
        while (coords.y < this.h) {
            coords.x = 0;
            while (coords.x < this.w) {
                if (!iBoard.isLegalDeployment(coords, player)) {
                    this.hexAt(coords.x, coords.y).darken();
                } else {
                    this.hexAt(coords.x, coords.y).setEffect(this.highlight);
                }
                ++coords.x;
            }
            ++coords.y;
        }
        this.universe.addBranchGraph((BranchGroup)this);
    }

    public void resetBoard() {
        boolean bl = GUIPreferences.getInstance().getBoolean("AdvancedDarkenMapAtNight") && this.game.getPlanetaryConditions().getLight() > 0;
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                BoardHexModel boardHexModel = this.hexAt(j, i);
                if (bl && !this.game.isPositionIlluminated((Coords)boardHexModel.getUserData())) {
                    boardHexModel.night();
                    continue;
                }
                boardHexModel.reset();
            }
        }
    }
}

