/*
 * Decompiled with CFR 0.152.
 */
package net.daimonin.client3d.editor.object;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageSetImage {
    private File file;
    private int width;
    private int height;
    private int borderSize;
    private Color borderColor;
    private String name;
    private String state;
    private int posX;
    private int posY;
    private boolean alpha;
    private BufferedImage image;
    public static final char SEPARATOR = '_';

    public ImageSetImage(File aFile) {
        this.file = aFile;
        this.collectImageInfo();
    }

    public static final boolean checkFilenames(List<File> files) {
        boolean correct = true;
        int i = 0;
        while (i < files.size()) {
            File aFile = files.get(i);
            if (aFile.getName().indexOf(95) < 1 || aFile.getName().indexOf(95) != aFile.getName().lastIndexOf(95)) {
                System.err.println("Invalid image name: '" + aFile.getName() + "'. Must be \"<name>_<state>.png\".");
                correct = false;
            }
            ++i;
        }
        return correct;
    }

    private void collectImageInfo() {
        try {
            String fileName = this.file.getName();
            this.name = fileName.substring(0, fileName.indexOf(95)).toLowerCase();
            this.state = fileName.substring(fileName.indexOf(95) + 1, fileName.indexOf(".png")).toLowerCase();
            this.image = ImageIO.read(this.file);
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final int getPosX() {
        return this.posX;
    }

    public final void setPosX(int aPosX) {
        this.posX = aPosX;
    }

    public final int getPosY() {
        return this.posY;
    }

    public final void setPosY(int aPosY) {
        this.posY = aPosY;
    }

    public final int getHeight() {
        return this.height;
    }

    public final String getName() {
        return this.name;
    }

    public final String getState() {
        return this.state;
    }

    public final int getWidth() {
        return this.width;
    }

    public final boolean isAlpha() {
        return this.alpha;
    }

    public final void setAlpha(boolean aAlpha) {
        this.alpha = aAlpha;
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public final String toString() {
        return String.valueOf(this.name) + '_' + this.state + ".png";
    }

    public final int getBorderSize() {
        return this.borderSize;
    }

    public final void setBorderSize(int aBorderSize) {
        this.borderSize = aBorderSize;
    }

    public final Color getBorderColor() {
        return this.borderColor;
    }

    public final void setBorderColor(Color aBorderColor) {
        this.borderColor = aBorderColor;
    }
}

