/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.CompositeTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputsDeprecationSupport;
import org.gradle.api.internal.tasks.TaskPropertyFileCollection;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.tasks.FileNormalizer;

@NonNullApi
public class NonCacheableTaskOutputPropertySpec
extends TaskOutputsDeprecationSupport
implements TaskOutputFilePropertySpec {
    private final CompositeTaskOutputPropertySpec parent;
    private final int index;
    private final FileCollection files;

    public NonCacheableTaskOutputPropertySpec(String taskName, CompositeTaskOutputPropertySpec parent, int index, FileResolver resolver, Object paths) {
        this.parent = parent;
        this.index = index;
        this.files = new TaskPropertyFileCollection(taskName, "output", this, resolver, paths);
    }

    @Override
    public String getPropertyName() {
        return this.parent.getPropertyName() + "$" + this.index;
    }

    public String getOriginalPropertyName() {
        return this.parent.getPropertyName();
    }

    @Override
    public OutputType getOutputType() {
        return this.parent.getOutputType();
    }

    @Override
    public Class<? extends FileNormalizer> getNormalizer() {
        return this.parent.getNormalizer();
    }

    @Override
    public int compareTo(TaskPropertySpec o) {
        return this.getPropertyName().compareTo(o.getPropertyName());
    }

    @Override
    public FileCollection getPropertyFiles() {
        return this.files;
    }
}

