/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class SchemaMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private IMarkerResolution[] resolutions = new IMarkerResolution[1];

    public SchemaMarkerResolutionGenerator() {
        this.resolutions[0] = new SchemaMarkerResolution();
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return this.resolutions;
    }

    class SchemaMarkerResolution
    implements IMarkerResolution {
        private ShowDescriptionAction action;

        SchemaMarkerResolution() {
        }

        public String getLabel() {
            return PDEPlugin.getResourceString("SchemaMarkerResolutionGenerator.label");
        }

        public void run(IMarker marker) {
            try {
                String point = (String)marker.getAttribute("point");
                if (point == null) {
                    return;
                }
                ISchema schema = PDECore.getDefault().getSchemaRegistry().getSchema(point);
                if (this.action == null) {
                    this.action = new ShowDescriptionAction(schema);
                } else {
                    this.action.setSchema(schema);
                }
                this.action.run();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }
}

