/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchOperation;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.PrettySignature;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindDeclarationsAction;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.help.WorkbenchHelp;

public class FindDeclarationsInWorkingSetAction
extends FindDeclarationsAction {
    private IWorkingSet[] fWorkingSet;

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site) {
        super(site);
        this.init();
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.find_declarations_in_working_set_action");
    }

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        this(site);
        this.fWorkingSet = workingSets;
    }

    public FindDeclarationsInWorkingSetAction(JavaEditor editor) {
        super(editor);
        this.init();
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.find_declarations_in_working_set_action");
    }

    public FindDeclarationsInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        this(editor);
        this.fWorkingSet = workingSets;
    }

    private void init() {
        this.setText(SearchMessages.getString("Search.FindDeclarationsInWorkingSetAction.label"));
        this.setToolTipText(SearchMessages.getString("Search.FindDeclarationsInWorkingSetAction.tooltip"));
    }

    JavaSearchOperation makeOperation(IJavaElement element) throws JavaModelException {
        IWorkingSet[] workingSets = this.fWorkingSet;
        if (this.fWorkingSet == null && (workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        if (element.getElementType() == 9) {
            IMethod method = (IMethod)element;
            int searchFor = 1;
            if (method.isConstructor()) {
                searchFor = 3;
            }
            String pattern = PrettySignature.getUnqualifiedMethodSignature(method);
            return new JavaSearchOperation(JavaPlugin.getWorkspace(), pattern, true, searchFor, this.getLimitTo(), this.getScope(workingSets), this.getScopeDescription(workingSets), this.getCollector());
        }
        return new JavaSearchOperation(JavaPlugin.getWorkspace(), element, this.getLimitTo(), this.getScope(workingSets), this.getScopeDescription(workingSets), this.getCollector());
    }

    protected JavaSearchQuery createJob(IJavaElement element) throws JavaModelException {
        IWorkingSet[] workingSets = this.fWorkingSet;
        if (this.fWorkingSet == null && (workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        if (element.getElementType() == 9) {
            IMethod method = (IMethod)element;
            int searchFor = 1;
            if (method.isConstructor()) {
                searchFor = 3;
            }
            String pattern = PrettySignature.getUnqualifiedMethodSignature(method);
            return new JavaSearchQuery(new PatternQuerySpecification(pattern, searchFor, true, this.getLimitTo(), this.getScope(workingSets), this.getScopeDescription(workingSets)));
        }
        return new JavaSearchQuery(new ElementQuerySpecification(element, this.getLimitTo(), this.getScope(workingSets), this.getScopeDescription(workingSets)));
    }

    private IJavaSearchScope getScope(IWorkingSet[] workingSets) {
        return JavaSearchScopeFactory.getInstance().createJavaSearchScope(workingSets, true);
    }

    private String getScopeDescription(IWorkingSet[] workingSets) {
        return SearchMessages.getFormattedString("WorkingSetScope", new String[]{SearchUtil.toString(workingSets)});
    }
}

