/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.Map;
import org.eclipse.jdt.internal.ui.text.comment.CommentLine;
import org.eclipse.jdt.internal.ui.text.comment.CommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.ITextMeasurement;
import org.eclipse.jdt.internal.ui.text.comment.JavaDocLine;
import org.eclipse.jdt.internal.ui.text.comment.JavaDocRegion;
import org.eclipse.jdt.internal.ui.text.comment.MultiCommentLine;
import org.eclipse.jdt.internal.ui.text.comment.MultiCommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.SingleCommentLine;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;

public class CommentObjectFactory {
    public static CommentLine createLine(CommentRegion region) {
        String type = region.getType();
        if (type.equals("__java_javadoc")) {
            return new JavaDocLine(region);
        }
        if (type.equals("__java_multiline_comment")) {
            return new MultiCommentLine(region);
        }
        if (type.equals("__java_singleline_comment")) {
            return new SingleCommentLine(region);
        }
        return null;
    }

    public static CommentRegion createRegion(IDocument document, TypedPosition range, String delimiter, Map preferences, ITextMeasurement textMeasurement) {
        String type = range.getType();
        if (type.equals("__java_javadoc")) {
            return new JavaDocRegion(document, range, delimiter, preferences, textMeasurement);
        }
        if (type.equals("__java_multiline_comment")) {
            return new MultiCommentRegion(document, range, delimiter, preferences, textMeasurement);
        }
        return new CommentRegion(document, range, delimiter, preferences, textMeasurement);
    }

    private CommentObjectFactory() {
    }
}

