/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.DeclaringTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.IConstraintVariableFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.IContext;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.RawBindingVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeVariable;

public class ConstraintVariableFactory
implements IConstraintVariableFactory {
    private Map fBindingMap = new HashMap();
    private Map fExpressionMap = new Hashtable();
    private Map fLiteralMap = new HashMap();
    private Map fTypeVariableMap = new HashMap();
    private Map fDeclaringTypeVariableMap = new HashMap();
    private Map fParameterMap = new HashMap();
    private Map fRawBindingMap = new HashMap();
    private Map fReturnVariableMap = new HashMap();
    public static final boolean REPORT = false;
    private int nrCreated = 0;
    private int nrRetrieved = 0;

    public ConstraintVariable makeExpressionOrTypeVariable(Expression expression, IContext context) {
        IBinding binding = ExpressionVariable.resolveBinding(expression);
        if (binding instanceof ITypeBinding) {
            ICompilationUnit cu = ASTCreator.getCu((ASTNode)expression);
            Assert.isNotNull(cu);
            CompilationUnitRange range = new CompilationUnitRange(cu, (ASTNode)expression);
            return this.makeTypeVariable((ITypeBinding)this.getKey(binding), expression.toString(), range);
        }
        if (ASTNodes.isLiteral(expression)) {
            Integer nodeType = new Integer(expression.getNodeType());
            if (!this.fLiteralMap.containsKey(nodeType)) {
                this.fLiteralMap.put(nodeType, new ExpressionVariable(expression));
            }
            return (ExpressionVariable)this.fLiteralMap.get(nodeType);
        }
        Object key = binding != null ? this.getKey(binding) : new CompilationUnitRange(ASTCreator.getCu((ASTNode)expression), (ASTNode)expression);
        ExpressionVariable ev = (ExpressionVariable)this.fExpressionMap.get(key);
        if (ev == null) {
            ev = new ExpressionVariable(expression);
            this.fExpressionMap.put(key, ev);
        }
        return ev;
    }

    private IBinding getKey(IBinding binding) {
        if (this.fBindingMap.containsKey(binding)) {
            return (IBinding)this.fBindingMap.get(binding);
        }
        Iterator it = this.fBindingMap.keySet().iterator();
        while (it.hasNext()) {
            IBinding b2 = (IBinding)it.next();
            if (!Bindings.equals(binding, b2)) continue;
            this.fBindingMap.put(binding, b2);
            return b2;
        }
        this.fBindingMap.put(binding, binding);
        return binding;
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(ITypeBinding memberTypeBinding) {
        String key = memberTypeBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(key)) {
            this.fDeclaringTypeVariableMap.put(key, new DeclaringTypeVariable(memberTypeBinding));
        }
        return (DeclaringTypeVariable)this.fDeclaringTypeVariableMap.get(key);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(IVariableBinding fieldBinding) {
        String key = fieldBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(key)) {
            this.fDeclaringTypeVariableMap.put(key, new DeclaringTypeVariable(fieldBinding));
        }
        return (DeclaringTypeVariable)this.fDeclaringTypeVariableMap.get(key);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(IMethodBinding methodBinding) {
        String key = methodBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(key)) {
            this.fDeclaringTypeVariableMap.put(key, new DeclaringTypeVariable(methodBinding));
        }
        return (DeclaringTypeVariable)this.fDeclaringTypeVariableMap.get(key);
    }

    public ParameterTypeVariable makeParameterTypeVariable(IMethodBinding methodBinding, int parameterIndex) {
        String key = methodBinding.getKey() + parameterIndex;
        if (!this.fParameterMap.containsKey(key)) {
            this.fParameterMap.put(key, new ParameterTypeVariable(methodBinding, parameterIndex));
        }
        return (ParameterTypeVariable)this.fParameterMap.get(key);
    }

    public RawBindingVariable makeRawBindingVariable(ITypeBinding binding) {
        String key = binding.getKey();
        if (!this.fRawBindingMap.containsKey(key)) {
            this.fRawBindingMap.put(key, new RawBindingVariable(binding));
        }
        return (RawBindingVariable)this.fRawBindingMap.get(key);
    }

    public ReturnTypeVariable makeReturnTypeVariable(ReturnStatement returnStatement) {
        return this.makeReturnTypeVariable(ReturnTypeVariable.getMethod(returnStatement).resolveBinding());
    }

    public ReturnTypeVariable makeReturnTypeVariable(IMethodBinding methodBinding) {
        String key = methodBinding.getKey();
        if (!this.fReturnVariableMap.containsKey(key)) {
            this.fReturnVariableMap.put(key, new ReturnTypeVariable(methodBinding));
        }
        return (ReturnTypeVariable)this.fReturnVariableMap.get(key);
    }

    public TypeVariable makeTypeVariable(Type type) {
        ICompilationUnit cu = ASTCreator.getCu((ASTNode)type);
        Assert.isNotNull(cu);
        CompilationUnitRange range = new CompilationUnitRange(cu, (ASTNode)type);
        if (!this.fTypeVariableMap.containsKey(range)) {
            this.fTypeVariableMap.put(range, new TypeVariable(type));
        }
        return (TypeVariable)this.fTypeVariableMap.get(range);
    }

    public TypeVariable makeTypeVariable(ITypeBinding binding, String source, CompilationUnitRange range) {
        if (!this.fTypeVariableMap.containsKey(range)) {
            this.fTypeVariableMap.put(range, new TypeVariable(binding, source, range));
        }
        return (TypeVariable)this.fTypeVariableMap.get(range);
    }

    private void dumpConstraintStats() {
        System.out.println("created: " + this.nrCreated + ", retrieved: " + this.nrRetrieved);
    }
}

