/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class JavaMoveProcessor
extends MoveProcessor
implements IQualifiedNameUpdating,
IReorgDestinationValidator {
    private IReorgQueries fReorgQueries;
    private IReorgPolicy.IMovePolicy fMovePolicy;
    private ICreateTargetQueries fCreateTargetQueries;
    private boolean fWasCanceled;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.MoveProcessor";

    public static boolean isAvailable(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        if (javaElements != null) {
            for (int i = 0; i < javaElements.length; ++i) {
                IJavaElement element = javaElements[i];
                if (element instanceof IType && ((IType)element).isLocal()) {
                    return false;
                }
                if (!(element instanceof IPackageDeclaration)) continue;
                return false;
            }
        }
        return JavaMoveProcessor.isAvailable(ReorgPolicyFactory.createMovePolicy(resources, javaElements, settings));
    }

    public static JavaMoveProcessor create(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        IReorgPolicy.IMovePolicy movePolicy = ReorgPolicyFactory.createMovePolicy(resources, javaElements, settings);
        if (!JavaMoveProcessor.isAvailable(movePolicy)) {
            return null;
        }
        return new JavaMoveProcessor(movePolicy);
    }

    private JavaMoveProcessor(IReorgPolicy.IMovePolicy movePolicy) {
        this.fMovePolicy = movePolicy;
    }

    private static boolean isAvailable(IReorgPolicy.IMovePolicy movePolicy) throws JavaModelException {
        return movePolicy.canEnable();
    }

    protected Object getDestination() {
        IJavaElement je = this.fMovePolicy.getJavaElementDestination();
        if (je != null) {
            return je;
        }
        return this.fMovePolicy.getResourceDestination();
    }

    public Object[] getElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.fMovePolicy.getJavaElements()));
        result.addAll(Arrays.asList(this.fMovePolicy.getResources()));
        return result.toArray();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return JavaMoveProcessor.isAvailable(this.fMovePolicy);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fMovePolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fMovePolicy.getJavaElements());
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fMovePolicy.getResources());
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fMovePolicy.getResources()))));
            IResource[] javaResources = ReorgUtils.getResources(this.fMovePolicy.getJavaElements());
            result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fMovePolicy.getResources(), this.fMovePolicy.getJavaElements()).getCommonParent();
    }

    public IJavaElement[] getJavaElements() {
        return this.fMovePolicy.getJavaElements();
    }

    public IResource[] getResources() {
        return this.fMovePolicy.getResources();
    }

    public RefactoringStatus setDestination(IJavaElement destination) throws JavaModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws JavaModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public boolean canChildrenBeDestinations(IJavaElement javaElement) {
        return this.fMovePolicy.canChildrenBeDestinations(javaElement);
    }

    public boolean canChildrenBeDestinations(IResource resource) {
        return this.fMovePolicy.canChildrenBeDestinations(resource);
    }

    public boolean canElementBeDestination(IJavaElement javaElement) {
        return this.fMovePolicy.canElementBeDestination(javaElement);
    }

    public boolean canElementBeDestination(IResource resource) {
        return this.fMovePolicy.canElementBeDestination(resource);
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull(queries);
        this.fReorgQueries = queries;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            Assert.isNotNull(this.fReorgQueries);
            this.fWasCanceled = false;
            return this.fMovePolicy.checkFinalConditions(pm, context, this.fReorgQueries);
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        Assert.isTrue(this.fMovePolicy.getJavaElementDestination() == null || this.fMovePolicy.getResourceDestination() == null);
        Assert.isTrue(this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null);
        try {
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.getString("Change.javaChanges")){

                public Change perform(IProgressMonitor pm2) throws CoreException {
                    super.perform(pm2);
                    return null;
                }
            };
            Change change = this.fMovePolicy.createChange(pm);
            if (change instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        return this.fMovePolicy.postCreateChange(participantChanges, pm);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getString("MoveRefactoring.0");
    }

    public boolean canUpdateReferences() {
        return this.fMovePolicy.canUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        this.fMovePolicy.setUpdateReferences(update);
    }

    public boolean getUpdateReferences() {
        if (!this.canUpdateReferences()) {
            return false;
        }
        return this.fMovePolicy.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        return this.fMovePolicy.canEnableQualifiedNameUpdating();
    }

    public boolean canUpdateQualifiedNames() {
        return this.fMovePolicy.canUpdateQualifiedNames();
    }

    public String getFilePatterns() {
        return this.fMovePolicy.getFilePatterns();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fMovePolicy.getUpdateQualifiedNames();
    }

    public void setFilePatterns(String patterns) {
        this.fMovePolicy.setFilePatterns(patterns);
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fMovePolicy.setUpdateQualifiedNames(update);
    }

    public boolean hasAllInputSet() {
        return this.fMovePolicy.hasAllInputSet();
    }

    public boolean hasDestinationSet() {
        return this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null;
    }

    public void setCreateTargetQueries(ICreateTargetQueries queries) {
        Assert.isNotNull(queries);
        this.fCreateTargetQueries = queries;
    }

    public ICreateTargetQuery getCreateTargetQuery() {
        return this.fMovePolicy.getCreateTargetQuery(this.fCreateTargetQueries);
    }

    public boolean isTextualMove() {
        return this.fMovePolicy.isTextualMove();
    }
}

