/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaBreakpointAdvancedPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ThreadFilterEditor {
    private JavaBreakpointAdvancedPage fPage;
    private CheckboxTreeViewer fThreadViewer;
    private ThreadFilterContentProvider fContentProvider;
    private CheckHandler fCheckHandler;
    private static String MAIN = "main";
    static /* synthetic */ Class class$org$eclipse$jdt$debug$core$IJavaDebugTarget;

    public ThreadFilterEditor(Composite parent, JavaBreakpointAdvancedPage page) {
        this.fPage = page;
        this.fContentProvider = new ThreadFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        this.createThreadViewer(parent);
    }

    private void createThreadViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PropertyPageMessages.getString("ThreadFilterEditor.1"));
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fThreadViewer = new CheckboxTreeViewer(parent, 2048);
        this.fThreadViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fThreadViewer.getTree().setLayoutData((Object)data);
        this.fThreadViewer.getTree().setFont(parent.getFont());
        this.fThreadViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fThreadViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fThreadViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        this.setInitialCheckedState();
    }

    protected void doStore() {
        IDebugTarget[] targets = this.getDebugTargets();
        int numTargets = targets.length;
        block2: for (int i = 0; i < numTargets; ++i) {
            IJavaDebugTarget target = (IJavaDebugTarget)targets[i].getAdapter(class$org$eclipse$jdt$debug$core$IJavaDebugTarget == null ? ThreadFilterEditor.class$("org.eclipse.jdt.debug.core.IJavaDebugTarget") : class$org$eclipse$jdt$debug$core$IJavaDebugTarget);
            if (target == null) continue;
            try {
                if (this.fThreadViewer.getChecked((Object)target)) {
                    IThread[] threads = target.getThreads();
                    int numThreads = threads.length;
                    for (int j = 0; j < numThreads; ++j) {
                        IJavaThread thread = (IJavaThread)threads[j];
                        if (!this.fThreadViewer.getChecked((Object)thread)) continue;
                        this.fPage.getBreakpoint().setThreadFilter(thread);
                        continue block2;
                    }
                    continue;
                }
                this.fPage.getBreakpoint().removeThreadFilter(target);
                continue;
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
    }

    protected void setInitialCheckedState() {
        try {
            IDebugTarget[] targets = this.getDebugTargets();
            int numTargets = targets.length;
            for (int i = 0; i < numTargets; ++i) {
                IJavaThread filteredThread;
                IJavaDebugTarget target = (IJavaDebugTarget)targets[i].getAdapter(class$org$eclipse$jdt$debug$core$IJavaDebugTarget == null ? ThreadFilterEditor.class$("org.eclipse.jdt.debug.core.IJavaDebugTarget") : class$org$eclipse$jdt$debug$core$IJavaDebugTarget);
                if (target == null || (filteredThread = this.fPage.getBreakpoint().getThreadFilter(target)) == null) continue;
                this.fCheckHandler.checkThread((IThread)filteredThread, true);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected IDebugTarget[] getDebugTargets() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new IJavaDebugTarget[0];
        }
        ILaunchManager launchManager = (ILaunchManager)input;
        return launchManager.getDebugTargets();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ThreadFilterContentProvider
    implements ITreeContentProvider {
        ThreadFilterContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            IJavaDebugTarget target;
            if (parent instanceof IDebugTarget && (target = (IJavaDebugTarget)((IDebugTarget)parent).getAdapter(class$org$eclipse$jdt$debug$core$IJavaDebugTarget == null ? (class$org$eclipse$jdt$debug$core$IJavaDebugTarget = ThreadFilterEditor.class$("org.eclipse.jdt.debug.core.IJavaDebugTarget")) : class$org$eclipse$jdt$debug$core$IJavaDebugTarget)) != null) {
                try {
                    return ((IJavaDebugTarget)parent).getThreads();
                }
                catch (DebugException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            if (parent instanceof ILaunchManager) {
                ArrayList<IJavaDebugTarget> children = new ArrayList<IJavaDebugTarget>();
                ILaunch[] launches = ((ILaunchManager)parent).getLaunches();
                int numLaunches = launches.length;
                for (int i = 0; i < numLaunches; ++i) {
                    IDebugTarget[] targets = launches[i].getDebugTargets();
                    int numTargets = targets.length;
                    for (int j = 0; j < numTargets; ++j) {
                        IJavaDebugTarget target2 = (IJavaDebugTarget)targets[j].getAdapter(class$org$eclipse$jdt$debug$core$IJavaDebugTarget == null ? ThreadFilterEditor.class$("org.eclipse.jdt.debug.core.IJavaDebugTarget") : class$org$eclipse$jdt$debug$core$IJavaDebugTarget);
                        if (target2 == null || target2.isDisconnected() || target2.isTerminated()) continue;
                        children.add(target2);
                    }
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IThread) {
                return ((IThread)element).getDebugTarget();
            }
            if (element instanceof IDebugTarget) {
                return ((IDebugElement)element).getLaunch();
            }
            if (element instanceof ILaunch) {
                return DebugPlugin.getDefault().getLaunchManager();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IStackFrame) {
                return false;
            }
            if (element instanceof IDebugElement) {
                return this.getChildren(element).length > 0;
            }
            if (element instanceof ILaunch) {
                return true;
            }
            if (element instanceof ILaunchManager) {
                return ((ILaunchManager)element).getLaunches().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CheckHandler
    implements ICheckStateListener {
        CheckHandler() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof IDebugTarget) {
                this.checkTarget((IDebugTarget)element, event.getChecked());
            } else if (element instanceof IThread) {
                this.checkThread((IThread)element, event.getChecked());
            }
            this.verifyCheckedState();
        }

        protected void checkTarget(IDebugTarget target, boolean checked) {
            block10: {
                IThread[] threads;
                block9: {
                    int i;
                    IThread[] threads2;
                    ThreadFilterEditor.this.fThreadViewer.setChecked((Object)target, checked);
                    if (!checked) break block9;
                    ThreadFilterEditor.this.fThreadViewer.expandToLevel((Object)target, -1);
                    try {
                        threads2 = target.getThreads();
                    }
                    catch (DebugException exception) {
                        JDIDebugUIPlugin.log(exception);
                        return;
                    }
                    boolean checkedThread = false;
                    int numThreads = threads2.length;
                    for (i = 0; i < numThreads; ++i) {
                        IThread thread = threads2[i];
                        String name = null;
                        try {
                            name = thread.getName();
                        }
                        catch (DebugException exception) {
                            JDIDebugUIPlugin.log(exception);
                        }
                        if (!MAIN.equals(name)) continue;
                        checkedThread = ThreadFilterEditor.this.fThreadViewer.setChecked((Object)thread, true);
                    }
                    if (checkedThread) break block10;
                    numThreads = threads2.length;
                    for (i = 0; i < numThreads && !ThreadFilterEditor.this.fThreadViewer.setChecked((Object)threads2[i], true); ++i) {
                    }
                    break block10;
                }
                try {
                    threads = target.getThreads();
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                    return;
                }
                int numThreads = threads.length;
                for (int i = 0; i < numThreads; ++i) {
                    ThreadFilterEditor.this.fThreadViewer.setChecked((Object)threads[i], false);
                }
            }
        }

        protected void checkThread(IThread thread, boolean checked) {
            ThreadFilterEditor.this.fThreadViewer.setChecked((Object)thread, checked);
            IDebugTarget target = thread.getDebugTarget();
            if (checked) {
                IThread[] threads;
                if (!ThreadFilterEditor.this.fThreadViewer.getChecked((Object)target)) {
                    ThreadFilterEditor.this.fThreadViewer.setChecked((Object)target, true);
                }
                try {
                    threads = target.getThreads();
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                    return;
                }
                int numThreads = threads.length;
                for (int i = 0; i < numThreads; ++i) {
                    if (threads[i] == thread) continue;
                    ThreadFilterEditor.this.fThreadViewer.setChecked((Object)threads[i], false);
                }
            } else {
                ThreadFilterEditor.this.fThreadViewer.setChecked((Object)target, false);
            }
        }

        protected void verifyCheckedState() {
            IDebugTarget[] targets = ThreadFilterEditor.this.getDebugTargets();
            int numTargets = targets.length;
            for (int i = 0; i < numTargets; ++i) {
                IThread[] threads;
                IDebugTarget target = targets[i];
                if (!ThreadFilterEditor.this.fThreadViewer.getChecked((Object)target)) continue;
                try {
                    threads = target.getThreads();
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                    continue;
                }
                boolean checkedThread = false;
                int numThreads = threads.length;
                for (int j = 0; j < numThreads; ++j) {
                    if (!ThreadFilterEditor.this.fThreadViewer.getChecked((Object)threads[j])) continue;
                    checkedThread = true;
                    break;
                }
                if (checkedThread) {
                    ThreadFilterEditor.this.fPage.setErrorMessage(null);
                    continue;
                }
                ThreadFilterEditor.this.fPage.setErrorMessage(PropertyPageMessages.getString("ThreadFilterEditor.2"));
            }
        }
    }
}

