/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.display;

import com.sun.jdi.InvocationException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.display.DisplayMessages;

public class JavaInspectExpression
extends PlatformObject
implements IErrorReportingExpression,
IDebugEventSetListener {
    private IJavaValue fValue;
    private String fExpression;
    private IEvaluationResult fResult;

    public JavaInspectExpression(String expression, IJavaValue value) {
        this.fValue = value;
        this.fExpression = expression;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public JavaInspectExpression(IEvaluationResult result) {
        this(result.getSnippet(), result.getValue());
        this.fResult = result;
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public IDebugTarget getDebugTarget() {
        IValue value = this.getValue();
        if (value != null) {
            return this.getValue().getDebugTarget();
        }
        if (this.fResult != null) {
            return this.fResult.getThread().getDebugTarget();
        }
        return null;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            if (event.getKind() != 8 || !event.getSource().equals(this.getDebugTarget())) continue;
            DebugPlugin.getDefault().getExpressionManager().removeExpression((IExpression)this);
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public boolean hasErrors() {
        return this.fResult != null && this.fResult.hasErrors();
    }

    public String[] getErrorMessages() {
        return JavaInspectExpression.getErrorMessages(this.fResult);
    }

    public static String[] getErrorMessages(IEvaluationResult result) {
        if (result == null) {
            return new String[0];
        }
        String[] messages = result.getErrorMessages();
        if (messages.length > 0) {
            return messages;
        }
        DebugException exception = result.getException();
        if (exception != null) {
            Throwable cause = exception.getStatus().getException();
            if (cause instanceof InvocationException) {
                String nestedMessage = ((InvocationException)cause).exception().referenceType().name();
                return new String[]{MessageFormat.format(DisplayMessages.getString("JavaInspectExpression.0"), nestedMessage)};
            }
            return new String[]{exception.getMessage()};
        }
        return new String[0];
    }
}

