/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.browser.BrowserDescriptor;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class BrowsersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button alwaysExternal;
    private Button[] externalBrowsers;
    private Button customBrowserRadio;
    private Label customBrowserPathLabel;
    private Text customBrowserPath;
    private Button customBrowserBrowse;

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.help.ui.prefPageBrowsers");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        Label description = new Label(mainComposite, 0);
        description.setText(HelpUIResources.getString("select_browser"));
        this.createSpacer(mainComposite);
        if (BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            this.alwaysExternal = new Button(mainComposite, 32);
            this.alwaysExternal.setLayoutData((Object)new GridData(512));
            this.alwaysExternal.setText(HelpUIResources.getString("use_only_external_browser"));
            this.alwaysExternal.setSelection(HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("always_external_browser"));
            this.createSpacer(mainComposite);
        }
        Label tableDescription = new Label(mainComposite, 0);
        tableDescription.setText(HelpUIResources.getString("current_browser"));
        Color bgColor = parent.getDisplay().getSystemColor(25);
        Color fgColor = parent.getDisplay().getSystemColor(24);
        ScrolledComposite externalBrowsersScrollable = new ScrolledComposite(mainComposite, 2816);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(2);
        externalBrowsersScrollable.setLayoutData((Object)gd);
        externalBrowsersScrollable.setBackground(bgColor);
        externalBrowsersScrollable.setForeground(fgColor);
        Composite externalBrowsersComposite = new Composite((Composite)externalBrowsersScrollable, 0);
        externalBrowsersScrollable.setContent((Control)externalBrowsersComposite);
        GridLayout layout2 = new GridLayout();
        externalBrowsersComposite.setLayout((Layout)layout2);
        externalBrowsersComposite.setBackground(bgColor);
        externalBrowsersComposite.setForeground(fgColor);
        BrowserDescriptor[] descriptors = BrowserManager.getInstance().getBrowserDescriptors();
        this.externalBrowsers = new Button[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            Button radio = new Button(externalBrowsersComposite, 16);
            Dialog.applyDialogFont((Control)radio);
            radio.setBackground(bgColor);
            radio.setForeground(fgColor);
            radio.setText(descriptors[i].getLabel());
            if (BrowserManager.getInstance().getCurrentBrowserID().equals(descriptors[i].getID())) {
                radio.setSelection(true);
            } else {
                radio.setSelection(false);
            }
            radio.setData((Object)descriptors[i]);
            this.externalBrowsers[i] = radio;
            if (!"org.eclipse.help.base.custombrowser".equals(descriptors[i].getID())) continue;
            this.customBrowserRadio = radio;
            radio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selEvent) {
                    BrowsersPreferencePage.this.setCustomBrowserPathEnabled();
                }

                public void widgetDefaultSelected(SelectionEvent selEvent) {
                    this.widgetSelected(selEvent);
                }
            });
        }
        externalBrowsersComposite.setSize(externalBrowsersComposite.computeSize(-1, -1));
        this.createCustomBrowserPathPart(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
        this.createSpacer(mainComposite);
        return mainComposite;
    }

    private void createCustomBrowserPathPart(Composite mainComposite) {
        Font font = mainComposite.getFont();
        new Label(mainComposite, 0);
        Composite bPathComposite = new Composite(mainComposite, 0);
        WorkbenchHelp.setHelp((Control)bPathComposite, (String)"org.eclipse.help.ui.prefPageCustomBrowserPath");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        bPathComposite.setLayout((Layout)layout);
        bPathComposite.setLayoutData((Object)new GridData(768));
        this.customBrowserPathLabel = new Label(bPathComposite, 16384);
        this.customBrowserPathLabel.setFont(font);
        this.customBrowserPathLabel.setText(HelpUIResources.getString("CustomBrowserPreferencePage.Program"));
        this.customBrowserPath = new Text(bPathComposite, 2048);
        this.customBrowserPath.setLayoutData((Object)new GridData(768));
        this.customBrowserPath.setFont(font);
        this.customBrowserPath.setText(HelpBasePlugin.getDefault().getPluginPreferences().getString("custom_browser_path"));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.widthHint = this.convertWidthInCharsToPixels(10);
        this.customBrowserPath.setLayoutData((Object)data);
        this.customBrowserBrowse = new Button(bPathComposite, 0);
        this.customBrowserBrowse.setFont(font);
        this.customBrowserBrowse.setText(HelpUIResources.getString("CustomBrowserPreferencePage.Browse"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.customBrowserBrowse.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.customBrowserBrowse.setLayoutData((Object)data);
        this.customBrowserBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog d = new FileDialog(BrowsersPreferencePage.this.getShell());
                d.setText(HelpUIResources.getString("CustomBrowserPreferencePage.Details"));
                String file = d.open();
                if (file != null) {
                    BrowsersPreferencePage.this.customBrowserPath.setText("\"" + file + "\" %1");
                }
            }
        });
        this.setCustomBrowserPathEnabled();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        String defaultBrowserID = BrowserManager.getInstance().getDefaultBrowserID();
        for (int i = 0; i < this.externalBrowsers.length; ++i) {
            BrowserDescriptor descriptor = (BrowserDescriptor)this.externalBrowsers[i].getData();
            this.externalBrowsers[i].setSelection(descriptor.getID() == defaultBrowserID);
        }
        this.customBrowserPath.setText(HelpBasePlugin.getDefault().getPluginPreferences().getDefaultString("custom_browser_path"));
        this.setCustomBrowserPathEnabled();
        if (this.alwaysExternal != null) {
            this.alwaysExternal.setSelection(HelpBasePlugin.getDefault().getPluginPreferences().getDefaultBoolean("always_external_browser"));
        }
        super.performDefaults();
    }

    public boolean performOk() {
        Preferences pref = HelpBasePlugin.getDefault().getPluginPreferences();
        for (int i = 0; i < this.externalBrowsers.length; ++i) {
            if (!this.externalBrowsers[i].getSelection()) continue;
            String browserID = ((BrowserDescriptor)this.externalBrowsers[i].getData()).getID();
            BrowserManager.getInstance().setCurrentBrowserID(browserID);
            pref.setValue("default_browser", browserID);
            break;
        }
        pref.setValue("custom_browser_path", this.customBrowserPath.getText());
        if (this.alwaysExternal != null) {
            pref.setValue("always_external_browser", this.alwaysExternal.getSelection());
            BrowserManager.getInstance().setAlwaysUseExternal(this.alwaysExternal.getSelection());
        }
        HelpBasePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    private void setCustomBrowserPathEnabled() {
        boolean enabled = this.customBrowserRadio.getSelection();
        this.customBrowserPathLabel.setEnabled(enabled);
        this.customBrowserPath.setEnabled(enabled);
        this.customBrowserBrowse.setEnabled(enabled);
    }
}

