/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DeltaProcessingState;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.util.Util;

public class SetClasspathOperation
extends JavaModelOperation {
    IClasspathEntry[] oldResolvedPath;
    IClasspathEntry[] newResolvedPath;
    IClasspathEntry[] newRawPath;
    boolean canChangeResources;
    boolean classpathWasSaved;
    boolean needCycleCheck;
    boolean needValidation;
    boolean needSave;
    IPath newOutputLocation;
    JavaProject project;
    boolean identicalRoots;
    public static final IClasspathEntry[] ReuseClasspath = new IClasspathEntry[0];
    public static final IClasspathEntry[] UpdateClasspath = new IClasspathEntry[0];
    public static final IPath ReuseOutputLocation = new Path("Reuse Existing Output Location");

    public SetClasspathOperation(JavaProject project, IClasspathEntry[] oldResolvedPath, IClasspathEntry[] newRawPath, IPath newOutputLocation, boolean canChangeResource, boolean needValidation, boolean needSave) {
        super(new IJavaElement[]{project});
        this.oldResolvedPath = oldResolvedPath;
        this.newRawPath = newRawPath;
        this.newOutputLocation = newOutputLocation;
        this.canChangeResources = canChangeResource;
        this.needValidation = needValidation;
        this.needSave = needSave;
        this.project = project;
    }

    protected void addClasspathDeltas(IPackageFragmentRoot[] roots, int flag, JavaElementDelta delta) {
        for (int i = 0; i < roots.length; ++i) {
            IPackageFragmentRoot root = roots[i];
            delta.changed(root, flag);
            if ((flag & 0x80) == 0 && (flag & 0x1000) == 0 && (flag & 0x2000) == 0) continue;
            try {
                root.close();
            }
            catch (JavaModelException e) {
                // empty catch block
            }
            ((PackageFragmentRoot)root).setSourceAttachmentProperty(null);
        }
    }

    protected int classpathContains(IClasspathEntry[] list, IClasspathEntry entry) {
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        block0: for (int i = 0; i < list.length; ++i) {
            IPath[] otherExcludes;
            IClasspathEntry other = list[i];
            if (other.getContentKind() != entry.getContentKind() || other.getEntryKind() != entry.getEntryKind() || other.isExported() != entry.isExported() || !other.getPath().equals(entry.getPath())) continue;
            IPath entryOutput = entry.getOutputLocation();
            IPath otherOutput = other.getOutputLocation();
            if (entryOutput != null ? !entryOutput.equals(otherOutput) : otherOutput != null) continue;
            IPath[] otherIncludes = other.getInclusionPatterns();
            if (inclusionPatterns != otherIncludes) {
                if (inclusionPatterns == null) continue;
                int includeLength = inclusionPatterns.length;
                if (otherIncludes == null || otherIncludes.length != includeLength) continue;
                for (int j = 0; j < includeLength; ++j) {
                    if (!inclusionPatterns[j].toString().equals(otherIncludes[j].toString())) continue block0;
                }
            }
            if (exclusionPatterns != (otherExcludes = other.getExclusionPatterns())) {
                if (exclusionPatterns == null) continue;
                int excludeLength = exclusionPatterns.length;
                if (otherExcludes == null || otherExcludes.length != excludeLength) continue;
                for (int j = 0; j < excludeLength; ++j) {
                    if (!exclusionPatterns[j].toString().equals(otherExcludes[j].toString())) continue block0;
                }
            }
            return i;
        }
        return -1;
    }

    protected void collectAllSubfolders(IFolder folder, ArrayList collection) throws JavaModelException {
        try {
            IResource[] members = folder.members();
            int max = members.length;
            for (int i = 0; i < max; ++i) {
                IResource r = members[i];
                if (r.getType() != 2) continue;
                collection.add(r);
                this.collectAllSubfolders((IFolder)r, collection);
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected ArrayList determineAffectedPackageFragments(IPath location) throws JavaModelException {
        ArrayList<IPackageFragment> fragments = new ArrayList<IPackageFragment>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource resource = null;
        if (location != null) {
            resource = workspace.getRoot().findMember(location);
        }
        if (resource != null && resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            IClasspathEntry[] classpath = this.project.getExpandedClasspath(true);
            for (int i = 0; i < classpath.length; ++i) {
                IClasspathEntry entry = classpath[i];
                IPath path = classpath[i].getPath();
                if (entry.getEntryKind() == 2 || !path.isPrefixOf(location) || path.equals(location)) continue;
                IPackageFragmentRoot[] roots = this.project.computePackageFragmentRoots(classpath[i]);
                IPackageFragmentRoot root = roots[0];
                ArrayList<IFolder> folders = new ArrayList<IFolder>();
                folders.add(folder);
                this.collectAllSubfolders(folder, folders);
                Iterator elements = folders.iterator();
                int segments = path.segmentCount();
                while (elements.hasNext()) {
                    IFolder f = (IFolder)elements.next();
                    IPath relativePath = f.getFullPath().removeFirstSegments(segments);
                    String name = relativePath.toOSString();
                    if ((name = name.replace(File.pathSeparatorChar, '.')).endsWith(".")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    IPackageFragment pkg = root.getPackageFragment(name);
                    fragments.add(pkg);
                }
            }
        }
        return fragments;
    }

    /*
     * Loose catch block
     */
    protected void executeOperation() throws JavaModelException {
        block25: {
            Object v0;
            JavaModelException originalException;
            block21: {
                this.updateProjectReferencesIfNecessary();
                this.saveClasspathIfNecessary();
                originalException = null;
                if (this.newRawPath == UpdateClasspath) {
                    this.newRawPath = this.project.getRawClasspath();
                }
                if (this.newRawPath == ReuseClasspath) break block21;
                this.updateClasspath();
                this.project.updatePackageFragmentRoots();
                JavaModelManager.getJavaModelManager().getDeltaProcessor().addForRefresh(this.project);
            }
            Object var4_2 = null;
            try {
                try {
                    if (this.newOutputLocation != ReuseOutputLocation) {
                        this.updateOutputLocation();
                    }
                    v0 = null;
                }
                catch (JavaModelException e) {
                    if (originalException != null) {
                        throw originalException;
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_8;
                v0 = var7_8 = null;
            }
            if (!this.identicalRoots && this.canChangeResources) {
                try {
                    this.project.getProject().touch(this.progressMonitor);
                }
                catch (CoreException e) {
                    if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                        Util.verbose("CPContainer INIT - FAILED to touch project: " + this.project.getElementName(), System.err);
                        e.printStackTrace();
                    }
                }
            }
            break block25;
            {
                catch (JavaModelException e) {
                    originalException = e;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block24: {
                    Object v1;
                    Object var4_3 = null;
                    try {
                        try {
                            if (this.newOutputLocation != ReuseOutputLocation) {
                                this.updateOutputLocation();
                            }
                            v1 = null;
                        }
                        catch (JavaModelException e) {
                            if (originalException != null) {
                                throw originalException;
                            }
                            throw e;
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var7_9;
                        v1 = var7_9 = null;
                    }
                    if (!this.identicalRoots && this.canChangeResources) {
                        try {
                            this.project.getProject().touch(this.progressMonitor);
                        }
                        catch (CoreException e) {
                            if (!JavaModelManager.CP_RESOLVE_VERBOSE) break block24;
                            Util.verbose("CPContainer INIT - FAILED to touch project: " + this.project.getElementName(), System.err);
                            e.printStackTrace();
                        }
                    }
                }
                throw throwable;
            }
        }
        this.done();
    }

    protected void generateClasspathChangeDeltas() {
        int i;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        boolean needToUpdateDependents = false;
        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
        boolean hasDelta = false;
        if (this.classpathWasSaved) {
            delta.changed(this.project, 131072);
            hasDelta = true;
        }
        int oldLength = this.oldResolvedPath.length;
        int newLength = this.newResolvedPath.length;
        final IndexManager indexManager = manager.getIndexManager();
        HashMap<IPath, IPackageFragmentRoot> oldRoots = null;
        IPackageFragmentRoot[] roots = null;
        if (this.project.isOpen()) {
            try {
                roots = this.project.getPackageFragmentRoots();
            }
            catch (JavaModelException e) {}
        } else {
            Map allRemovedRoots = manager.getDeltaProcessor().removedRoots;
            if (allRemovedRoots != null) {
                roots = (IPackageFragmentRoot[])allRemovedRoots.get(this.project);
            }
        }
        if (roots != null) {
            oldRoots = new HashMap<IPath, IPackageFragmentRoot>();
            for (int i2 = 0; i2 < roots.length; ++i2) {
                IPackageFragmentRoot root = roots[i2];
                oldRoots.put(root.getPath(), root);
            }
        }
        for (i = 0; i < oldLength; ++i) {
            IPath newRootPath;
            IPath oldRootPath;
            int sourceAttachmentRootFlags;
            int index = this.classpathContains(this.newResolvedPath, this.oldResolvedPath[i]);
            if (index == -1) {
                IPackageFragmentRoot oldRoot;
                if (this.oldResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                    continue;
                }
                Object[] pkgFragmentRoots = null;
                if (oldRoots != null && (oldRoot = (IPackageFragmentRoot)oldRoots.get(this.oldResolvedPath[i].getPath())) != null) {
                    pkgFragmentRoots = new IPackageFragmentRoot[]{oldRoot};
                }
                if (pkgFragmentRoots == null) {
                    try {
                        ObjectVector accumulatedRoots = new ObjectVector();
                        HashSet<String> rootIDs = new HashSet<String>(5);
                        rootIDs.add(this.project.rootID());
                        this.project.computePackageFragmentRoots(this.oldResolvedPath[i], accumulatedRoots, rootIDs, true, false, false);
                        pkgFragmentRoots = new IPackageFragmentRoot[accumulatedRoots.size()];
                        accumulatedRoots.copyInto(pkgFragmentRoots);
                    }
                    catch (JavaModelException e) {
                        pkgFragmentRoots = new IPackageFragmentRoot[]{};
                    }
                }
                this.addClasspathDeltas((IPackageFragmentRoot[])pkgFragmentRoots, 128, delta);
                int changeKind = this.oldResolvedPath[i].getEntryKind();
                needToUpdateDependents |= changeKind == 3 || this.oldResolvedPath[i].isExported();
                if (indexManager != null) {
                    IClasspathEntry oldEntry = this.oldResolvedPath[i];
                    final IPath path = oldEntry.getPath();
                    switch (changeKind) {
                        case 3: {
                            final char[][] inclusionPatterns = ((ClasspathEntry)oldEntry).fullInclusionPatternChars();
                            final char[][] exclusionPatterns = ((ClasspathEntry)oldEntry).fullExclusionPatternChars();
                            this.postAction(new JavaModelOperation.IPostAction(){

                                public String getID() {
                                    return path.toString();
                                }

                                public void run() {
                                    indexManager.removeSourceFolderFromIndex(SetClasspathOperation.this.project, path, inclusionPatterns, exclusionPatterns);
                                }
                            }, 2);
                            break;
                        }
                        case 1: {
                            final DeltaProcessingState deltaState = manager.deltaState;
                            this.postAction(new JavaModelOperation.IPostAction(){

                                public String getID() {
                                    return path.toString();
                                }

                                public void run() {
                                    if (deltaState.otherRoots.get(path) == null) {
                                        indexManager.discardJobs(path.toString());
                                        indexManager.removeIndex(path);
                                    }
                                }
                            }, 2);
                        }
                    }
                }
                hasDelta = true;
                continue;
            }
            if (this.oldResolvedPath[i].getEntryKind() == 2) {
                this.needCycleCheck |= this.oldResolvedPath[i].isExported() != this.newResolvedPath[index].isExported();
                continue;
            }
            needToUpdateDependents |= this.oldResolvedPath[i].isExported() != this.newResolvedPath[index].isExported();
            if (index != i) {
                this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.oldResolvedPath[i]), 256, delta);
                int changeKind = this.oldResolvedPath[i].getEntryKind();
                needToUpdateDependents |= changeKind == 3;
                hasDelta = true;
            }
            IPath newSourcePath = this.newResolvedPath[index].getSourceAttachmentPath();
            int sourceAttachmentFlags = this.getSourceAttachmentDeltaFlag(this.oldResolvedPath[i].getSourceAttachmentPath(), newSourcePath);
            int flags = sourceAttachmentFlags | (sourceAttachmentRootFlags = this.getSourceAttachmentDeltaFlag(oldRootPath = this.oldResolvedPath[i].getSourceAttachmentRootPath(), newRootPath = this.newResolvedPath[index].getSourceAttachmentRootPath()));
            if (flags != 0) {
                this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.oldResolvedPath[i]), flags, delta);
                hasDelta = true;
                continue;
            }
            if (oldRootPath != null || newRootPath != null) continue;
            IPackageFragmentRoot[] computedRoots = this.project.computePackageFragmentRoots(this.oldResolvedPath[i]);
            for (int j = 0; j < computedRoots.length; ++j) {
                IPackageFragmentRoot root = computedRoots[j];
                try {
                    root.close();
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
                ((PackageFragmentRoot)root).setSourceAttachmentProperty(null);
            }
        }
        for (i = 0; i < newLength; ++i) {
            int index = this.classpathContains(this.oldResolvedPath, this.newResolvedPath[i]);
            if (index != -1) continue;
            if (this.newResolvedPath[i].getEntryKind() == 2) {
                needToUpdateDependents = true;
                this.needCycleCheck = true;
                continue;
            }
            this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.newResolvedPath[i]), 64, delta);
            int changeKind = this.newResolvedPath[i].getEntryKind();
            if (indexManager != null) {
                switch (changeKind) {
                    case 1: {
                        boolean pathHasChanged = true;
                        final IPath newPath = this.newResolvedPath[i].getPath();
                        for (int j = 0; j < oldLength; ++j) {
                            IClasspathEntry oldEntry = this.oldResolvedPath[j];
                            if (!oldEntry.getPath().equals(newPath)) continue;
                            pathHasChanged = false;
                            break;
                        }
                        if (!pathHasChanged) break;
                        this.postAction(new JavaModelOperation.IPostAction(){

                            public String getID() {
                                return newPath.toString();
                            }

                            public void run() {
                                indexManager.indexLibrary(newPath, SetClasspathOperation.this.project.getProject());
                            }
                        }, 2);
                        break;
                    }
                    case 3: {
                        IClasspathEntry entry = this.newResolvedPath[i];
                        final IPath path = entry.getPath();
                        final char[][] inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                        final char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                        this.postAction(new JavaModelOperation.IPostAction(){

                            public String getID() {
                                return path.toString();
                            }

                            public void run() {
                                indexManager.indexSourceFolder(SetClasspathOperation.this.project, path, inclusionPatterns, exclusionPatterns);
                            }
                        }, 1);
                    }
                }
            }
            needToUpdateDependents |= changeKind == 3 || this.newResolvedPath[i].isExported();
            hasDelta = true;
        }
        if (hasDelta) {
            this.addDelta(delta);
        } else {
            this.identicalRoots = true;
        }
        if (needToUpdateDependents) {
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
    }

    private int getSourceAttachmentDeltaFlag(IPath oldPath, IPath newPath) {
        if (oldPath == null) {
            if (newPath != null) {
                return 4096;
            }
            return 0;
        }
        if (newPath == null) {
            return 8192;
        }
        if (!oldPath.equals(newPath)) {
            return 12288;
        }
        return 0;
    }

    public boolean isReadOnly() {
        return !this.canChangeResources;
    }

    protected void saveClasspathIfNecessary() throws JavaModelException {
        IPath outputLocationForSave;
        if (!this.canChangeResources || !this.needSave) {
            return;
        }
        IClasspathEntry[] classpathForSave = this.newRawPath == ReuseClasspath || this.newRawPath == UpdateClasspath ? this.project.getRawClasspath() : this.newRawPath;
        if (this.project.saveClasspath(classpathForSave, outputLocationForSave = this.newOutputLocation == ReuseOutputLocation ? this.project.getOutputLocation() : this.newOutputLocation)) {
            this.classpathWasSaved = true;
            this.setAttribute("hasModifiedResource", "true");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetClasspathOperation\n");
        buffer.append(" - classpath : ");
        if (this.newRawPath == ReuseClasspath) {
            buffer.append("<Reuse Existing Classpath>");
        } else {
            buffer.append("{");
            for (int i = 0; i < this.newRawPath.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                IClasspathEntry element = this.newRawPath[i];
                buffer.append(" ").append(element.toString());
            }
        }
        buffer.append("\n - output location : ");
        if (this.newOutputLocation == ReuseOutputLocation) {
            buffer.append("<Reuse Existing Output Location>");
        } else {
            buffer.append(this.newOutputLocation.toString());
        }
        return buffer.toString();
    }

    private void updateClasspath() throws JavaModelException {
        this.beginTask(Util.bind("classpath.settingProgress", this.project.getElementName()), 2);
        this.project.getPerProjectInfo().updateClasspathInformation(this.newRawPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = this.project.getResolvedClasspath(true, this.canChangeResources, false);
        }
        if (this.oldResolvedPath != null) {
            this.generateClasspathChangeDeltas();
        } else {
            this.needCycleCheck = true;
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
        this.updateCycleMarkersIfNecessary();
    }

    protected void updateAffectedProjects(IPath prerequisiteProjectPath) {
        this.removeAllPostAction(prerequisiteProjectPath.toString());
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject initialProject = this.project;
            IJavaProject[] projects = model.getJavaProjects();
            int projectCount = projects.length;
            block4: for (int i = 0; i < projectCount; ++i) {
                try {
                    final JavaProject affectedProject = (JavaProject)projects[i];
                    if (affectedProject.equals(initialProject)) continue;
                    IClasspathEntry[] classpath = affectedProject.getExpandedClasspath(true);
                    int entryCount = classpath.length;
                    for (int j = 0; j < entryCount; ++j) {
                        IClasspathEntry entry = classpath[j];
                        if (entry.getEntryKind() != 2 || !entry.getPath().equals(prerequisiteProjectPath)) continue;
                        this.postAction(new JavaModelOperation.IPostAction(){

                            public String getID() {
                                return affectedProject.getPath().toString();
                            }

                            public void run() throws JavaModelException {
                                affectedProject.setRawClasspath(UpdateClasspath, ReuseOutputLocation, SetClasspathOperation.this.progressMonitor, SetClasspathOperation.this.canChangeResources, affectedProject.getResolvedClasspath(true, false, false), false, false);
                            }
                        }, 2);
                        continue block4;
                    }
                    continue;
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void updateCycleMarkersIfNecessary() {
        if (!this.needCycleCheck) {
            return;
        }
        if (!this.canChangeResources) {
            return;
        }
        if (!this.project.hasCycleMarker() && !this.project.hasClasspathCycle(this.newResolvedPath)) {
            return;
        }
        this.postAction(new JavaModelOperation.IPostAction(){

            public String getID() {
                return "updateCycleMarkers";
            }

            public void run() throws JavaModelException {
                JavaProject.updateAllCycleMarkers(null);
            }
        }, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOutputLocation() throws JavaModelException {
        JavaModelManager.PerProjectInfo perProjectInfo;
        this.beginTask(Util.bind("classpath.settingOutputLocationProgress", this.project.getElementName()), 2);
        IPath oldLocation = this.project.getOutputLocation();
        boolean deltaToFire = false;
        JavaElementDelta delta = this.newJavaElementDelta();
        ArrayList added = this.determineAffectedPackageFragments(oldLocation);
        Iterator iter = added.iterator();
        while (iter.hasNext()) {
            IPackageFragment frag = (IPackageFragment)iter.next();
            ((IPackageFragmentRoot)frag.getParent()).close();
            if (Util.isExcluded(frag)) continue;
            delta.added(frag);
            deltaToFire = true;
        }
        ArrayList removed = this.determineAffectedPackageFragments(this.newOutputLocation);
        iter = removed.iterator();
        while (iter.hasNext()) {
            IPackageFragment frag = (IPackageFragment)iter.next();
            ((IPackageFragmentRoot)frag.getParent()).close();
            if (Util.isExcluded(frag)) continue;
            delta.removed(frag);
            deltaToFire = true;
        }
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = this.project.getPerProjectInfo();
        synchronized (perProjectInfo2) {
            perProjectInfo.outputLocation = this.newOutputLocation;
        }
        if (deltaToFire) {
            this.addDelta(delta);
        }
        this.worked(1);
    }

    protected void updateProjectReferencesIfNecessary() throws JavaModelException {
        if (this.newRawPath == ReuseClasspath || this.newRawPath == UpdateClasspath) {
            return;
        }
        JavaModelManager.getJavaModelManager().deltaState.performClasspathResourceChange(this.project, this.oldResolvedPath, this.newResolvedPath, this.newRawPath, this.canChangeResources);
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.needValidation) {
            IPath outputLocation;
            IClasspathEntry[] entries = this.newRawPath;
            if (entries == ReuseClasspath) {
                try {
                    entries = this.project.getRawClasspath();
                }
                catch (JavaModelException e) {
                    return e.getJavaModelStatus();
                }
            }
            if ((outputLocation = this.newOutputLocation) == ReuseOutputLocation) {
                try {
                    outputLocation = this.project.getOutputLocation();
                }
                catch (JavaModelException e) {
                    return e.getJavaModelStatus();
                }
            }
            return ClasspathEntry.validateClasspath(this.project, entries, outputLocation);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

