/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPageDescriptor;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.SearchResultViewEntryAdapterFactory;
import org.eclipse.search.internal.ui.SorterDescriptor;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SearchPlugin
extends AbstractUIPlugin {
    public static final String SEARCH_PAGE_EXTENSION_POINT = "searchPages";
    public static final String SORTER_EXTENSION_POINT = "searchResultSorters";
    public static final int INTERNAL_ERROR = 1;
    private static SearchPlugin fgSearchPlugin;
    private List fPageDescriptors;
    private List fSorterDescriptors;
    private SearchResultViewEntryAdapterFactory fSearchResultViewEntryAdapterFactory;
    static /* synthetic */ Class class$org$eclipse$search$ui$ISearchResultViewEntry;

    public SearchPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        Assert.isTrue((fgSearchPlugin == null ? 1 : 0) != 0);
        fgSearchPlugin = this;
    }

    public static SearchPlugin getDefault() {
        return fgSearchPlugin;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        SearchPreferencePage.initDefaults(store);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = fgSearchPlugin.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            final WindowRef windowRef = new WindowRef();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    SearchPlugin.setActiveWorkbenchWindow(windowRef);
                }
            });
            return windowRef.window;
        }
        return window;
    }

    private static void setActiveWorkbenchWindow(WindowRef windowRef) {
        windowRef.window = null;
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        for (Shell shell = display.getActiveShell(); shell != null; shell = shell.getParent()) {
            Object data = shell.getData();
            if (!(data instanceof IWorkbenchWindow)) continue;
            windowRef.window = (IWorkbenchWindow)data;
            return;
        }
        Shell[] shells = display.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Object data = shells[i].getData();
            if (!(data instanceof IWorkbenchWindow)) continue;
            windowRef.window = (IWorkbenchWindow)data;
            return;
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = SearchPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void beep() {
        SearchPlugin.getActiveWorkbenchShell().getDisplay().beep();
    }

    public static IWorkbenchPage getActivePage() {
        return SearchPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static boolean activateSearchResultView() {
        String defaultPerspectiveId = SearchUI.getDefaultPerspectiveId();
        if (defaultPerspectiveId != null) {
            IWorkbenchWindow window = SearchPlugin.getActiveWorkbenchWindow();
            if (window != null && window.getShell() != null && !window.getShell().isDisposed()) {
                try {
                    PlatformUI.getWorkbench().showPerspective(defaultPerspectiveId, window);
                }
                catch (WorkbenchException workbenchException) {
                    // empty catch block
                }
            }
        }
        try {
            IViewPart viewPart = SearchPlugin.getActivePage().findView("org.eclipse.search.SearchResultView");
            if (viewPart == null || SearchPreferencePage.isViewBroughtToFront()) {
                return SearchPlugin.getActivePage().showView("org.eclipse.search.SearchResultView") != null;
            }
            return true;
        }
        catch (PartInitException ex) {
            ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.openResultView.title"), SearchMessages.getString("Search.Error.openResultView.message"));
            return false;
        }
    }

    public static ISearchResultView getSearchResultView() {
        IViewPart part = SearchPlugin.getActivePage().findView("org.eclipse.search.SearchResultView");
        if (part instanceof ISearchResultView) {
            return (ISearchResultView)part;
        }
        return null;
    }

    static void setAutoBuilding(boolean state) {
        IWorkspaceDescription workspaceDesc = SearchPlugin.getWorkspace().getDescription();
        workspaceDesc.setAutoBuilding(state);
        try {
            SearchPlugin.getWorkspace().setDescription(workspaceDesc);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.setDescription.title"), SearchMessages.getString("Search.Error.setDescription.message"));
        }
    }

    public void startup() throws CoreException {
        super.startup();
        this.registerAdapters();
    }

    public void shutdown() throws CoreException {
        InternalSearchUI.shutdown();
        this.unregisterAdapters();
        SearchPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)SearchManager.getDefault());
        super.shutdown();
        fgSearchPlugin = null;
    }

    public List getSearchPageDescriptors() {
        if (this.fPageDescriptors == null) {
            IPluginRegistry registry = Platform.getPluginRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.search", SEARCH_PAGE_EXTENSION_POINT);
            this.fPageDescriptors = this.createSearchPageDescriptors(elements);
        }
        return this.fPageDescriptors;
    }

    public List getEnabledSearchPageDescriptors(String pageId) {
        Iterator iter = this.getSearchPageDescriptors().iterator();
        ArrayList<SearchPageDescriptor> enabledDescriptors = new ArrayList<SearchPageDescriptor>(5);
        while (iter.hasNext()) {
            SearchPageDescriptor desc = (SearchPageDescriptor)iter.next();
            if (!desc.isEnabled() && !desc.getId().equals(pageId)) continue;
            enabledDescriptors.add(desc);
        }
        return enabledDescriptors;
    }

    public String getSearchViewHelpContextId() {
        Search currentSearch = SearchManager.getDefault().getCurrentSearch();
        if (currentSearch != null) {
            String pageId = currentSearch.getPageId();
            Iterator iter = this.getSearchPageDescriptors().iterator();
            while (iter.hasNext()) {
                SearchPageDescriptor desc = (SearchPageDescriptor)iter.next();
                if (!desc.getId().equals(pageId)) continue;
                String helpId = desc.getSearchViewHelpContextId();
                if (helpId == null) {
                    return "org.eclipse.search.search_view_context";
                }
                return desc.getSearchViewHelpContextId();
            }
        }
        return "org.eclipse.search.search_view_context";
    }

    private List createSearchPageDescriptors(IConfigurationElement[] elements) {
        ArrayList<SearchPageDescriptor> result = new ArrayList<SearchPageDescriptor>(5);
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (!"page".equals(element.getName())) continue;
            SearchPageDescriptor desc = new SearchPageDescriptor(element);
            result.add(desc);
        }
        Collections.sort(result);
        return result;
    }

    public List getSorterDescriptors() {
        if (this.fSorterDescriptors == null) {
            IPluginRegistry registry = Platform.getPluginRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.search", SORTER_EXTENSION_POINT);
            this.fSorterDescriptors = this.createSorterDescriptors(elements);
        }
        return this.fSorterDescriptors;
    }

    private List createSorterDescriptors(IConfigurationElement[] elements) {
        ArrayList<SorterDescriptor> result = new ArrayList<SorterDescriptor>(5);
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (!"sorter".equals(element.getName())) continue;
            result.add(new SorterDescriptor(element));
        }
        return result;
    }

    public static void log(IStatus status) {
        SearchPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        SearchPlugin.log((IStatus)new Status(4, "org.eclipse.search", 1, SearchMessages.getString("SearchPlugin.internal_error"), e));
    }

    public static String getID() {
        return SearchPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static boolean useNewSearch() {
        return true;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new Separator("group.show"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.removeMatches"));
        menu.add((IContributionItem)new GroupMarker("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    private void registerAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        this.fSearchResultViewEntryAdapterFactory = new SearchResultViewEntryAdapterFactory();
        manager.registerAdapters((IAdapterFactory)this.fSearchResultViewEntryAdapterFactory, class$org$eclipse$search$ui$ISearchResultViewEntry == null ? (class$org$eclipse$search$ui$ISearchResultViewEntry = SearchPlugin.class$("org.eclipse.search.ui.ISearchResultViewEntry")) : class$org$eclipse$search$ui$ISearchResultViewEntry);
    }

    private void unregisterAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fSearchResultViewEntryAdapterFactory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WindowRef {
        public IWorkbenchWindow window;

        private WindowRef() {
        }
    }
}

