/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ltk.internal.ui.refactoring.Assert;

public abstract class AbstractDescriptor {
    protected IConfigurationElement fConfigurationElement;
    protected Expression fExpression;
    protected static final String ID = "id";
    protected static final String OBJECT_STATE = "objectState";
    protected static final String CLASS = "class";

    protected AbstractDescriptor(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    public String getId() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public boolean matches(Object element, String variableName) throws CoreException {
        Assert.isNotNull(element);
        Assert.isNotNull(variableName);
        Expression exp = this.getExpression();
        EvaluationContext evaluationContext = new EvaluationContext(null, element);
        evaluationContext.addVariable(variableName, element);
        return exp.evaluate((IEvaluationContext)evaluationContext) != EvaluationResult.FALSE;
    }

    public Expression getExpression() throws CoreException {
        if (this.fExpression == null) {
            this.fExpression = this.createExpression(this.fConfigurationElement);
        }
        return this.fExpression;
    }

    public void clear() {
        this.fExpression = null;
    }

    protected Expression createExpression(IConfigurationElement element) throws CoreException {
        IConfigurationElement[] children = element.getChildren("enablement");
        if (children.length == 0) {
            return Expression.FALSE;
        }
        Assert.isTrue(children.length == 1);
        return ExpressionConverter.getDefault().perform(children[0]);
    }
}

