/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseResource;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.BaserevInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.NotifyInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class EclipseFile
extends EclipseResource
implements ICVSFile {
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final IPath PROJECT_META_DATA_PATH = new Path(".project");

    protected EclipseFile(IFile file) {
        super((IResource)file);
    }

    public void delete() throws CVSException {
        try {
            ((IFile)this.resource).delete(false, true, null);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(this.resource, Policy.bind("EclipseFile_Problem_deleting_resource", this.resource.getFullPath().toString(), e.getStatus().getMessage()), e);
        }
    }

    public long getSize() {
        return this.getIOFile().length();
    }

    public InputStream getContents() throws CVSException {
        try {
            return this.getIFile().getContents();
        }
        catch (CoreException e) {
            throw CVSException.wrapException(this.resource, Policy.bind("EclipseFile_Problem_accessing_resource", this.resource.getFullPath().toString(), e.getStatus().getMessage()), e);
        }
    }

    public Date getTimeStamp() {
        long timestamp = this.getIFile().getLocalTimeStamp();
        if (timestamp == -1L) {
            return new Date(0L);
        }
        return new Date(timestamp / 1000L * 1000L);
    }

    public void setTimeStamp(Date date) throws CVSException {
        long time = date == null ? System.currentTimeMillis() : date.getTime();
        EclipseSynchronizer.getInstance().setTimeStamp(this, time);
    }

    public boolean isFolder() {
        return false;
    }

    public boolean isModified(IProgressMonitor monitor) throws CVSException {
        byte[] syncBytes;
        if (!this.exists()) {
            return this.getSyncBytes() != null;
        }
        int state = EclipseSynchronizer.getInstance().getModificationState((IResource)this.getIFile());
        if (state != 0) {
            boolean dirty;
            boolean bl = dirty = state != 1;
            if (dirty == this.isDirty()) {
                return dirty;
            }
        }
        if ((syncBytes = this.getSyncBytes()) == null && this.isIgnored()) {
            return false;
        }
        return EclipseSynchronizer.getInstance().setModified(this, 0);
    }

    public void accept(ICVSResourceVisitor visitor) throws CVSException {
        visitor.visitFile(this);
    }

    public void accept(ICVSResourceVisitor visitor, boolean recurse) throws CVSException {
        visitor.visitFile(this);
    }

    public void copyTo(String filename) throws CVSException {
        try {
            Path targetPath = new Path(filename);
            IFile targetFile = this.getIFile().getParent().getFile((IPath)targetPath);
            if (targetFile.exists()) {
                targetFile.delete(false, true, null);
            }
            this.getIFile().copy((IPath)targetPath, true, null);
        }
        catch (CoreException e) {
            throw new CVSException(e.getStatus());
        }
    }

    public String getRemoteLocation(ICVSFolder stopSearching) throws CVSException {
        return this.getParent().getRemoteLocation(stopSearching) + "/" + this.getName();
    }

    public void setContents(InputStream stream, int responseType, boolean keepLocalHistory, IProgressMonitor monitor) throws CVSException {
        try {
            IFile file = this.getIFile();
            if (PROJECT_META_DATA_PATH.equals(file.getFullPath().removeFirstSegments(1))) {
                responseType = 1;
            }
            switch (responseType) {
                case 1: {
                    if (this.resource.exists()) {
                        file.setContents(stream, true, true, monitor);
                        break;
                    }
                }
                case 4: {
                    file.create(stream, false, monitor);
                    break;
                }
                case 2: {
                    IFile tempFile = file.getParent().getFile((IPath)new Path(file.getName() + TEMP_FILE_EXTENSION));
                    monitor.beginTask(null, 100);
                    if (tempFile.exists()) {
                        tempFile.delete(true, Policy.subMonitorFor(monitor, 25));
                    }
                    tempFile.create(stream, true, Policy.subMonitorFor(monitor, 25));
                    file.delete(false, true, Policy.subMonitorFor(monitor, 25));
                    tempFile.move((IPath)new Path(file.getName()), true, false, Policy.subMonitorFor(monitor, 25));
                    monitor.done();
                    break;
                }
                case 3: {
                    file.setContents(stream, true, true, monitor);
                }
            }
        }
        catch (CoreException e) {
            Throwable t;
            String message = null;
            if (e.getStatus().getCode() == 271 && (t = e.getStatus().getException()) != null) {
                message = t.getMessage();
            }
            if (message == null) {
                message = e.getMessage();
            }
            throw CVSException.wrapException(this.resource, Policy.bind("EclipseFile_Problem_writing_resource", this.resource.getFullPath().toString(), message), e);
        }
    }

    public void setReadOnly(boolean readOnly) throws CVSException {
        this.getIFile().setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws CVSException {
        return this.getIFile().isReadOnly();
    }

    public IFile getIFile() {
        return (IFile)this.resource;
    }

    private File getIOFile() {
        IPath location = this.resource.getLocation();
        if (location != null) {
            return location.toFile();
        }
        return null;
    }

    public ILogEntry[] getLogEntries(IProgressMonitor monitor) throws TeamException {
        byte[] syncBytes = this.getSyncBytes();
        if (syncBytes != null && !ResourceSyncInfo.isAddition(syncBytes)) {
            ICVSRemoteResource remoteFile = CVSWorkspaceRoot.getRemoteResourceFor(this.resource);
            return ((ICVSRemoteFile)remoteFile).getLogEntries(monitor);
        }
        return new ILogEntry[0];
    }

    public void setNotifyInfo(NotifyInfo info) throws CVSException {
        if (this.isManaged()) {
            EclipseSynchronizer.getInstance().setNotifyInfo(this.resource, info);
        }
    }

    public NotifyInfo getNotifyInfo() throws CVSException {
        if (this.isManaged()) {
            return EclipseSynchronizer.getInstance().getNotifyInfo(this.resource);
        }
        return null;
    }

    public void setBaserevInfo(BaserevInfo info) throws CVSException {
        if (this.isManaged()) {
            if (info == null) {
                EclipseSynchronizer.getInstance().deleteBaserevInfo(this.resource);
                EclipseSynchronizer.getInstance().deleteFileFromBaseDirectory(this.getIFile(), null);
            } else {
                EclipseSynchronizer.getInstance().setBaserevInfo(this.resource, info);
            }
        }
    }

    public BaserevInfo getBaserevInfo() throws CVSException {
        if (this.isManaged()) {
            return EclipseSynchronizer.getInstance().getBaserevInfo(this.resource);
        }
        return null;
    }

    public void edit(final int notifications, IProgressMonitor monitor) throws CVSException {
        if (!this.isReadOnly()) {
            return;
        }
        this.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                char[] internalFormat;
                byte[] syncBytes = EclipseFile.this.getSyncBytes();
                if (syncBytes == null || ResourceSyncInfo.isAddition(syncBytes)) {
                    return;
                }
                if (notifications == 0) {
                    internalFormat = null;
                } else if (notifications == 7) {
                    internalFormat = NotifyInfo.ALL;
                } else {
                    ArrayList<Character> notificationCharacters = new ArrayList<Character>();
                    if ((notifications & 1) > 0) {
                        notificationCharacters.add(new Character('E'));
                    }
                    if ((notifications & 2) > 0) {
                        notificationCharacters.add(new Character('U'));
                    }
                    if ((notifications & 4) > 0) {
                        notificationCharacters.add(new Character('C'));
                    }
                    internalFormat = new char[notificationCharacters.size()];
                    for (int i = 0; i < internalFormat.length; ++i) {
                        internalFormat[i] = ((Character)notificationCharacters.get(i)).charValue();
                    }
                }
                NotifyInfo notifyInfo = new NotifyInfo(EclipseFile.this.getName(), 'E', new Date(), internalFormat);
                EclipseFile.this.setNotifyInfo(notifyInfo);
                if (!EclipseFile.this.isModified(null)) {
                    EclipseSynchronizer.getInstance().copyFileToBaseDirectory(EclipseFile.this.getIFile(), monitor);
                    EclipseFile.this.setBaserevInfo(new BaserevInfo(EclipseFile.this.getName(), ResourceSyncInfo.getRevision(syncBytes)));
                }
                EclipseFile.this.setReadOnly(false);
            }
        }, monitor);
    }

    public void unedit(IProgressMonitor monitor) throws CVSException {
        if (this.isReadOnly()) {
            return;
        }
        this.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                NotifyInfo info = EclipseFile.this.getNotifyInfo();
                info = info != null && info.getNotificationType() == 'E' ? null : new NotifyInfo(EclipseFile.this.getName(), 'U', new Date(), null);
                EclipseFile.this.setNotifyInfo(info);
                if (EclipseFile.this.isModified(null)) {
                    ResourceSyncInfo syncInfo = EclipseFile.this.getSyncInfo();
                    BaserevInfo baserevInfo = EclipseFile.this.getBaserevInfo();
                    EclipseSynchronizer.getInstance().restoreFileFromBaseDirectory(EclipseFile.this.getIFile(), monitor);
                    if (!syncInfo.getRevision().equals(baserevInfo.getRevision())) {
                        MutableResourceSyncInfo newInfo = syncInfo.cloneMutable();
                        newInfo.setRevision(baserevInfo.getRevision());
                        newInfo.setTimeStamp(EclipseFile.this.getTimeStamp());
                        newInfo.setDeleted(false);
                        EclipseFile.this.setSyncInfo(newInfo, 1);
                    } else {
                        EclipseSynchronizer.getInstance().setModified(EclipseFile.this, 1);
                    }
                } else {
                    EclipseFile.this.setSyncBytes(EclipseFile.this.getSyncBytes(), 1);
                }
                EclipseFile.this.setBaserevInfo(null);
                EclipseFile.this.setReadOnly(true);
            }
        }, monitor);
    }

    public void notificationCompleted() throws CVSException {
        EclipseSynchronizer.getInstance().deleteNotifyInfo(this.resource);
    }

    public NotifyInfo getPendingNotification() throws CVSException {
        return this.getNotifyInfo();
    }

    public void checkedIn(String entryLine) throws CVSException {
        ResourceSyncInfo oldInfo = this.getSyncInfo();
        ResourceSyncInfo newInfo = null;
        int modificationState = 1;
        if (entryLine == null) {
            if (oldInfo == null) {
                return;
            }
            Date timeStamp = oldInfo.getTimeStamp();
            if (timeStamp == null || oldInfo.isMergedWithConflicts()) {
                if (!oldInfo.isAdded()) {
                    MutableResourceSyncInfo mutable = oldInfo.cloneMutable();
                    mutable.setTimeStamp(this.getTimeStamp(), true);
                    newInfo = mutable;
                }
            } else {
                this.setTimeStamp(timeStamp);
            }
        } else if (oldInfo == null) {
            newInfo = new ResourceSyncInfo(entryLine, null, null);
            modificationState = 2;
        } else {
            newInfo = new ResourceSyncInfo(entryLine, oldInfo.getPermissions(), this.getTimeStamp());
        }
        if (newInfo != null) {
            this.setSyncInfo(newInfo, modificationState);
        }
        this.clearCachedBase();
    }

    private void clearCachedBase() throws CVSException {
        BaserevInfo base = this.getBaserevInfo();
        if (base != null) {
            this.setBaserevInfo(null);
            this.setReadOnly(true);
        }
    }

    public void unmanage(IProgressMonitor monitor) throws CVSException {
        this.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                EclipseFile.super.unmanage(monitor);
                EclipseFile.this.clearCachedBase();
            }
        }, monitor);
    }

    public boolean isEdited() throws CVSException {
        return EclipseSynchronizer.getInstance().isEdited(this.getIFile());
    }

    public void setSyncInfo(ResourceSyncInfo info, int modificationState) throws CVSException {
        this.setSyncBytes(info.getBytes(), info, modificationState);
    }

    public void setSyncBytes(byte[] syncBytes, int modificationState) throws CVSException {
        this.setSyncBytes(syncBytes, null, modificationState);
    }

    private void setSyncBytes(byte[] syncBytes, ResourceSyncInfo info, int modificationState) throws CVSException {
        Assert.isNotNull(syncBytes);
        this.setSyncBytes(syncBytes);
        EclipseSynchronizer.getInstance().setModified(this, modificationState);
    }

    public void handleModification(boolean forAddition) throws CVSException {
        if (this.isIgnored()) {
            if (!this.resource.isDerived()) {
                EclipseSynchronizer.getInstance().setModified(this, 1);
            }
            return;
        }
        EclipseSynchronizer.getInstance().setModified(this, 0);
    }

    public String getRepositoryRelativePath() throws CVSException {
        if (!this.isManaged()) {
            return null;
        }
        String parentPath = this.getParent().getRepositoryRelativePath();
        if (parentPath == null) {
            return null;
        }
        return parentPath + "/" + this.getName();
    }

    protected boolean isDirty() throws CVSException {
        boolean dirty;
        byte[] syncBytes = this.getSyncBytes();
        if (syncBytes == null) {
            dirty = this.exists();
        } else if (ResourceSyncInfo.isAddition(syncBytes) || ResourceSyncInfo.isMerge(syncBytes) || !this.exists()) {
            dirty = true;
        } else {
            ResourceSyncInfo info = new ResourceSyncInfo(syncBytes);
            dirty = !this.getTimeStamp().equals(info.getTimeStamp());
        }
        return dirty;
    }
}

