/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.util.TypeFilteringDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorRegistry;

public class FileTypeEditor
extends SelectionAdapter
implements DisposeListener,
SelectionListener {
    private Combo fTextField;
    private Button fBrowseButton;
    static final String TYPE_DELIMITER = SearchMessages.getString("FileTypeEditor.typeDelimiter");

    public FileTypeEditor(IEditorRegistry registry, Combo textField, Button browseButton) {
        this.fTextField = textField;
        this.fBrowseButton = browseButton;
        this.fTextField.addDisposeListener((DisposeListener)this);
        this.fBrowseButton.addDisposeListener((DisposeListener)this);
        this.fBrowseButton.addSelectionListener((SelectionListener)this);
    }

    public void widgetDisposed(DisposeEvent event) {
        Widget widget = event.widget;
        if (widget == this.fTextField) {
            this.fTextField = null;
        } else if (widget == this.fBrowseButton) {
            this.fBrowseButton = null;
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.fBrowseButton) {
            this.handleBrowseButton();
        }
    }

    public void widgetDoubleSelected(SelectionEvent event) {
    }

    public Set getFileTypes() {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.fTextField.getText(), TYPE_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            result.add(currentExtension);
        }
        return result;
    }

    public void setFileTypes(Set types) {
        this.fTextField.setText(FileTypeEditor.typesToString(types));
    }

    protected void handleBrowseButton() {
        TypeFilteringDialog dialog = new TypeFilteringDialog(this.fTextField.getShell(), this.getFileTypes());
        if (dialog.open() == 0) {
            this.setFileTypes(new HashSet<Object>(Arrays.asList(dialog.getResult())));
        }
    }

    public static String typesToString(Set types) {
        StringBuffer result = new StringBuffer();
        Iterator typesIter = types.iterator();
        boolean first = true;
        while (typesIter.hasNext()) {
            if (!first) {
                result.append(TYPE_DELIMITER);
                result.append(" ");
            } else {
                first = false;
            }
            result.append(typesIter.next());
        }
        return result.toString();
    }
}

