/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class CodeTemplateContextType
extends TemplateContextType {
    public static final String CATCHBLOCK_CONTEXTTYPE = "catchblock_context";
    public static final String METHODBODY_CONTEXTTYPE = "methodbody_context";
    public static final String CONSTRUCTORBODY_CONTEXTTYPE = "constructorbody_context";
    public static final String GETTERBODY_CONTEXTTYPE = "getterbody_context";
    public static final String SETTERBODY_CONTEXTTYPE = "setterbody_context";
    public static final String NEWTYPE_CONTEXTTYPE = "newtype_context";
    public static final String TYPECOMMENT_CONTEXTTYPE = "typecomment_context";
    public static final String FIELDCOMMENT_CONTEXTTYPE = "fieldcomment_context";
    public static final String METHODCOMMENT_CONTEXTTYPE = "methodcomment_context";
    public static final String CONSTRUCTORCOMMENT_CONTEXTTYPE = "constructorcomment_context";
    public static final String OVERRIDECOMMENT_CONTEXTTYPE = "overridecomment_context";
    public static final String GETTERCOMMENT_CONTEXTTYPE = "gettercomment_context";
    public static final String SETTERCOMMENT_CONTEXTTYPE = "settercomment_context";
    public static final String COMMENT_SUFFIX = "comment";
    public static final String CATCHBLOCK = "catchblock";
    public static final String METHODSTUB = "methodbody";
    public static final String NEWTYPE = "newtype";
    public static final String CONSTRUCTORSTUB = "constructorbody";
    public static final String GETTERSTUB = "getterbody";
    public static final String SETTERSTUB = "setterbody";
    public static final String TYPECOMMENT = "typecomment";
    public static final String FIELDCOMMENT = "fieldcomment";
    public static final String METHODCOMMENT = "methodcomment";
    public static final String CONSTRUCTORCOMMENT = "constructorcomment";
    public static final String OVERRIDECOMMENT = "overridecomment";
    public static final String GETTERCOMMENT = "gettercomment";
    public static final String SETTERCOMMENT = "settercomment";
    public static final String EXCEPTION_TYPE = "exception_type";
    public static final String EXCEPTION_VAR = "exception_var";
    public static final String ENCLOSING_METHOD = "enclosing_method";
    public static final String ENCLOSING_TYPE = "enclosing_type";
    public static final String BODY_STATEMENT = "body_statement";
    public static final String FIELD = "field";
    public static final String FIELD_TYPE = "field_type";
    public static final String BARE_FIELD_NAME = "bare_field_name";
    public static final String PARAM = "param";
    public static final String RETURN_TYPE = "return_type";
    public static final String SEE_TAG = "see_to_overridden";
    public static final String TAGS = "tags";
    public static final String TYPENAME = "type_name";
    public static final String FILENAME = "file_name";
    public static final String PACKAGENAME = "package_name";
    public static final String PROJECTNAME = "project_name";
    public static final String PACKAGE_DECLARATION = "package_declaration";
    public static final String TYPE_DECLARATION = "type_declaration";
    public static final String TYPE_COMMENT = "typecomment";
    private boolean fIsComment = false;

    public CodeTemplateContextType(String contextName) {
        super(contextName);
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver(new Todo());
        if (CATCHBLOCK_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(EXCEPTION_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.exceptiontype")));
            this.addResolver(new CodeTemplateVariableResolver(EXCEPTION_VAR, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.exceptionvar")));
        } else if (METHODBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addResolver(new CodeTemplateVariableResolver(BODY_STATEMENT, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.bodystatement")));
        } else if (CONSTRUCTORBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new CodeTemplateVariableResolver(BODY_STATEMENT, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.bodystatement")));
        } else if (GETTERBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.getterfieldname")));
        } else if (SETTERBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.getterfieldname")));
            this.addResolver(new CodeTemplateVariableResolver(PARAM, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.param")));
        } else if (NEWTYPE_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(TYPENAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.typename")));
            this.addResolver(new CodeTemplateVariableResolver(PACKAGE_DECLARATION, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.packdeclaration")));
            this.addResolver(new CodeTemplateVariableResolver(TYPE_DECLARATION, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.typedeclaration")));
            this.addResolver(new CodeTemplateVariableResolver("typecomment", JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.typecomment")));
            this.addCompilationUnitVariables();
        } else if (TYPECOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(TYPENAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.typename")));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (FIELDCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(FIELD_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.fieldtype")));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.fieldname")));
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (METHODCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addResolver(new CodeTemplateVariableResolver(RETURN_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.returntype")));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (OVERRIDECOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addResolver(new CodeTemplateVariableResolver(SEE_TAG, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.seetag")));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (CONSTRUCTORCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (GETTERCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new CodeTemplateVariableResolver(FIELD_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.getterfieldtype")));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.getterfieldname")));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addResolver(new CodeTemplateVariableResolver(BARE_FIELD_NAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.barefieldname")));
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (SETTERCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addResolver(new CodeTemplateVariableResolver(FIELD_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.getterfieldtype")));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.getterfieldname")));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addResolver(new CodeTemplateVariableResolver(PARAM, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.param")));
            this.addResolver(new CodeTemplateVariableResolver(BARE_FIELD_NAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.barefieldname")));
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        }
    }

    private void addCompilationUnitVariables() {
        this.addResolver(new CodeTemplateVariableResolver(FILENAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.filename")));
        this.addResolver(new CodeTemplateVariableResolver(PACKAGENAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.packagename")));
        this.addResolver(new CodeTemplateVariableResolver(PROJECTNAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.projectname")));
    }

    protected void validateVariables(TemplateVariable[] variables) throws TemplateException {
        ArrayList<String> required = new ArrayList<String>(5);
        String contextName = this.getId();
        if (NEWTYPE_CONTEXTTYPE.equals(contextName)) {
            required.add(PACKAGE_DECLARATION);
            required.add(TYPE_DECLARATION);
        }
        for (int i = 0; i < variables.length; ++i) {
            String type = variables[i].getType();
            if (this.getResolver(type) == null) {
                throw new TemplateException(JavaTemplateMessages.getFormattedString("CodeTemplateContextType.validate.unknownvariable", type));
            }
            required.remove(type);
        }
        if (!required.isEmpty()) {
            String missing = (String)required.get(0);
            throw new TemplateException(JavaTemplateMessages.getFormattedString("CodeTemplateContextType.validate.missingvariable", missing));
        }
        super.validateVariables(variables);
    }

    public TemplateContext createContext() {
        return null;
    }

    public static void registerContextTypes(ContextTypeRegistry registry) {
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(CATCHBLOCK_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(METHODBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(CONSTRUCTORBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(GETTERBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(SETTERBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(NEWTYPE_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(TYPECOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(FIELDCOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(METHODCOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(CONSTRUCTORCOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(OVERRIDECOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(GETTERCOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(SETTERCOMMENT_CONTEXTTYPE));
    }

    public void validate(String pattern) throws TemplateException {
        super.validate(pattern);
        if (this.fIsComment && !this.isValidComment(pattern)) {
            throw new TemplateException(JavaTemplateMessages.getString("CodeTemplateContextType.validate.invalidcomment"));
        }
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (next == 1001 || next == 1003 || next == 1002) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    protected static class Todo
    extends TemplateVariableResolver {
        public Todo() {
            super("todo", JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.todo"));
        }

        protected String resolve(TemplateContext context) {
            String todoTaskTag = StubUtility.getTodoTaskTag(((CodeTemplateContext)context).getJavaProject());
            if (todoTaskTag == null) {
                return "XXX";
            }
            return todoTaskTag;
        }
    }

    public static class TagsVariableResolver
    extends TemplateVariableResolver {
        public TagsVariableResolver() {
            super(CodeTemplateContextType.TAGS, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.tags"));
        }

        protected String resolve(TemplateContext context) {
            return "@";
        }
    }

    public static class CodeTemplateVariableResolver
    extends TemplateVariableResolver {
        public CodeTemplateVariableResolver(String type, String description) {
            super(type, description);
        }

        protected String resolve(TemplateContext context) {
            return context.getVariable(this.getType());
        }
    }
}

