/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistry;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistryReader;
import org.eclipse.ui.part.FileEditorInput;

public final class IDE {
    public static final QualifiedName EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    public static final String EDITOR_ID_ATTR = "org.eclipse.ui.editorID";
    public static final String RESOURCE_PERSPECTIVE_ID = "org.eclipse.ui.resourcePerspective";
    private static MarkerHelpRegistry markerHelpRegistry = null;
    private static final List emptyUnmodifiableList = Collections.unmodifiableList(new ArrayList(0));
    static /* synthetic */ Class class$org$eclipse$ui$ide$IGotoMarker;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    private IDE() {
    }

    public static IMarkerHelpRegistry getMarkerHelpRegistry() {
        if (markerHelpRegistry == null) {
            markerHelpRegistry = new MarkerHelpRegistry();
            new MarkerHelpRegistryReader().addHelp(markerHelpRegistry);
        }
        return markerHelpRegistry;
    }

    public static void gotoMarker(IEditorPart editor, IMarker marker) {
        IGotoMarker gotoMarker = null;
        gotoMarker = editor instanceof IGotoMarker ? (IGotoMarker)editor : (IGotoMarker)editor.getAdapter(class$org$eclipse$ui$ide$IGotoMarker == null ? (class$org$eclipse$ui$ide$IGotoMarker = IDE.class$("org.eclipse.ui.ide.IGotoMarker")) : class$org$eclipse$ui$ide$IGotoMarker);
        if (gotoMarker != null) {
            gotoMarker.gotoMarker(marker);
        }
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String editorId) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor(input, editorId);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String editorId, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor(input, editorId, activate);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor editorDesc = IDE.getEditorDescriptor(input);
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorDesc.getId(), activate);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor editorDesc = IDE.getEditorDescriptor(input);
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorDesc.getId());
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, String editorId) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorId);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, String editorId, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorId, activate);
    }

    public static IEditorDescriptor getEditorDescriptor(IFile file) throws PartInitException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = IDE.getDefaultEditor(file);
        if (editorDesc == null && editorReg.isSystemInPlaceEditorAvailable(file.getName())) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDesc == null && editorReg.isSystemExternalEditorAvailable(file.getName())) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDesc == null) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (editorDesc == null) {
            throw new PartInitException(IDEWorkbenchMessages.getString("IDE.noFileEditorFound"));
        }
        return editorDesc;
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IMarker marker) throws PartInitException {
        return IDE.openEditor(page, marker, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IMarker marker, boolean activate) throws PartInitException {
        if (page == null || marker == null) {
            throw new IllegalArgumentException();
        }
        if (!(marker.getResource() instanceof IFile)) {
            IDEWorkbenchPlugin.log("Open editor on marker failed; marker resource not an IFile");
            return null;
        }
        IFile file = (IFile)marker.getResource();
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = null;
        try {
            String editorID = (String)marker.getAttribute(EDITOR_ID_ATTR);
            if (editorID != null) {
                editorDesc = editorReg.findEditor(editorID);
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
        IEditorPart editor = null;
        editor = editorDesc == null ? IDE.openEditor(page, file, activate) : page.openEditor((IEditorInput)new FileEditorInput(file), editorDesc.getId(), activate);
        if (editor != null) {
            IDE.gotoMarker(editor, marker);
        }
        return editor;
    }

    public static boolean saveAllEditors(IResource[] resourceRoots, boolean confirm) {
        final IResource[] finalResources = resourceRoots;
        final boolean finalConfirm = confirm;
        final boolean[] result = new boolean[]{true};
        if (resourceRoots.length == 0) {
            return result[0];
        }
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.getString((String)"ErrorClosing")){

            public void run() {
                ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                for (int i = 0; i < windows.length; ++i) {
                    IWorkbenchWindow window = windows[i];
                    IWorkbenchPage[] pages = window.getPages();
                    for (int j = 0; j < pages.length; ++j) {
                        IWorkbenchPage page = pages[j];
                        IEditorPart[] dirty = page.getDirtyEditors();
                        block2: for (int k = 0; k < dirty.length; ++k) {
                            IEditorPart part = dirty[k];
                            IFile file = (IFile)part.getEditorInput().getAdapter(class$org$eclipse$core$resources$IFile == null ? IDE.class$("org.eclipse.core.resources.IFile") : class$org$eclipse$core$resources$IFile);
                            if (file == null) continue;
                            for (int l = 0; l < finalResources.length; ++l) {
                                IResource resource = finalResources[l];
                                if (!resource.getFullPath().isPrefixOf(file.getFullPath())) continue;
                                dirtyEditors.add(part);
                                continue block2;
                            }
                        }
                    }
                }
                if (dirtyEditors.size() > 0) {
                    IWorkbenchWindow w = Workbench.getInstance().getActiveWorkbenchWindow();
                    if (w == null) {
                        w = windows[0];
                    }
                    result[0] = EditorManager.saveAll(dirtyEditors, (boolean)finalConfirm, (IWorkbenchWindow)w);
                }
            }
        });
        return result[0];
    }

    public static void setDefaultEditor(IFile file, String editorID) {
        try {
            file.setPersistentProperty(EDITOR_KEY, editorID);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static IEditorDescriptor getDefaultEditor(IFile file) {
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        try {
            IEditorDescriptor desc;
            String editorID = file.getPersistentProperty(EDITOR_KEY);
            if (editorID != null && (desc = editorReg.findEditor(editorID)) != null) {
                return desc;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return editorReg.getDefaultEditor(file.getName());
    }

    public static List computeSelectedResources(IStructuredSelection originalSelection) {
        ArrayList<Object> resources = null;
        Iterator e = originalSelection.iterator();
        while (e.hasNext()) {
            Object next = e.next();
            Object resource = null;
            if (next instanceof IResource) {
                resource = next;
            } else if (next instanceof IAdaptable) {
                resource = ((IAdaptable)next).getAdapter(class$org$eclipse$core$resources$IResource == null ? IDE.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
            }
            if (resource == null) continue;
            if (resources == null) {
                resources = new ArrayList<Object>(originalSelection.size());
            }
            resources.add(resource);
        }
        if (resources == null) {
            return emptyUnmodifiableList;
        }
        return resources;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Preferences {
        public static final String PROJECT_OPEN_NEW_PERSPECTIVE = "PROJECT_OPEN_NEW_PERSPECTIVE";
    }

    public static interface SharedImages {
        public static final String IMG_OBJ_PROJECT = "IMG_OBJ_PROJECT";
        public static final String IMG_OBJ_PROJECT_CLOSED = "IMG_OBJ_PROJECT_CLOSED";
        public static final String IMG_OPEN_MARKER = "IMG_OPEN_MARKER";
        public static final String IMG_OBJS_TASK_TSK = "IMG_OBJS_TASK_TSK";
        public static final String IMG_OBJS_BKMRK_TSK = "IMG_OBJS_BKMRK_TSK";
    }
}

