/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.ZipFileSet;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;

public class AssembleConfigScriptGenerator
extends AbstractScriptGenerator {
    protected String directory;
    protected String featureId;
    protected Config configInfo;
    protected IFeature[] features;
    protected BundleDescription[] plugins;
    protected String filename;
    protected Collection rootFileProviders;
    protected Properties pluginsPostProcessingSteps;
    protected Properties featuresPostProcessingSteps;
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_ELEMENT_NAME = "elementName";
    private static final String UPDATEJAR = "updateJar";
    private static final String FLAT = "flat";
    private static final byte BUNDLE = 0;
    private static final byte FEATURE = 1;
    private static final String FOLDER = "folder";
    private static final String FILE = "file";
    private String PROPERTY_ECLIPSE_PLUGINS = "eclipse.plugins";
    private String PROPERTY_ECLIPSE_FEATURES = "eclipse.features";

    public void initialize(String directoryName, String scriptName, String feature, Config configurationInformation, Collection elementList, Collection featureList, Collection rootFileProviders) throws CoreException {
        this.directory = directoryName;
        this.featureId = feature;
        this.configInfo = configurationInformation;
        this.rootFileProviders = rootFileProviders;
        this.features = new IFeature[featureList.size()];
        featureList.toArray(this.features);
        this.plugins = new BundleDescription[elementList.size()];
        this.plugins = elementList.toArray(this.plugins);
        this.filename = this.directory + '/' + (scriptName != null ? scriptName : this.getFilename());
        try {
            this.script = new AntScript(new FileOutputStream(this.filename));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writingFile", this.filename);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        this.loadPostProcessingSteps();
    }

    private void loadPostProcessingSteps() throws CoreException {
        try {
            this.pluginsPostProcessingSteps = AssembleConfigScriptGenerator.readProperties(AbstractScriptGenerator.getWorkingDirectory(), "plugins.postProcessingSteps.properties", 1);
            this.featuresPostProcessingSteps = AssembleConfigScriptGenerator.readProperties(AbstractScriptGenerator.getWorkingDirectory(), "features.PostProcessingSteps.properties", 1);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void generate() throws CoreException {
        this.generatePrologue();
        this.generateInitializationSteps();
        this.generateGatherBinPartsCalls();
        if (embeddedSource) {
            this.generateGatherSourceCalls();
        }
        this.generatePostProcessingSteps();
        if (!outputFormat.equalsIgnoreCase(FOLDER)) {
            if (this.configInfo.getOs().equalsIgnoreCase("macosx") && !Platform.getOS().equals("win32")) {
                this.generateTarTarget();
                this.generateGZipTarget();
            } else if (outputFormat.equalsIgnoreCase("zip")) {
                this.generateZipTarget();
            } else {
                this.generateAntZipTarget();
            }
        }
        this.generateEpilogue();
    }

    private void generateGatherSourceCalls() throws CoreException {
        String placeToGather;
        int i;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("destination.temp.folder", this.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS));
        for (i = 0; i < this.plugins.length; ++i) {
            BundleDescription plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.sources", null, null, properties);
        }
        properties = new HashMap(1);
        properties.put("feature.base", this.getPropertyFormat("eclipse.base"));
        for (i = 0; i < this.features.length; ++i) {
            IFeature feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            int j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.sources", null, null, properties);
        }
    }

    private void generatePackagingTargets() {
        String fileName = this.getPropertyFormat(PROPERTY_SOURCE) + '/' + this.getPropertyFormat(PROPERTY_ELEMENT_NAME);
        String fileExists = this.getPropertyFormat(PROPERTY_SOURCE) + '/' + this.getPropertyFormat(PROPERTY_ELEMENT_NAME) + "_exists";
        this.script.printComment("Beginning of the jarUp task");
        this.script.printTargetDeclaration("jarUp", null, null, null, Policy.bind("assemble.jarUp"));
        this.script.printAvailableTask(fileExists, fileName);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put(PROPERTY_SOURCE, this.getPropertyFormat(PROPERTY_SOURCE));
        params.put(PROPERTY_ELEMENT_NAME, this.getPropertyFormat(PROPERTY_ELEMENT_NAME));
        this.script.printAntCallTask("jarIng", null, params);
        this.script.printTargetEnd();
        this.script.printTargetDeclaration("jarIng", null, fileExists, null, null);
        this.script.printZipTask(fileName + ".jar", fileName, false, false, null);
        this.script.printDeleteTask(fileName, null, null);
        this.script.printTargetEnd();
        this.script.printComment("End of the jarUp task");
    }

    private void generateGZipTarget() {
        this.script.println("<move file=\"" + this.getPropertyFormat("archiveFullPath") + "\" tofile=\"" + this.getPropertyFormat("assemblyTempDir") + '/' + this.getPropertyFormat("collectingFolder") + "/tmp.tar\"/>");
        this.script.printGZip(this.getPropertyFormat("assemblyTempDir") + '/' + this.getPropertyFormat("collectingFolder") + "/tmp.tar", this.getPropertyFormat("archiveFullPath"));
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("-rf");
        args.add(this.getPropertyFormat("assemblyTempDir"));
        this.script.printExecTask("rm", null, args, null);
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration("Assemble " + this.featureId, "main", null);
        this.script.printProperty("archiveName", this.computeArchiveName());
        this.script.printProperty("os", this.configInfo.getOs());
        this.script.printProperty("ws", this.configInfo.getWs());
        this.script.printProperty("arch", this.configInfo.getArch());
        this.script.printProperty("assemblyTempDir", this.getPropertyFormat("buildDirectory") + "/tmp");
        this.script.printProperty("eclipse.base", this.getPropertyFormat("assemblyTempDir") + '/' + this.getPropertyFormat("collectingFolder"));
        this.script.printProperty(this.PROPERTY_ECLIPSE_PLUGINS, this.getPropertyFormat("eclipse.base") + '/' + "plugins");
        this.script.printProperty(this.PROPERTY_ECLIPSE_FEATURES, this.getPropertyFormat("eclipse.base") + '/' + "features");
        this.script.printProperty("archiveFullPath", this.getPropertyFormat("basedir") + '/' + this.getPropertyFormat("buildLabel") + '/' + this.getPropertyFormat("archiveName"));
        this.generatePackagingTargets();
        this.script.printTargetDeclaration("main", null, null, null, null);
    }

    private void generateInitializationSteps() {
        if (BundleHelper.getDefault().isDebugging()) {
            this.script.printEchoTask("basedir : " + this.getPropertyFormat("basedir"));
            this.script.printEchoTask("assemblyTempDir : " + this.getPropertyFormat("assemblyTempDir"));
            this.script.printEchoTask("eclipse.base : " + this.getPropertyFormat("eclipse.base"));
            this.script.printEchoTask("collectingFolder : " + this.getPropertyFormat("collectingFolder"));
            this.script.printEchoTask("archivePrefix : " + this.getPropertyFormat("archivePrefix"));
        }
        this.script.println("<condition property=\"pluginArchivePrefix\" value=\"plugins\">");
        this.script.println("\t<equals arg1=\"" + this.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("pluginArchivePrefix", this.getPropertyFormat("archivePrefix") + '/' + "plugins");
        this.script.println();
        this.script.println("<condition property=\"featureArchivePrefix\" value=\"features\">");
        this.script.println("\t<equals arg1=\"" + this.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("featureArchivePrefix", this.getPropertyFormat("archivePrefix") + '/' + "features");
        this.script.println();
        if (!FOLDER.equalsIgnoreCase(outputFormat)) {
            this.script.printDeleteTask(this.getPropertyFormat("assemblyTempDir"), null, null);
        }
        this.script.printDirName("archiveParentFolder", this.getPropertyFormat("archiveFullPath"));
        this.script.printMkdirTask(this.getPropertyFormat("archiveParentFolder"));
        this.script.printMkdirTask(this.getPropertyFormat("assemblyTempDir"));
        this.script.printMkdirTask(this.getPropertyFormat("buildLabel"));
    }

    private void generatePostProcessingSteps() throws CoreException {
        int i;
        for (i = 0; i < this.plugins.length; ++i) {
            BundleDescription plugin = this.plugins[i];
            if (forceUpdateJarFormat) {
                this.pluginsPostProcessingSteps.put(plugin.getSymbolicName(), UPDATEJAR);
            }
            this.generatePostProcessingSteps(plugin.getSymbolicName(), plugin.getVersion().toString(), (byte)0);
        }
        for (i = 0; i < this.features.length; ++i) {
            IFeature feature = this.features[i];
            if (forceUpdateJarFormat) {
                this.featuresPostProcessingSteps.put(feature.getVersionedIdentifier().getIdentifier(), UPDATEJAR);
            }
            this.generatePostProcessingSteps(feature.getVersionedIdentifier().getIdentifier(), feature.getVersionedIdentifier().getVersion().toString(), (byte)1);
        }
    }

    private void generateGatherBinPartsCalls() throws CoreException {
        int j;
        IFeature feature;
        String placeToGather;
        int i;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("destination.temp.folder", this.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS));
        for (i = 0; i < this.plugins.length; ++i) {
            BundleDescription plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
        }
        properties = new HashMap(1);
        properties.put("feature.base", this.getPropertyFormat("eclipse.base"));
        for (i = 0; i < this.features.length; ++i) {
            feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
        }
        properties = new HashMap(1);
        properties.put("feature.base", this.getPropertyFormat("eclipse.base"));
        Iterator iter = this.rootFileProviders.iterator();
        while (iter.hasNext()) {
            feature = (IFeature)iter.next();
            placeToGather = feature.getURL().getPath();
            j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
        }
    }

    private void generatePostProcessingSteps(String name, String version, byte type) {
        String style = (String)this.getFinalShape(name, version, type)[1];
        if (FOLDER.equalsIgnoreCase(style)) {
            return;
        }
        if (FILE.equalsIgnoreCase(style)) {
            this.generateJarUpCall(name, version, type);
            return;
        }
    }

    private String getPluginUnpackClause(String name, String version) {
        for (int i = 0; i < this.features.length; ++i) {
            IPluginEntry[] entries = this.features[i].getPluginEntries();
            for (int j = 0; j < entries.length; ++j) {
                if (!entries[j].getVersionedIdentifier().getIdentifier().equals(name)) continue;
                return ((PluginEntry)entries[j]).isUnpack() ? FLAT : UPDATEJAR;
            }
        }
        return FLAT;
    }

    private Object[] getFinalShape(String name, String version, byte type) {
        Properties currentProperties;
        String style = this.getPluginUnpackClause(name, version);
        Properties properties = currentProperties = type == 0 ? this.pluginsPostProcessingSteps : this.featuresPostProcessingSteps;
        if (currentProperties.size() != 0) {
            String styleFromFile = currentProperties.getProperty(name);
            if (styleFromFile == null) {
                styleFromFile = currentProperties.getProperty("*");
            }
            style = styleFromFile;
        }
        if (FLAT.equalsIgnoreCase(style)) {
            return new Object[]{name + '_' + version, FOLDER};
        }
        if (UPDATEJAR.equalsIgnoreCase(style)) {
            return new Object[]{name + '_' + version + ".jar", FILE};
        }
        return new Object[]{name + '_' + version, FOLDER};
    }

    private void generateJarUpCall(String name, String version, byte type) {
        HashMap<String, String> properties = new HashMap<String, String>(2);
        properties.put(PROPERTY_SOURCE, type == 0 ? this.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS) : this.getPropertyFormat(this.PROPERTY_ECLIPSE_FEATURES));
        properties.put(PROPERTY_ELEMENT_NAME, name + '_' + version);
        this.script.printAntCallTask("jarUp", null, properties);
    }

    private void generateEpilogue() {
        this.script.printTargetEnd();
        this.script.printProjectEnd();
        this.script.close();
    }

    public String getFilename() {
        return this.getTargetName() + ".xml";
    }

    public String getTargetName() {
        return "assemble" + (this.featureId.equals("") ? "" : '.' + this.featureId) + (this.configInfo.equals(Config.genericConfig()) ? "" : '.' + this.configInfo.toStringReplacingAny(".", "ANY"));
    }

    private void generateZipTarget() {
        int i;
        int parameterSize = 15;
        ArrayList<String> parameters = new ArrayList<String>(16);
        for (i = 0; i < this.plugins.length; ++i) {
            parameters.add(this.getPropertyFormat("pluginArchivePrefix") + '/' + (String)this.getFinalShape(this.plugins[i].getSymbolicName(), this.plugins[i].getVersion().toString(), (byte)0)[0]);
            if (i % 15 != 0) continue;
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        for (i = 0; i < this.features.length; ++i) {
            parameters.add(this.getPropertyFormat("featureArchivePrefix") + '/' + (String)this.getFinalShape(this.features[i].getVersionedIdentifier().getIdentifier(), this.features[i].getVersionedIdentifier().getVersion().toString(), (byte)1)[0]);
            if (i % 15 != 0) continue;
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        this.createZipRootFileCommand();
    }

    private void createZipRootFileCommand() {
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        ArrayList<String> parameters = new ArrayList<String>(1);
        parameters.add("-r -q ${zipargs} " + this.getPropertyFormat("archiveFullPath") + " . ");
        this.script.printExecTask("zip", this.getPropertyFormat("eclipse.base") + '/' + this.configInfo.toStringReplacingAny(".", "ANY"), parameters, null);
    }

    private void createZipExecCommand(List parameters) {
        parameters.add(0, "-r -q " + this.getPropertyFormat("zipargs") + " " + this.getPropertyFormat("archiveFullPath"));
        this.script.printExecTask("zip", this.getPropertyFormat("assemblyTempDir"), parameters, null);
    }

    protected String computeArchiveName() {
        return this.featureId + "-" + this.getPropertyFormat("buildId") + (this.configInfo.equals(Config.genericConfig()) ? "" : "-" + this.configInfo.toStringReplacingAny(".", "ANY")) + ".zip";
    }

    public void generateTarTarget() {
        ArrayList<String> parameters = new ArrayList<String>(2);
        if (this.rootFileProviders.size() > 0) {
            parameters.add("-r " + this.getPropertyFormat("assemblyTempDir") + '/' + this.getPropertyFormat("collectingFolder") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + this.getPropertyFormat("collectingFolder") + ' ' + this.getPropertyFormat("assemblyTempDir"));
            this.script.printExecTask("cp", this.getPropertyFormat("basedir"), parameters, null);
            parameters.clear();
            parameters.add("-rf " + this.getPropertyFormat("assemblyTempDir") + '/' + this.getPropertyFormat("collectingFolder") + '/' + this.configInfo.toStringReplacingAny(".", "ANY"));
            this.script.printExecTask("rm", this.getPropertyFormat("basedir"), parameters, null);
        }
        parameters.clear();
        parameters.add("-cvf " + this.getPropertyFormat("archiveFullPath") + ' ' + this.getPropertyFormat("archivePrefix") + ' ');
        this.script.printExecTask("tar", this.getPropertyFormat("assemblyTempDir"), parameters, null);
    }

    private void generateAntZipTarget() {
        FileSet[] filesPlugins = new FileSet[this.plugins.length];
        for (int i = 0; i < this.plugins.length; ++i) {
            Object[] shape = this.getFinalShape(this.plugins[i].getSymbolicName(), this.plugins[i].getVersion().toString(), (byte)0);
            filesPlugins[i] = new ZipFileSet(this.getPropertyFormat("eclipse.base") + '/' + "plugins" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, this.getPropertyFormat("pluginArchivePrefix") + '/' + (String)shape[0], null);
        }
        if (this.plugins.length != 0) {
            this.script.printZipTask(this.getPropertyFormat("archiveFullPath"), null, false, true, filesPlugins);
        }
        FileSet[] filesFeatures = new FileSet[this.features.length];
        for (int i = 0; i < this.features.length; ++i) {
            Object[] shape = this.getFinalShape(this.features[i].getVersionedIdentifier().getIdentifier(), this.features[i].getVersionedIdentifier().getVersion().toString(), (byte)1);
            filesFeatures[i] = new ZipFileSet(this.getPropertyFormat("eclipse.base") + '/' + "features" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, this.getPropertyFormat("featureArchivePrefix") + '/' + (String)shape[0], null);
        }
        if (this.features.length != 0) {
            this.script.printZipTask(this.getPropertyFormat("archiveFullPath"), null, false, true, filesFeatures);
        }
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        FileSet[] rootFiles = new FileSet[]{new ZipFileSet(this.getPropertyFormat("eclipse.base") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + this.getPropertyFormat("collectingFolder"), false, null, "**/**", null, null, null, this.getPropertyFormat("archivePrefix"), null)};
        this.script.printZipTask(this.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
    }
}

