/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dq<K, V> {
    private final LinkedHashMap<K, V> lm;
    private int size;
    private int ln;
    private int lo;
    private int lp;
    private int lq;
    private int lr;
    private int ls;

    public dq(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.ln = n2;
        this.lm = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        dq<K, V> dq2 = this;
        synchronized (dq2) {
            object = this.lm.get(key);
            if (object != null) {
                ++this.lr;
                return object;
            }
            ++this.ls;
        }
        dq2 = this.create(key);
        if (dq2 == null) {
            return null;
        }
        dq dq3 = this;
        synchronized (dq3) {
            ++this.lp;
            object = this.lm.put(key, dq2);
            if (object != null) {
                this.lm.put(key, object);
            } else {
                this.size += this.b(key, dq2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, dq2, object);
            return object;
        }
        this.trimToSize(this.ln);
        return (V)dq2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        dq dq2 = this;
        synchronized (dq2) {
            ++this.lo;
            this.size += this.b(key, value);
            v2 = this.lm.put(key, value);
            if (v2 != null) {
                this.size -= this.b(key, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, key, v2, value);
        }
        this.trimToSize(this.ln);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v2;
            K k2;
            dq dq2 = this;
            synchronized (dq2) {
                if (this.size < 0 || this.lm.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.lm.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.lm.entrySet().iterator().next();
                k2 = entry.getKey();
                v2 = entry.getValue();
                this.lm.remove(k2);
                this.size -= this.b(k2, v2);
                ++this.lq;
            }
            this.entryRemoved(true, k2, v2, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int b(K k2, V v2) {
        int n2 = this.sizeOf(k2, v2);
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + k2 + "=" + v2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n2 = this.lr + this.ls;
        int n3 = n2 != 0 ? 100 * this.lr / n2 : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.ln, this.lr, this.ls, n3);
    }
}

