/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.en;

public final class GameEntity
extends en
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new a();
    private final int iM;
    private final String mk;
    private final String ml;
    private final String mm;
    private final String mn;
    private final String mo;
    private final String mp;
    private final Uri mq;
    private final Uri mr;
    private final Uri ms;
    private final boolean mt;
    private final boolean mu;
    private final String mv;
    private final int mw;
    private final int mx;
    private final int my;

    public GameEntity(Game game) {
        this.iM = 1;
        this.mk = game.getApplicationId();
        this.mm = game.getPrimaryCategory();
        this.mn = game.getSecondaryCategory();
        this.mo = game.getDescription();
        this.mp = game.getDeveloperName();
        this.ml = game.getDisplayName();
        this.mq = game.getIconImageUri();
        this.mr = game.getHiResImageUri();
        this.ms = game.getFeaturedImageUri();
        this.mt = game.isPlayEnabledGame();
        this.mu = game.isInstanceInstalled();
        this.mv = game.getInstancePackageName();
        this.mw = game.getGameplayAclStatus();
        this.mx = game.getAchievementTotalCount();
        this.my = game.getLeaderboardCount();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount) {
        this.iM = versionCode;
        this.mk = applicationId;
        this.ml = displayName;
        this.mm = primaryCategory;
        this.mn = secondaryCategory;
        this.mo = description;
        this.mp = developerName;
        this.mq = iconImageUri;
        this.mr = hiResImageUri;
        this.ms = featuredImageUri;
        this.mt = playEnabledGame;
        this.mu = instanceInstalled;
        this.mv = instancePackageName;
        this.mw = gameplayAclStatus;
        this.mx = achievementTotalCount;
        this.my = leaderboardCount;
    }

    public int getVersionCode() {
        return this.iM;
    }

    public String getApplicationId() {
        return this.mk;
    }

    public String getDisplayName() {
        return this.ml;
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        eg.b(this.ml, dataOut);
    }

    public String getPrimaryCategory() {
        return this.mm;
    }

    public String getSecondaryCategory() {
        return this.mn;
    }

    public String getDescription() {
        return this.mo;
    }

    public void getDescription(CharArrayBuffer dataOut) {
        eg.b(this.mo, dataOut);
    }

    public String getDeveloperName() {
        return this.mp;
    }

    public void getDeveloperName(CharArrayBuffer dataOut) {
        eg.b(this.mp, dataOut);
    }

    public Uri getIconImageUri() {
        return this.mq;
    }

    public Uri getHiResImageUri() {
        return this.mr;
    }

    public Uri getFeaturedImageUri() {
        return this.ms;
    }

    public boolean isPlayEnabledGame() {
        return this.mt;
    }

    public boolean isInstanceInstalled() {
        return this.mu;
    }

    public String getInstancePackageName() {
        return this.mv;
    }

    public int getGameplayAclStatus() {
        return this.mw;
    }

    public int getAchievementTotalCount() {
        return this.mx;
    }

    public int getLeaderboardCount() {
        return this.my;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return dl.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.isPlayEnabledGame(), game.isInstanceInstalled(), game.getInstancePackageName(), game.getGameplayAclStatus(), game.getAchievementTotalCount(), game.getLeaderboardCount());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return dl.equal(game2.getApplicationId(), game.getApplicationId()) && dl.equal(game2.getDisplayName(), game.getDisplayName()) && dl.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && dl.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && dl.equal(game2.getDescription(), game.getDescription()) && dl.equal(game2.getDeveloperName(), game.getDeveloperName()) && dl.equal(game2.getIconImageUri(), game.getIconImageUri()) && dl.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && dl.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && dl.equal(game2.isPlayEnabledGame(), game.isPlayEnabledGame()) && dl.equal(game2.isInstanceInstalled(), game.isInstanceInstalled()) && dl.equal(game2.getInstancePackageName(), game.getInstancePackageName()) && dl.equal(game2.getGameplayAclStatus(), game.getGameplayAclStatus()) && dl.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && dl.equal(game2.getLeaderboardCount(), game.getLeaderboardCount());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return dl.d(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("HiResImageUri", game.getHiResImageUri()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("PlayEnabledGame", game.isPlayEnabledGame()).a("InstanceInstalled", game.isInstanceInstalled()).a("InstancePackageName", game.getInstancePackageName()).a("GameplayAclStatus", game.getGameplayAclStatus()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.aX()) {
            com.google.android.gms.games.a.a(this, dest, flags);
        } else {
            dest.writeString(this.mk);
            dest.writeString(this.ml);
            dest.writeString(this.mm);
            dest.writeString(this.mn);
            dest.writeString(this.mo);
            dest.writeString(this.mp);
            dest.writeString(this.mq == null ? null : this.mq.toString());
            dest.writeString(this.mr == null ? null : this.mr.toString());
            dest.writeString(this.ms == null ? null : this.ms.toString());
            dest.writeInt(this.mt ? 1 : 0);
            dest.writeInt(this.mu ? 1 : 0);
            dest.writeString(this.mv);
            dest.writeInt(this.mw);
            dest.writeInt(this.mx);
            dest.writeInt(this.my);
        }
    }

    static final class a
    extends com.google.android.gms.games.a {
        a() {
        }

        public GameEntity t(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.aW());
            if (bl2 || GameEntity.y(GameEntity.class.getCanonicalName())) {
                return super.t(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            return new GameEntity(1, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl3, bl4, string11, n2, n3, n4);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.t(x0);
        }
    }
}

